/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.ai.goal.builtin.creature;

import com.google.common.base.Preconditions;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import org.spongepowered.api.entity.ai.goal.builtin.creature.RangedAttackAgainstAgentGoal;
import org.spongepowered.api.entity.living.Ranger;

public final class SpongeRangedAttackAgainstAgentGoalBuilder
implements RangedAttackAgainstAgentGoal.Builder {
    private double maxSpeed;
    private int delayBetweenAttacks;
    private float attackRadius;

    public SpongeRangedAttackAgainstAgentGoalBuilder() {
        this.reset();
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder moveSpeed(double speed) {
        this.maxSpeed = speed;
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder delayBetweenAttacks(int delay) {
        this.delayBetweenAttacks = delay;
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder attackRadius(float radius) {
        this.attackRadius = radius;
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder from(RangedAttackAgainstAgentGoal value) {
        Preconditions.checkNotNull((Object)value);
        this.maxSpeed = value.getMoveSpeed();
        this.delayBetweenAttacks = value.getDelayBetweenAttacks();
        this.attackRadius = value.getAttackRadius();
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal.Builder reset() {
        this.maxSpeed = 1.25;
        this.delayBetweenAttacks = 20;
        this.attackRadius = 10.0f;
        return this;
    }

    @Override
    public RangedAttackAgainstAgentGoal build(Ranger owner) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkArgument((boolean)(owner instanceof IRangedAttackMob), (Object)"Ranger must be an IRangedAttackMob!");
        return (RangedAttackAgainstAgentGoal)new RangedAttackGoal((IRangedAttackMob)owner, this.maxSpeed, this.delayBetweenAttacks, this.attackRadius);
    }
}

