/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.living.human;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SDestroyEntitiesPacket;
import net.minecraft.network.play.server.SPlayerListItemPacket;
import net.minecraft.network.play.server.SSpawnPlayerPacket;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scheduler.Task;
import org.spongepowered.api.scoreboard.TeamMember;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.entity.LivingEntityAccessor;
import org.spongepowered.common.accessor.entity.player.PlayerEntityAccessor;
import org.spongepowered.common.accessor.network.play.server.SPlayerListItemPacketAccessor;
import org.spongepowered.common.accessor.network.play.server.SSpawnPlayerPacketAccessor;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.util.SpongeTicks;

public final class HumanEntity
extends CreatureEntity
implements TeamMember,
IRangedAttackMob {
    private final Map<UUID, List<Stream<IPacket<?>>>> playerPacketMap = new HashMap();
    private GameProfile fakeProfile = new GameProfile(this.entityUniqueID, "");
    private boolean aiDisabled = false;
    private boolean leftHanded = false;

    public HumanEntity(EntityType<? extends HumanEntity> type, World worldIn) {
        super(type, worldIn);
        this.setCanPickUpLoot(true);
    }

    protected void registerAttributes() {
        super.registerAttributes();
        this.getAttributes().registerAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).setBaseValue(1.0);
        this.getAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).setBaseValue((double)0.23f);
        this.getAttributes().registerAttribute(SharedMonsterAttributes.ATTACK_SPEED);
        this.getAttributes().registerAttribute(SharedMonsterAttributes.LUCK);
    }

    protected void registerData() {
        this.dataManager.register(LivingEntityAccessor.accessor$getLivingFlags(), (Object)0);
        this.dataManager.register(LivingEntityAccessor.accessor$getHealth(), (Object)Float.valueOf(1.0f));
        this.dataManager.register(LivingEntityAccessor.accessor$getPotionEffects(), (Object)0);
        this.dataManager.register(LivingEntityAccessor.accessor$getHideParticles(), (Object)Boolean.FALSE);
        this.dataManager.register(LivingEntityAccessor.accessor$getArrowCountInEntity(), (Object)0);
        this.dataManager.register(LivingEntityAccessor.accessor$getBeeStringCount(), (Object)0);
        this.dataManager.register(LivingEntityAccessor.accessor$getBedPosition(), Optional.empty());
        this.dataManager.register(PlayerEntityAccessor.accessor$getAbsorption(), (Object)Float.valueOf(0.0f));
        this.dataManager.register(PlayerEntityAccessor.accessor$getPlayerScore(), (Object)0);
        this.dataManager.register(PlayerEntityAccessor.accessor$getPlayerModelFlag(), (Object)127);
        this.dataManager.register(PlayerEntityAccessor.accessor$getMainHand(), (Object)1);
        this.dataManager.register(PlayerEntityAccessor.accessor$getLeftShoulderEntity(), (Object)new CompoundNBT());
        this.dataManager.register(PlayerEntityAccessor.accessor$getRightShoulderEntity(), (Object)new CompoundNBT());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new SwimGoal((MobEntity)this));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
    }

    public boolean isLeftHanded() {
        return this.leftHanded;
    }

    public boolean isAIDisabled() {
        return this.aiDisabled;
    }

    @Override
    public Component getTeamRepresentation() {
        return Component.text((String)this.fakeProfile.getName());
    }

    public Team getTeam() {
        return this.world.getScoreboard().getPlayersTeam(this.fakeProfile.getName());
    }

    public void setCustomName(@Nullable ITextComponent name) {
        ITextComponent customName = this.getCustomName();
        if (customName == null && name == null || customName != null && customName.equals(name)) {
            return;
        }
        super.setCustomName(name);
        this.setProfileName(name);
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    public void readAdditional(CompoundNBT compound) {
        super.readAdditional(compound);
        if (compound.contains("profile")) {
            this.fakeProfile = NBTUtil.readGameProfile((CompoundNBT)compound.getCompound("profile"));
        }
    }

    public void writeAdditional(CompoundNBT compound) {
        super.writeAdditional(compound);
        CompoundNBT profileCompound = new CompoundNBT();
        NBTUtil.writeGameProfile((CompoundNBT)profileCompound, (GameProfile)this.fakeProfile);
        compound.put("profile", (INBT)profileCompound);
    }

    public void livingTick() {
        super.livingTick();
        this.updateArmSwingProgress();
    }

    public void setNoAI(boolean disable) {
        this.aiDisabled = disable;
    }

    public void setLeftHanded(boolean leftHanded) {
        this.leftHanded = leftHanded;
    }

    public void setAggroed(boolean hasAggro) {
    }

    public int getMaxInPortalTime() {
        return 1;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.ENTITY_PLAYER_SWIM;
    }

    protected SoundEvent getSplashSound() {
        return SoundEvents.ENTITY_PLAYER_SPLASH;
    }

    public int getPortalCooldown() {
        return 10;
    }

    public void onDeath(@Nullable DamageSource cause) {
        super.onDeath(cause);
        this.recenterBoundingBox();
        if (cause != null) {
            this.setMotion(-MathHelper.cos((float)((this.attackedAtYaw + this.rotationYaw) * ((float)Math.PI / 180))) * 0.1f, 0.1f, -MathHelper.sin((float)((this.attackedAtYaw + this.rotationYaw) * ((float)Math.PI / 180))) * 0.1f);
        } else {
            this.setMotion(0.0, 0.1, 0.0);
        }
        this.extinguish();
        this.setFlag(0, false);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.ENTITY_PLAYER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ENTITY_PLAYER_DEATH;
    }

    public double getYOffset() {
        return -0.35;
    }

    public float getAIMoveSpeed() {
        return (float)this.getAttribute(SharedMonsterAttributes.MOVEMENT_SPEED).getValue();
    }

    protected SoundEvent getFallSound(int height) {
        return height > 4 ? SoundEvents.ENTITY_PLAYER_BIG_FALL : SoundEvents.ENTITY_PLAYER_SMALL_FALL;
    }

    public float getAbsorptionAmount() {
        return ((Float)this.getDataManager().get(PlayerEntityAccessor.accessor$getAbsorption())).floatValue();
    }

    public void setAbsorptionAmount(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.getDataManager().set(PlayerEntityAccessor.accessor$getAbsorption(), (Object)Float.valueOf(amount));
    }

    protected float updateDistance(float p_110146_1_, float p_110146_2_) {
        float retValue = super.updateDistance(p_110146_1_, p_110146_2_);
        this.rotationYaw = this.rotationYawHead;
        return retValue;
    }

    public boolean attackEntityAsMob(Entity entityIn) {
        super.attackEntityAsMob(entityIn);
        this.swingArm(this.getActiveHand());
        float f = (float)this.getAttribute(SharedMonsterAttributes.ATTACK_DAMAGE).getValue();
        int i = 0;
        i += EnchantmentHelper.getKnockbackModifier((LivingEntity)this);
        boolean flag = entityIn.attackEntityFrom(DamageSource.causeMobDamage((LivingEntity)this), f += EnchantmentHelper.getModifierForCreature((ItemStack)this.getHeldItem(Hand.MAIN_HAND), (CreatureAttribute)this.getCreatureAttribute()));
        if (flag) {
            int j;
            if (i > 0) {
                entityIn.addVelocity((double)(-MathHelper.sin((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.cos((float)(this.rotationYaw * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.setMotion(this.getMotion().mul(0.6, 1.0, 0.6));
            }
            if ((j = EnchantmentHelper.getFireAspectModifier((LivingEntity)this)) > 0) {
                entityIn.setFire(j * 4);
            }
            this.applyEnchantments((LivingEntity)this, entityIn);
        }
        return flag;
    }

    private void setProfileName(@Nullable ITextComponent newName) {
        PropertyMap props = this.fakeProfile.getProperties();
        this.fakeProfile = new GameProfile(this.fakeProfile.getId(), newName == null ? "" : newName.getString());
        this.fakeProfile.getProperties().putAll((Multimap)props);
    }

    public boolean getOrLoadSkin(UUID minecraftAccount) {
        GameProfile gameProfile = SpongeCommon.getServer().getPlayerProfileCache().getProfileByUUID(minecraftAccount);
        if (gameProfile == null) {
            gameProfile = SpongeCommon.getServer().getMinecraftSessionService().fillProfileProperties(new GameProfile(minecraftAccount, ""), true);
            if (gameProfile == null) {
                return false;
            }
            SpongeCommon.getServer().getPlayerProfileCache().addEntry(gameProfile);
        }
        this.fakeProfile.getProperties().replaceValues((Object)"textures", (Iterable)gameProfile.getProperties().get((Object)"textures"));
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    public boolean getOrLoadSkin(String minecraftAccount) {
        Objects.requireNonNull(minecraftAccount);
        GameProfile gameProfile = SpongeCommon.getServer().getPlayerProfileCache().getGameProfileForUsername(minecraftAccount);
        if (gameProfile == null) {
            return false;
        }
        if (gameProfile.getProperties().isEmpty()) {
            gameProfile = SpongeCommon.getServer().getMinecraftSessionService().fillProfileProperties(gameProfile, true);
            SpongeCommon.getServer().getPlayerProfileCache().addEntry(gameProfile);
        }
        this.fakeProfile.getProperties().clear();
        this.fakeProfile.getProperties().putAll((Multimap)gameProfile.getProperties());
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    public void removeFromTabListDelayed(@Nullable ServerPlayerEntity player, SPlayerListItemPacket removePacket) {
        int delay = ((WorldConfig)SpongeGameConfigs.getForWorld(this.world).get()).getEntity().getHumanPlayerListRemoveDelay();
        Runnable removeTask = () -> this.pushPackets(player, new IPacket[]{removePacket});
        if (delay == 0) {
            removeTask.run();
        } else {
            Sponge.getServer().getScheduler().submit(Task.builder().execute(removeTask).delay(new SpongeTicks(delay)).plugin(((Launch)Launch.getInstance()).getCommonPlugin()).build());
        }
    }

    public Property getSkinProperty() {
        Collection properties = this.fakeProfile.getProperties().get((Object)"textures");
        if (properties.isEmpty()) {
            return null;
        }
        return (Property)properties.iterator().next();
    }

    public void setSkinProperty(Property property) {
        this.fakeProfile.getProperties().replaceValues((Object)"textures", Collections.singletonList(property));
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    private boolean isAliveAndInWorld() {
        return this.world.getEntityByID(this.getEntityId()) == this && !this.removed;
    }

    private void respawnOnClient() {
        this.pushPackets(new IPacket[]{new SDestroyEntitiesPacket(new int[]{this.getEntityId()}), this.createPlayerListPacket(SPlayerListItemPacket.Action.ADD_PLAYER)});
        this.pushPackets(new IPacket[]{this.createSpawnPacket()});
        this.removeFromTabListDelayed(null, this.createPlayerListPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER));
    }

    public boolean canRemoveFromListImmediately() {
        return !this.fakeProfile.getProperties().containsKey((Object)"textures");
    }

    public void untrackFrom(ServerPlayerEntity player) {
        this.playerPacketMap.remove(player.getUniqueID());
        player.connection.sendPacket((IPacket)this.createPlayerListPacket(SPlayerListItemPacket.Action.REMOVE_PLAYER));
    }

    public SSpawnPlayerPacket createSpawnPacket() {
        SSpawnPlayerPacket packet = new SSpawnPlayerPacket();
        SSpawnPlayerPacketAccessor accessor = (SSpawnPlayerPacketAccessor)packet;
        accessor.accessor$setEntityId(this.getEntityId());
        accessor.accessor$setUniqueId(this.fakeProfile.getId());
        accessor.accessor$setX(this.getPosX());
        accessor.accessor$setY(this.getPosY());
        accessor.accessor$setZ(this.getPosZ());
        accessor.accessor$setYaw((byte)(this.rotationYaw * 256.0f / 360.0f));
        accessor.accessor$setPitch((byte)(this.rotationPitch * 256.0f / 360.0f));
        return packet;
    }

    public SPlayerListItemPacket createPlayerListPacket(SPlayerListItemPacket.Action action) {
        SPlayerListItemPacket packet = new SPlayerListItemPacket(action, new ServerPlayerEntity[0]);
        List<SPlayerListItemPacket.AddPlayerData> list = ((SPlayerListItemPacketAccessor)packet).accessor$getPlayers();
        SPlayerListItemPacket sPlayerListItemPacket = packet;
        sPlayerListItemPacket.getClass();
        list.add(new SPlayerListItemPacket.AddPlayerData(sPlayerListItemPacket, this.fakeProfile, 0, GameType.NOT_SET, this.getDisplayName()));
        return packet;
    }

    public void pushPackets(IPacket<?> ... packets) {
        this.pushPackets((ServerPlayerEntity)null, packets);
    }

    public void pushPackets(@Nullable ServerPlayerEntity player, IPacket<?> ... packets) {
        List queue = player == null ? this.playerPacketMap.computeIfAbsent(null, k -> new ArrayList()) : this.playerPacketMap.computeIfAbsent(player.getUniqueID(), k -> new ArrayList());
        queue.add(Stream.of(packets));
    }

    public Stream<IPacket<?>> popQueuedPackets(@Nullable ServerPlayerEntity player) {
        List<Stream<IPacket<?>>> queue = this.playerPacketMap.get(player == null ? null : player.getUniqueID());
        return queue == null || queue.isEmpty() ? Stream.empty() : queue.remove(0);
    }

    public void attackEntityWithRangedAttack(LivingEntity target, float distanceFactor) {
        ItemStack itemstack;
        ArrowEntity entitytippedarrow = new ArrowEntity(this.world, (LivingEntity)this);
        double d0 = target.getPosX() - this.getPosX();
        double d1 = target.getBoundingBox().minY + (double)(target.getHeight() / 3.0f) - entitytippedarrow.getPosY();
        double d2 = target.getPosZ() - this.getPosZ();
        double d3 = MathHelper.sqrt((double)(d0 * d0 + d2 * d2));
        entitytippedarrow.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.world.getDifficulty().getId() * 4));
        int i = EnchantmentHelper.getMaxEnchantmentLevel((Enchantment)Enchantments.PUNCH, (LivingEntity)this);
        int j = EnchantmentHelper.getMaxEnchantmentLevel((Enchantment)Enchantments.FLAME, (LivingEntity)this);
        entitytippedarrow.setDamage((double)(distanceFactor * 2.0f) + this.rand.nextGaussian() * 0.25 + (double)((float)this.world.getDifficulty().getId() * 0.11f));
        if (i > 0) {
            entitytippedarrow.setDamage(entitytippedarrow.getDamage() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entitytippedarrow.setKnockbackStrength(j);
        }
        if ((itemstack = this.getHeldItem(Hand.OFF_HAND)).getItem() == Items.TIPPED_ARROW) {
            entitytippedarrow.setPotionEffect(itemstack);
        }
        this.playSound(SoundEvents.ENTITY_ARROW_SHOOT, 1.0f, 1.0f / (this.getRNG().nextFloat() * 0.4f + 0.8f));
        this.world.addEntity((Entity)entitytippedarrow);
    }
}

