/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.player;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import org.spongepowered.common.entity.player.SpongeUser;

public class SpongeUserInventory
implements IInventory {
    final NonNullList<ItemStack> mainInventory = NonNullList.withSize((int)36, (Object)ItemStack.EMPTY);
    final NonNullList<ItemStack> armorInventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    final NonNullList<ItemStack> offHandInventory = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    private final List<NonNullList<ItemStack>> allInventories = Arrays.asList(this.mainInventory, this.armorInventory, this.offHandInventory);
    public int currentItem;
    public SpongeUser user;
    private boolean dirty = false;

    public SpongeUserInventory(SpongeUser playerIn) {
        this.user = playerIn;
    }

    public ItemStack getCurrentItem() {
        return PlayerInventory.isHotbar((int)this.currentItem) ? (ItemStack)this.mainInventory.get(this.currentItem) : ItemStack.EMPTY;
    }

    public ItemStack decrStackSize(int index, int count) {
        this.markDirty();
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (index < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            index -= nonnulllist.size();
        }
        return list != null && !((ItemStack)list.get(index)).isEmpty() ? ItemStackHelper.getAndSplit(list, (int)index, (int)count) : ItemStack.EMPTY;
    }

    public ItemStack removeStackFromSlot(int index) {
        this.markDirty();
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (index < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            index -= nonnulllist1.size();
        }
        if (nonnulllist != null && !((ItemStack)nonnulllist.get(index)).isEmpty()) {
            ItemStack itemstack = (ItemStack)nonnulllist.get(index);
            nonnulllist.set(index, (Object)ItemStack.EMPTY);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public void setInventorySlotContents(int index, ItemStack stack) {
        this.markDirty();
        NonNullList<ItemStack> nonnulllist = null;
        for (NonNullList<ItemStack> nonnulllist1 : this.allInventories) {
            if (index < nonnulllist1.size()) {
                nonnulllist = nonnulllist1;
                break;
            }
            index -= nonnulllist1.size();
        }
        if (nonnulllist != null) {
            nonnulllist.set(index, (Object)stack);
        }
    }

    public ListNBT writeToNBT(ListNBT nbtTagListIn) {
        for (int i = 0; i < this.mainInventory.size(); ++i) {
            if (((ItemStack)this.mainInventory.get(i)).isEmpty()) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.putByte("Slot", (byte)i);
            ((ItemStack)this.mainInventory.get(i)).write(nbttagcompound);
            nbtTagListIn.add((Object)nbttagcompound);
        }
        for (int j = 0; j < this.armorInventory.size(); ++j) {
            if (((ItemStack)this.armorInventory.get(j)).isEmpty()) continue;
            CompoundNBT nbttagcompound1 = new CompoundNBT();
            nbttagcompound1.putByte("Slot", (byte)(j + 100));
            ((ItemStack)this.armorInventory.get(j)).write(nbttagcompound1);
            nbtTagListIn.add((Object)nbttagcompound1);
        }
        for (int k = 0; k < this.offHandInventory.size(); ++k) {
            if (((ItemStack)this.offHandInventory.get(k)).isEmpty()) continue;
            CompoundNBT nbttagcompound2 = new CompoundNBT();
            nbttagcompound2.putByte("Slot", (byte)(k + 150));
            ((ItemStack)this.offHandInventory.get(k)).write(nbttagcompound2);
            nbtTagListIn.add((Object)nbttagcompound2);
        }
        this.dirty = false;
        return nbtTagListIn;
    }

    public void readFromNBT(ListNBT nbtTagListIn) {
        this.mainInventory.clear();
        this.armorInventory.clear();
        this.offHandInventory.clear();
        for (int i = 0; i < nbtTagListIn.size(); ++i) {
            CompoundNBT nbttagcompound = nbtTagListIn.getCompound(i);
            int j = nbttagcompound.getByte("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.read((CompoundNBT)nbttagcompound);
            if (itemstack.isEmpty()) continue;
            if (j >= 0 && j < this.mainInventory.size()) {
                this.mainInventory.set(j, (Object)itemstack);
                continue;
            }
            if (j >= 100 && j < this.armorInventory.size() + 100) {
                this.armorInventory.set(j - 100, (Object)itemstack);
                continue;
            }
            if (j < 150 || j >= this.offHandInventory.size() + 150) continue;
            this.offHandInventory.set(j - 150, (Object)itemstack);
        }
    }

    public int getSizeInventory() {
        return this.mainInventory.size() + this.armorInventory.size() + this.offHandInventory.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.mainInventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack1 : this.armorInventory) {
            if (itemstack1.isEmpty()) continue;
            return false;
        }
        for (ItemStack itemstack2 : this.offHandInventory) {
            if (itemstack2.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getStackInSlot(int index) {
        NonNullList<ItemStack> list = null;
        for (NonNullList<ItemStack> nonnulllist : this.allInventories) {
            if (index < nonnulllist.size()) {
                list = nonnulllist;
                break;
            }
            index -= nonnulllist.size();
        }
        return list == null ? ItemStack.EMPTY : (ItemStack)list.get(index);
    }

    public void markDirty() {
        this.dirty = true;
        this.user.markDirty();
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        return true;
    }

    public void clear() {
        for (List list : this.allInventories) {
            list.clear();
        }
    }
}

