/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.projectile;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.item.EnderPearlEntity;
import net.minecraft.entity.item.ExperienceBottleEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.entity.projectile.DragonFireballEntity;
import net.minecraft.entity.projectile.EggEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.LlamaSpitEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.entity.projectile.SmallFireballEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.entity.projectile.SpectralArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.entity.projectile.WitherSkullEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.entity.carrier.Dispenser;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.EntityTypes;
import org.spongepowered.api.entity.living.golem.Shulker;
import org.spongepowered.api.entity.projectile.Egg;
import org.spongepowered.api.entity.projectile.EnderPearl;
import org.spongepowered.api.entity.projectile.ExperienceBottle;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.entity.projectile.LlamaSpit;
import org.spongepowered.api.entity.projectile.Potion;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.entity.projectile.Snowball;
import org.spongepowered.api.entity.projectile.arrow.Arrow;
import org.spongepowered.api.entity.projectile.arrow.SpectralArrow;
import org.spongepowered.api.entity.projectile.explosive.FireworkRocket;
import org.spongepowered.api.entity.projectile.explosive.WitherSkull;
import org.spongepowered.api.entity.projectile.explosive.fireball.DragonFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.ExplosiveFireball;
import org.spongepowered.api.entity.projectile.explosive.fireball.SmallFireball;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.entity.projectile.DispenserSourceLogic;
import org.spongepowered.common.entity.projectile.ProjectileLogic;
import org.spongepowered.common.entity.projectile.ProjectileSourceLogic;
import org.spongepowered.common.entity.projectile.ShulkerSourceLogic;
import org.spongepowered.common.entity.projectile.SimpleDispenserLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleEntityLaunchLogic;
import org.spongepowered.common.entity.projectile.SimpleItemLaunchLogic;
import org.spongepowered.math.vector.Vector3d;

public final class ProjectileUtil {
    private static final Map<ResourceKey, ProjectileLogic<?>> projectileLogic = Maps.newHashMap();
    private static final Map<Class<? extends ProjectileSource>, ProjectileSourceLogic<?>> projectileSourceLogic = Maps.newHashMap();

    public static <T extends Projectile> Optional<T> launch(EntityType<T> projectileType, ProjectileSource source, @Nullable Vector3d vel) {
        ProjectileLogic<T> logic = ProjectileUtil.getLogic(projectileType);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = logic.launch(source);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, vel);
            }
            t.offer(Keys.SHOOTER, source);
        });
        return projectile;
    }

    public static <T extends Projectile, S extends ProjectileSource> Optional<T> launchWithArgs(EntityType<T> projectileType, Class<S> projectileSourceClass, S source, @Nullable Vector3d vel, Object ... args) {
        ProjectileSourceLogic<S> sourceLogic = ProjectileUtil.getSourceLogic(projectileSourceClass);
        if (sourceLogic == null) {
            return Optional.empty();
        }
        ProjectileLogic<T> logic = ProjectileUtil.getLogic(projectileType);
        if (logic == null) {
            return Optional.empty();
        }
        Optional<Projectile> projectile = sourceLogic.launch(logic, source, projectileType, args);
        projectile.ifPresent(t -> {
            if (vel != null) {
                t.offer(Keys.VELOCITY, vel);
            }
            t.offer(Keys.SHOOTER, source);
        });
        return projectile;
    }

    private static void configureThrowable(ThrowableEntity entity) {
        double x = entity.getPosX() - (double)(MathHelper.cos((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        double y = entity.getPosY() - 0.1;
        double z = entity.getPosZ() - (double)(MathHelper.sin((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        entity.setPosition(x, y, z);
        float f = 0.4f;
        double motionX = -MathHelper.sin((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * 0.4f;
        double motionZ = MathHelper.cos((float)(entity.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * 0.4f;
        double motionY = -MathHelper.sin((float)(entity.rotationPitch / 180.0f * (float)Math.PI)) * 0.4f;
        entity.setMotion(motionX, motionY, motionZ);
    }

    public static <T extends Projectile> void registerProjectileLogic(Supplier<EntityType<T>> projectileType, ProjectileLogic<T> logic) {
        projectileLogic.put(projectileType.get().key(), logic);
    }

    public static <T extends ProjectileSource> void registerProjectileSourceLogic(Class<T> projectileSourceClass, ProjectileSourceLogic<T> logic) {
        projectileSourceLogic.put(projectileSourceClass, logic);
    }

    static <T extends ProjectileSource> ProjectileSourceLogic<T> getSourceLogic(Class<T> sourceClass) {
        return projectileSourceLogic.get(sourceClass);
    }

    private static <T extends Projectile> ProjectileLogic<T> getLogic(EntityType<T> projectileType) {
        return projectileLogic.get(projectileType.key());
    }

    static <P extends Projectile> Optional<P> defaultLaunch(ProjectileSource source, EntityType<P> projectileType, ServerLocation loc) {
        Entity projectile = ((ServerWorld)loc.getWorld()).createEntity(projectileType, loc.getPosition());
        if (projectile instanceof ThrowableEntity) {
            ProjectileUtil.configureThrowable((ThrowableEntity)projectile);
        }
        return ProjectileUtil.doLaunch(loc.getWorld(), (Projectile)projectile);
    }

    static <P extends Projectile> Optional<P> doLaunch(World extent, P projectile) {
        if (extent.spawnEntity(projectile)) {
            return Optional.of(projectile);
        }
        return Optional.empty();
    }

    static {
        ProjectileUtil.registerProjectileSourceLogic(Dispenser.class, new DispenserSourceLogic());
        ProjectileUtil.registerProjectileSourceLogic(Shulker.class, new ShulkerSourceLogic());
        ProjectileUtil.registerProjectileLogic(EntityTypes.ARROW, new SimpleItemLaunchLogic<Arrow>(EntityTypes.ARROW, Items.ARROW){

            @Override
            protected Optional<Arrow> createProjectile(LivingEntity source, ServerLocation loc) {
                ArrowEntity arrow = new ArrowEntity(source.world, source);
                arrow.shoot((net.minecraft.entity.Entity)source, source.rotationPitch, source.rotationYaw, 0.0f, 3.0f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (Arrow)arrow);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SPECTRAL_ARROW, new SimpleItemLaunchLogic<SpectralArrow>(EntityTypes.SPECTRAL_ARROW, Items.SPECTRAL_ARROW){

            @Override
            protected Optional<SpectralArrow> createProjectile(LivingEntity source, ServerLocation loc) {
                SpectralArrowEntity arrow = new SpectralArrowEntity(source.world, source);
                arrow.shoot((net.minecraft.entity.Entity)source, source.rotationPitch, source.rotationYaw, 0.0f, 3.0f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (SpectralArrow)arrow);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EGG, new SimpleItemLaunchLogic<Egg>(EntityTypes.EGG, Items.EGG){

            @Override
            protected Optional<Egg> createProjectile(LivingEntity source, ServerLocation loc) {
                EggEntity egg = new EggEntity(source.world, source);
                egg.shoot((net.minecraft.entity.Entity)source, source.rotationPitch, source.rotationYaw, 0.0f, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (Egg)egg);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SMALL_FIREBALL, new SimpleItemLaunchLogic<SmallFireball>(EntityTypes.SMALL_FIREBALL, Items.FIRE_CHARGE){

            @Override
            protected Optional<SmallFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vec3d lookVec = source.getLook(1.0f);
                SmallFireballEntity fireball = new SmallFireballEntity(source.world, source, lookVec.x * 4.0, lookVec.y * 4.0, lookVec.z * 4.0);
                fireball.setPosition(fireball.getPosX(), fireball.getPosY() + (double)source.getEyeHeight(), fireball.getPosZ());
                return ProjectileUtil.doLaunch(loc.getWorld(), (SmallFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.FIREWORK_ROCKET, new SimpleItemLaunchLogic<FireworkRocket>(EntityTypes.FIREWORK_ROCKET, Items.FIREWORK_ROCKET){

            @Override
            protected Optional<FireworkRocket> createProjectile(LivingEntity source, ServerLocation loc) {
                FireworkRocketEntity firework = new FireworkRocketEntity(source.world, loc.getX(), loc.getY(), loc.getZ(), ItemStack.EMPTY);
                return ProjectileUtil.doLaunch(loc.getWorld(), (FireworkRocket)firework);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SNOWBALL, new SimpleItemLaunchLogic<Snowball>(EntityTypes.SNOWBALL, Items.SNOWBALL){

            @Override
            protected Optional<Snowball> createProjectile(LivingEntity source, ServerLocation loc) {
                SnowballEntity snowball = new SnowballEntity(source.world, source);
                snowball.shoot((net.minecraft.entity.Entity)source, source.rotationPitch, source.rotationYaw, 0.0f, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (Snowball)snowball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EXPERIENCE_BOTTLE, new SimpleItemLaunchLogic<ExperienceBottle>(EntityTypes.EXPERIENCE_BOTTLE, Items.EXPERIENCE_BOTTLE){

            @Override
            protected Optional<ExperienceBottle> createProjectile(LivingEntity source, ServerLocation loc) {
                ExperienceBottleEntity expBottle = new ExperienceBottleEntity(source.world, source);
                expBottle.shoot((net.minecraft.entity.Entity)source, source.rotationPitch, source.rotationYaw, -20.0f, 0.7f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (ExperienceBottle)expBottle);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.ENDER_PEARL, new SimpleItemLaunchLogic<EnderPearl>(EntityTypes.ENDER_PEARL, Items.ENDER_PEARL){

            @Override
            protected Optional<EnderPearl> createProjectile(LivingEntity source, ServerLocation loc) {
                EnderPearlEntity pearl = new EnderPearlEntity(source.world, source);
                pearl.shoot((net.minecraft.entity.Entity)source, source.rotationPitch, source.rotationYaw, 0.0f, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (EnderPearl)pearl);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.FIREBALL, new SimpleDispenserLaunchLogic<ExplosiveFireball>(EntityTypes.FIREBALL){

            @Override
            protected Optional<ExplosiveFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vec3d lookVec = source.getLook(1.0f);
                FireballEntity fireball = new FireballEntity(source.world, source, lookVec.x * 4.0, lookVec.y * 4.0, lookVec.z * 4.0);
                fireball.setPosition(fireball.getPosX(), fireball.getPosY() + (double)source.getEyeHeight(), fireball.getPosZ());
                return ProjectileUtil.doLaunch(loc.getWorld(), (ExplosiveFireball)fireball);
            }

            @Override
            public Optional<ExplosiveFireball> createProjectile(ProjectileSource source, EntityType<ExplosiveFireball> projectileType, ServerLocation loc) {
                if (!(source instanceof DispenserTileEntity)) {
                    return super.createProjectile(source, projectileType, loc);
                }
                DispenserTileEntity dispenser = (DispenserTileEntity)source;
                Direction enumfacing = DispenserSourceLogic.getFacing(dispenser);
                ArmorStandEntity thrower = new ArmorStandEntity(dispenser.getWorld(), loc.getX() + (double)enumfacing.getXOffset(), loc.getY() + (double)enumfacing.getYOffset(), loc.getZ() + (double)enumfacing.getZOffset());
                FireballEntity fireball = new FireballEntity(dispenser.getWorld(), (LivingEntity)thrower, 0.0, 0.0, 0.0);
                fireball.accelerationX = (double)enumfacing.getXOffset() * 0.1;
                fireball.accelerationY = (double)enumfacing.getYOffset() * 0.1;
                fireball.accelerationZ = (double)enumfacing.getZOffset() * 0.1;
                return ProjectileUtil.doLaunch(loc.getWorld(), (ExplosiveFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.WITHER_SKULL, new SimpleDispenserLaunchLogic<WitherSkull>(EntityTypes.WITHER_SKULL){

            @Override
            protected Optional<WitherSkull> createProjectile(LivingEntity source, ServerLocation loc) {
                Vec3d lookVec = source.getLook(1.0f);
                WitherSkullEntity skull = new WitherSkullEntity(source.world, source, lookVec.x * 4.0, lookVec.y * 4.0, lookVec.z * 4.0);
                skull.setPosition(skull.getPosX(), skull.getPosY() + (double)source.getEyeHeight(), skull.getPosZ());
                return ProjectileUtil.doLaunch(loc.getWorld(), (WitherSkull)skull);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.EYE_OF_ENDER, new SimpleDispenserLaunchLogic(EntityTypes.EYE_OF_ENDER));
        ProjectileUtil.registerProjectileLogic(EntityTypes.FISHING_BOBBER, new SimpleDispenserLaunchLogic<FishingBobber>(EntityTypes.FISHING_BOBBER){

            @Override
            protected Optional<FishingBobber> createProjectile(LivingEntity source, ServerLocation loc) {
                if (source instanceof PlayerEntity) {
                    FishingBobberEntity hook = new FishingBobberEntity(source.world, (PlayerEntity)source, loc.getX(), loc.getY(), loc.getZ());
                    return ProjectileUtil.doLaunch(loc.getWorld(), (FishingBobber)hook);
                }
                return super.createProjectile(source, loc);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.POTION, new SimpleItemLaunchLogic<Potion>(EntityTypes.POTION, Items.SPLASH_POTION){

            @Override
            protected Optional<Potion> createProjectile(LivingEntity source, ServerLocation loc) {
                PotionEntity potion = new PotionEntity(source.world, source);
                potion.setItem(new ItemStack((IItemProvider)Items.SPLASH_POTION, 1));
                potion.shoot((net.minecraft.entity.Entity)source, source.rotationPitch, source.rotationYaw, -20.0f, 0.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (Potion)potion);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.LLAMA_SPIT, new SimpleEntityLaunchLogic<LlamaSpit>(EntityTypes.LLAMA_SPIT){

            @Override
            public Optional<LlamaSpit> launch(ProjectileSource source) {
                if (!(source instanceof LlamaEntity)) {
                    return Optional.empty();
                }
                return super.launch(source);
            }

            @Override
            public Optional<LlamaSpit> createProjectile(ProjectileSource source, EntityType<LlamaSpit> projectileType, ServerLocation loc) {
                LlamaEntity llama = (LlamaEntity)source;
                LlamaSpitEntity llamaSpit = new LlamaSpitEntity(llama.world, (LlamaEntity)source);
                Vec3d lookVec = llama.getLook(1.0f);
                llamaSpit.shoot(lookVec.x, lookVec.y, lookVec.z, 1.5f, 0.0f);
                return ProjectileUtil.doLaunch(loc.getWorld(), (LlamaSpit)llamaSpit);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.DRAGON_FIREBALL, new SimpleDispenserLaunchLogic<DragonFireball>(EntityTypes.DRAGON_FIREBALL){

            @Override
            protected Optional<DragonFireball> createProjectile(LivingEntity source, ServerLocation loc) {
                Vec3d lookVec = source.getLook(1.0f);
                DragonFireballEntity fireball = new DragonFireballEntity(source.world, source, lookVec.x * 4.0, lookVec.y * 4.0, lookVec.z * 4.0);
                fireball.setPosition(fireball.getPosX(), fireball.getPosY() + (double)source.getEyeHeight(), fireball.getPosZ());
                return ProjectileUtil.doLaunch(loc.getWorld(), (DragonFireball)fireball);
            }
        });
        ProjectileUtil.registerProjectileLogic(EntityTypes.SHULKER_BULLET, new SimpleEntityLaunchLogic(EntityTypes.SHULKER_BULLET));
    }
}

