/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.leangen.geantyref.GenericTypeReflector;
import io.leangen.geantyref.TypeToken;
import java.lang.reflect.Type;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.common.event.SpongeEventContextKeyBuilder;

public final class SpongeEventContextKey<T>
implements EventContextKey<T> {
    private final ResourceKey key;
    private final Type allowed;

    SpongeEventContextKey(SpongeEventContextKeyBuilder<T> builder) {
        this.key = builder.key;
        this.allowed = builder.typeClass;
    }

    public SpongeEventContextKey(ResourceKey key, TypeToken<T> allowed) {
        this.key = (ResourceKey)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.allowed = ((TypeToken)Preconditions.checkNotNull(allowed, (Object)"allowed")).getType();
    }

    public SpongeEventContextKey(ResourceKey key, Class<T> allowed) {
        this.key = (ResourceKey)Preconditions.checkNotNull((Object)key, (Object)"key");
        this.allowed = (Type)Preconditions.checkNotNull(allowed, (Object)"allowed");
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }

    @Override
    public Type getAllowedType() {
        return this.allowed;
    }

    @Override
    public boolean isInstance(Object value) {
        return value != null && GenericTypeReflector.erase(this.allowed).isInstance(value);
    }

    @Override
    public T cast(Object value) {
        return (T)value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventContextKey)) {
            return false;
        }
        return this.key.equals(((EventContextKey)o).getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

