/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.DamageModifier;
import org.spongepowered.api.event.cause.entity.damage.DamageModifierTypes;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.item.inventory.ArmorEquipable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.accessor.entity.LivingEntityAccessor;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.event.cause.entity.damage.DamageObject;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;

public final class DamageEventHandler {
    public static final DoubleUnaryOperator HARD_HAT_FUNCTION = damage -> -(damage - damage * 0.75);
    private static double enchantmentDamageTracked;

    public static DoubleUnaryOperator createResistanceFunction(int resistanceAmplifier) {
        int base = (resistanceAmplifier + 1) * 5;
        int modifier = 25 - base;
        return damage -> -(damage - damage * (double)modifier / 25.0);
    }

    public static Optional<DamageFunction> createHardHatModifier(LivingEntity entityLivingBase, DamageSource damageSource) {
        if (damageSource instanceof FallingBlockDamageSource && !entityLivingBase.getItemStackFromSlot(EquipmentSlotType.HEAD).isEmpty()) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), ((ItemStack)entityLivingBase.getItemStackFromSlot(EquipmentSlotType.HEAD)).createSnapshot())).type(DamageModifierTypes.HARD_HAT).build();
            return Optional.of(new DamageFunction(modifier, HARD_HAT_FUNCTION));
        }
        return Optional.empty();
    }

    public static Optional<DamageFunction> createArmorModifiers(LivingEntity entityLivingBase, DamageSource damageSource) {
        if (!damageSource.isUnblockable()) {
            int totalArmorValue = entityLivingBase.getTotalArmorValue();
            float totalArmor = totalArmorValue;
            IAttributeInstance attribute = entityLivingBase.getAttribute(SharedMonsterAttributes.ARMOR_TOUGHNESS);
            double armorToughness = attribute.getValue();
            float f = 2.0f + (float)armorToughness / 4.0f;
            DoubleUnaryOperator function = incomingDamage -> {
                float f1 = MathHelper.clamp((float)(totalArmor - (float)incomingDamage / f), (float)(totalArmor * 0.2f), (float)20.0f);
                return -(incomingDamage - incomingDamage * (double)(1.0f - f1 / 25.0f));
            };
            Cause.Builder builder = Cause.builder();
            EventContext.Builder contextBuilder = EventContext.builder();
            if (entityLivingBase instanceof ArmorEquipable) {
                ItemStackSnapshot helmet = ((ArmorEquipable)entityLivingBase).getHead().createSnapshot();
                ItemStackSnapshot chest = ((ArmorEquipable)entityLivingBase).getChest().createSnapshot();
                ItemStackSnapshot legs = ((ArmorEquipable)entityLivingBase).getLegs().createSnapshot();
                ItemStackSnapshot itemStackSnapshot = ((ArmorEquipable)entityLivingBase).getFeet().createSnapshot();
            }
            DamageFunction armorModifier = DamageFunction.of(DamageModifier.builder().cause(Cause.of(EventContext.empty(), attribute, entityLivingBase)).type(DamageModifierTypes.ARMOR).build(), function);
            return Optional.of(armorModifier);
        }
        return Optional.empty();
    }

    public static Optional<DamageFunction> createResistanceModifier(LivingEntity entityLivingBase, DamageSource damageSource) {
        if (!damageSource.isDamageAbsolute() && entityLivingBase.isPotionActive(Effects.RESISTANCE) && damageSource != DamageSource.OUT_OF_WORLD) {
            PotionEffect effect = (PotionEffect)entityLivingBase.getActivePotionEffect(Effects.RESISTANCE);
            return Optional.of(new DamageFunction(DamageModifier.builder().cause(Cause.of(EventContext.empty(), effect)).type(DamageModifierTypes.DEFENSIVE_POTION_EFFECT).build(), DamageEventHandler.createResistanceFunction(effect.getAmplifier())));
        }
        return Optional.empty();
    }

    public static Optional<List<DamageFunction>> createEnchantmentModifiers(LivingEntity living, DamageSource damageSource) {
        if (!damageSource.isDamageAbsolute()) {
            Iterable inventory = living.getArmorInventoryList();
            if (EnchantmentHelper.getEnchantmentModifierDamage((Iterable)inventory, (DamageSource)damageSource) <= 0) {
                return Optional.empty();
            }
            ArrayList<DamageFunction> modifiers = new ArrayList<DamageFunction>();
            boolean first = true;
            int totalModifier = 0;
            for (net.minecraft.item.ItemStack itemStack : inventory) {
                if (itemStack.isEmpty()) continue;
                LinkedHashMultimap enchantments = LinkedHashMultimap.create();
                ListNBT enchantmentList = itemStack.getEnchantmentTagList();
                if (enchantmentList.isEmpty()) continue;
                for (int i = 0; i < enchantmentList.size(); ++i) {
                    int temp;
                    short enchantmentId = enchantmentList.getCompound(i).getShort("id");
                    short level = enchantmentList.getCompound(i).getShort("lvl");
                    Enchantment enchantment = (Enchantment)Registry.ENCHANTMENT.getByValue((int)enchantmentId);
                    if (enchantment == null || (temp = enchantment.calcModifierDamage((int)level, damageSource)) == 0) continue;
                    enchantments.put((Object)enchantment, (Object)level);
                }
                ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(itemStack);
                for (Map.Entry enchantment : enchantments.asMap().entrySet()) {
                    DamageObject object = new DamageObject();
                    int modifierTemp = 0;
                    Iterator iterator = ((Collection)enchantment.getValue()).iterator();
                    while (iterator.hasNext()) {
                        short level = (Short)iterator.next();
                        modifierTemp += ((Enchantment)enchantment.getKey()).calcModifierDamage((int)level, damageSource);
                    }
                    int modifier = modifierTemp;
                    object.previousDamage = totalModifier;
                    if (object.previousDamage > 25.0) {
                        object.previousDamage = 25.0;
                    }
                    totalModifier += modifier;
                    object.augment = first;
                    object.ratio = modifier;
                    DoubleUnaryOperator enchantmentFunction = damageIn -> {
                        if (object.augment) {
                            enchantmentDamageTracked = damageIn;
                        }
                        if (damageIn <= 0.0) {
                            return 0.0;
                        }
                        double actualDamage = enchantmentDamageTracked;
                        if (object.previousDamage > 25.0) {
                            return 0.0;
                        }
                        double modifierDamage = actualDamage;
                        if (modifier > 0 && modifier <= 20) {
                            int j = 25 - modifier;
                            double magicModifier = modifierDamage * (double)j;
                            modifierDamage = magicModifier / 25.0;
                        }
                        return -Math.max(actualDamage - modifierDamage, 0.0);
                    };
                    if (first) {
                        first = false;
                    }
                    DamageModifier enchantmentModifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), enchantment, snapshot, living)).type(DamageModifierTypes.ARMOR_ENCHANTMENT).build();
                    modifiers.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
                }
                if (modifiers.isEmpty()) continue;
                return Optional.of(modifiers);
            }
        }
        return Optional.empty();
    }

    public static Optional<DamageFunction> createAbsorptionModifier(LivingEntity entityLivingBase) {
        float absorptionAmount = entityLivingBase.getAbsorptionAmount();
        if (absorptionAmount > 0.0f) {
            DoubleUnaryOperator function = damage -> -Math.max(damage - Math.max(damage - (double)absorptionAmount, 0.0), 0.0);
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), entityLivingBase)).type(DamageModifierTypes.ABSORPTION).build();
            return Optional.of(new DamageFunction(modifier, function));
        }
        return Optional.empty();
    }

    public static ServerLocation findFirstMatchingBlock(net.minecraft.entity.Entity entity, AxisAlignedBB bb, Predicate<BlockState> predicate) {
        int i = MathHelper.floor((double)bb.minX);
        int j = MathHelper.floor((double)(bb.maxX + 1.0));
        int k = MathHelper.floor((double)bb.minY);
        int l = MathHelper.floor((double)(bb.maxY + 1.0));
        int i1 = MathHelper.floor((double)bb.minZ);
        int j1 = MathHelper.floor((double)(bb.maxZ + 1.0));
        AbstractChunkProvider spongeChunkProvider = entity.world.getChunkProvider();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    BlockPos blockPos = new BlockPos(k1, l1, i2);
                    Chunk chunk = spongeChunkProvider.getChunk(blockPos.getX() >> 4, blockPos.getZ() >> 4, false);
                    if (chunk == null || chunk.isEmpty() || !predicate.test(chunk.getBlockState(blockPos))) continue;
                    return ServerLocation.of((ServerWorld)entity.world, k1, l1, i2);
                }
            }
        }
        return ((Entity)entity).getServerLocation();
    }

    public static void generateCauseFor(DamageSource damageSource, CauseStackManager.StackFrame frame) {
        if (damageSource instanceof IndirectEntityDamageSource) {
            net.minecraft.entity.Entity source = damageSource.getTrueSource();
            if (!(source instanceof PlayerEntity) && source instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)source;
                creatorBridge.tracked$getCreatorReference().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                creatorBridge.tracked$getNotifierReference().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
        } else if (damageSource instanceof EntityDamageSource) {
            net.minecraft.entity.Entity source = damageSource.getTrueSource();
            if (!(source instanceof PlayerEntity) && source instanceof CreatorTrackedBridge) {
                CreatorTrackedBridge creatorBridge = (CreatorTrackedBridge)source;
                creatorBridge.tracked$getCreatorReference().ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
                creatorBridge.tracked$getNotifierReference().ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            }
        } else if (damageSource instanceof BlockDamageSource) {
            ServerLocation location = ((BlockDamageSource)damageSource).getLocation();
            BlockPos blockPos = VecHelper.toBlockPos(location);
            ChunkBridge mixinChunk = (ChunkBridge)((World)location.getWorld()).getChunkAt(blockPos);
            mixinChunk.bridge$getBlockCreator(blockPos).ifPresent(creator -> frame.addContext(EventContextKeys.CREATOR, creator));
            mixinChunk.bridge$getBlockNotifier(blockPos).ifPresent(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
        }
        frame.pushCause(damageSource);
    }

    public static List<DamageFunction> createAttackEnchantmentFunction(net.minecraft.item.ItemStack heldItem, CreatureAttribute creatureAttribute, float attackStrength) {
        LinkedHashMultimap enchantments = LinkedHashMultimap.create();
        ArrayList<DamageFunction> damageModifierFunctions = new ArrayList<DamageFunction>();
        if (!heldItem.isEmpty()) {
            ListNBT nbttaglist = heldItem.getEnchantmentTagList();
            if (nbttaglist.isEmpty()) {
                return ImmutableList.of();
            }
            for (int i = 0; i < nbttaglist.size(); ++i) {
                short j = nbttaglist.getCompound(i).getShort("id");
                short enchantmentLevel = nbttaglist.getCompound(i).getShort("lvl");
                Enchantment enchantment = (Enchantment)Registry.ENCHANTMENT.getByValue((int)j);
                if (enchantment == null) continue;
                enchantments.put((Object)enchantment, (Object)enchantmentLevel);
            }
            if (enchantments.isEmpty()) {
                return ImmutableList.of();
            }
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(heldItem);
            for (Map.Entry enchantment : enchantments.asMap().entrySet()) {
                DamageModifier enchantmentModifier = DamageModifier.builder().type(DamageModifierTypes.WEAPON_ENCHANTMENT).cause(Cause.of(EventContext.empty(), snapshot, enchantment)).build();
                DoubleUnaryOperator enchantmentFunction = damage -> {
                    double totalDamage = 0.0;
                    Iterator iterator = ((Collection)enchantment.getValue()).iterator();
                    while (iterator.hasNext()) {
                        int level = (Integer)iterator.next();
                        totalDamage += (double)((Enchantment)enchantment.getKey()).calcDamageByCreature(level, creatureAttribute) * (double)attackStrength;
                    }
                    return totalDamage;
                };
                damageModifierFunctions.add(new DamageFunction(enchantmentModifier, enchantmentFunction));
            }
        }
        return damageModifierFunctions;
    }

    public static DamageFunction provideCriticalAttackTuple(PlayerEntity player) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.CRITICAL_HIT).build();
        DoubleUnaryOperator function = damage -> damage * 0.5;
        return new DamageFunction(modifier, function);
    }

    public static DamageFunction provideCooldownAttackStrengthFunction(PlayerEntity player, float attackStrength) {
        DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), player)).type(DamageModifierTypes.ATTACK_COOLDOWN).build();
        DoubleUnaryOperator function = damage -> -damage + damage * (double)(0.2f + attackStrength * attackStrength * 0.8f);
        return new DamageFunction(modifier, function);
    }

    public static Optional<DamageFunction> createShieldFunction(LivingEntity entity, DamageSource source, float amount) {
        if (entity.isActiveItemStackBlocking() && (double)amount > 0.0 && ((LivingEntityAccessor)entity).accessor$canBlockDamageSource(source)) {
            DamageModifier modifier = DamageModifier.builder().cause(Cause.of(EventContext.empty(), entity, ((ItemStack)entity.getActiveItemStack()).createSnapshot())).type(DamageModifierTypes.SHIELD).build();
            return Optional.of(new DamageFunction(modifier, damage -> -damage));
        }
        return Optional.empty();
    }
}

