/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.cause.entity.damage;

import com.google.common.base.Preconditions;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.event.cause.entity.damage.source.BlockDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.common.accessor.util.DamageSourceAccessor;
import org.spongepowered.common.util.MinecraftBlockDamageSource;

public final class SpongeBlockDamageSourceBuilder
extends AbstractDamageSourceBuilder<BlockDamageSource, BlockDamageSource.Builder>
implements BlockDamageSource.Builder {
    private ServerLocation location;
    private BlockSnapshot blockSnapshot;

    @Override
    public BlockDamageSource.Builder block(ServerLocation location) {
        this.location = location;
        return this;
    }

    @Override
    public BlockDamageSource.Builder block(BlockSnapshot blockState) {
        this.blockSnapshot = (BlockSnapshot)Preconditions.checkNotNull((Object)blockState);
        return this;
    }

    @Override
    public BlockDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.location != null ? 1 : 0) != 0);
        Preconditions.checkState((this.blockSnapshot != null ? 1 : 0) != 0);
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0);
        MinecraftBlockDamageSource damageSource = new MinecraftBlockDamageSource(this.damageType.getKey().getFormatted(), this.location);
        DamageSourceAccessor accessor = (DamageSourceAccessor)((Object)damageSource);
        if (this.absolute) {
            accessor.accessor$setDamageIsAbsolute();
        }
        if (this.bypasses) {
            accessor.accessor$setDamageBypassesArmor();
        }
        if (this.scales) {
            damageSource.setDifficultyScaled();
        }
        if (this.explosion) {
            damageSource.setExplosion();
        }
        if (this.magical) {
            damageSource.setMagicDamage();
        }
        if (this.creative) {
            accessor.accessor$setDamageAllowedInCreativeMode();
        }
        if (this.exhaustion != null) {
            accessor.accessor$setHungerDamage(this.exhaustion.floatValue());
        }
        return (BlockDamageSource)((Object)damageSource);
    }

    @Override
    public BlockDamageSource.Builder reset() {
        super.reset();
        this.location = null;
        this.blockSnapshot = null;
        return this;
    }
}

