/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.filter;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.filter.cause.After;
import org.spongepowered.api.event.filter.cause.All;
import org.spongepowered.api.event.filter.cause.Before;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.filter.cause.Last;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.filter.data.Has;
import org.spongepowered.api.event.filter.data.Supports;
import org.spongepowered.api.event.filter.type.Exclude;
import org.spongepowered.api.event.filter.type.Include;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.common.event.filter.EventFilter;
import org.spongepowered.common.event.filter.delegate.AfterCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.AllCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.BeforeCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.CancellationEventFilterDelegate;
import org.spongepowered.common.event.filter.delegate.ExcludeSubtypeFilterDelegate;
import org.spongepowered.common.event.filter.delegate.FilterDelegate;
import org.spongepowered.common.event.filter.delegate.FirstCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.GetterFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.HasDataFilterDelegate;
import org.spongepowered.common.event.filter.delegate.IncludeSubtypeFilterDelegate;
import org.spongepowered.common.event.filter.delegate.LastCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.ParameterFilterDelegate;
import org.spongepowered.common.event.filter.delegate.ParameterFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.RootCauseFilterSourceDelegate;
import org.spongepowered.common.event.filter.delegate.SubtypeFilterDelegate;
import org.spongepowered.common.event.filter.delegate.SupportsDataFilterDelegate;
import org.spongepowered.common.util.generator.GeneratorUtils;

public class FilterGenerator {
    public static final boolean FILTER_DEBUG = Boolean.parseBoolean(System.getProperty("sponge.filter.debug", "false"));

    public static FilterGenerator getInstance() {
        return Holder.INSTANCE;
    }

    FilterGenerator() {
    }

    public byte[] generateClass(String name, Method method) {
        int i;
        name = name.replace('.', '/');
        Parameter[] params = method.getParameters();
        ClassWriter cw = new ClassWriter(3);
        cw.visit(50, 49, name, null, "java/lang/Object", new String[]{Type.getInternalName(EventFilter.class)});
        SubtypeFilterDelegate sfilter = null;
        ArrayList additional = Lists.newArrayList();
        boolean cancellation = false;
        for (Annotation anno : method.getAnnotations()) {
            Object obj = FilterGenerator.filterFromAnnotation(anno.annotationType());
            if (obj == null) continue;
            if (obj instanceof SubtypeFilter) {
                if (sfilter != null) {
                    throw new IllegalStateException("Cannot have both @Include and @Exclude annotations present at once");
                }
                sfilter = ((SubtypeFilter)((Object)obj)).getDelegate(anno);
                continue;
            }
            if (!(obj instanceof EventTypeFilter)) continue;
            EventTypeFilter etf = (EventTypeFilter)((Object)obj);
            additional.add(etf.getDelegate(anno));
            if (etf != EventTypeFilter.CANCELLATION) continue;
            cancellation = true;
        }
        if (!cancellation && Cancellable.class.isAssignableFrom(method.getParameterTypes()[0])) {
            additional.add(new CancellationEventFilterDelegate(Tristate.FALSE));
        }
        if (sfilter != null) {
            sfilter.createFields(cw);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        if (sfilter != null) {
            sfilter.writeCtor(name, cw, mv);
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "filter", "(" + Type.getDescriptor(Event.class) + ")[Ljava/lang/Object;", null, null);
        mv.visitCode();
        int local = 2;
        if (sfilter != null) {
            local = sfilter.write(name, cw, mv, method, local);
        }
        for (FilterDelegate eventFilter : additional) {
            local = eventFilter.write(name, cw, mv, method, local);
        }
        int[] plocals = new int[params.length - 1];
        for (i = 1; i < params.length; ++i) {
            Parameter param = params[i];
            ParameterFilterSourceDelegate source = null;
            ArrayList paramFilters = Lists.newArrayList();
            for (Annotation anno : param.getAnnotations()) {
                Object obj = FilterGenerator.filterFromAnnotation(anno.annotationType());
                if (obj == null) continue;
                if (obj instanceof ParameterSource) {
                    if (source != null) {
                        throw new IllegalStateException("Cannot have multiple parameter filter source annotations (for " + param.getName() + ")");
                    }
                    source = ((ParameterSource)((Object)obj)).getDelegate(anno);
                    continue;
                }
                if (!(obj instanceof ParameterFilter)) continue;
                paramFilters.add(((ParameterFilter)((Object)obj)).getDelegate(anno));
            }
            if (source == null) {
                throw new IllegalStateException("Cannot have additional parameters filters without a source (for " + param.getName() + ")");
            }
            if (source instanceof AllCauseFilterSourceDelegate && !paramFilters.isEmpty()) {
                throw new IllegalStateException("Cannot have additional parameters filters without an array source (for " + param.getName() + ")");
            }
            Tuple<Integer, Integer> localState = source.write(cw, mv, method, param, local);
            local = localState.getFirst();
            plocals[i - 1] = localState.getSecond();
            for (ParameterFilterDelegate paramFilter : paramFilters) {
                paramFilter.write(cw, mv, method, param, plocals[i - 1]);
            }
        }
        if (params.length == 1) {
            mv.visitInsn(4);
        } else {
            mv.visitIntInsn(16, params.length);
        }
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(83);
        for (i = 1; i < params.length; ++i) {
            mv.visitInsn(89);
            mv.visitIntInsn(16, i);
            Type paramType = Type.getType(params[i].getType());
            mv.visitVarInsn(paramType.getOpcode(21), plocals[i - 1]);
            GeneratorUtils.visitBoxingMethod(mv, paramType);
            mv.visitInsn(83);
        }
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        byte[] data = cw.toByteArray();
        if (FILTER_DEBUG) {
            File outDir = new File(".sponge.debug.out");
            File outFile = new File(outDir, name + ".class");
            if (!outFile.getParentFile().exists()) {
                outFile.getParentFile().mkdirs();
            }
            try (FileOutputStream out = new FileOutputStream(outFile);){
                out.write(data);
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
        }
        return data;
    }

    private static Object filterFromAnnotation(Class<? extends Annotation> cls) {
        Enum filter = SubtypeFilter.valueOf(cls);
        if (filter != null) {
            return filter;
        }
        filter = EventTypeFilter.valueOf(cls);
        if (filter != null) {
            return filter;
        }
        filter = ParameterSource.valueOf(cls);
        if (filter != null) {
            return filter;
        }
        filter = ParameterFilter.valueOf(cls);
        if (filter != null) {
            return filter;
        }
        return null;
    }

    private static final class Holder {
        static final FilterGenerator INSTANCE = new FilterGenerator();

        private Holder() {
        }
    }

    private static enum ParameterFilter {
        SUPPORTS(Supports.class),
        HAS(Has.class);

        private final Class<? extends Annotation> cls;

        private ParameterFilter(Class<? extends Annotation> cls) {
            this.cls = cls;
        }

        public ParameterFilterDelegate getDelegate(Annotation anno) {
            if (this == SUPPORTS) {
                return new SupportsDataFilterDelegate((Supports)anno);
            }
            if (this == HAS) {
                return new HasDataFilterDelegate((Has)anno);
            }
            throw new UnsupportedOperationException();
        }

        public static ParameterFilter valueOf(Class<? extends Annotation> cls) {
            for (ParameterFilter value : ParameterFilter.values()) {
                if (!value.cls.equals(cls)) continue;
                return value;
            }
            return null;
        }
    }

    private static enum ParameterSource {
        CAUSE_FIRST(First.class),
        CAUSE_LAST(Last.class),
        CAUSE_BEFORE(Before.class),
        CAUSE_AFTER(After.class),
        CAUSE_ALL(All.class),
        CAUSE_ROOT(Root.class),
        GETTER(Getter.class);

        private final Class<? extends Annotation> cls;

        private ParameterSource(Class<? extends Annotation> cls) {
            this.cls = cls;
        }

        public ParameterFilterSourceDelegate getDelegate(Annotation anno) {
            if (this == CAUSE_FIRST) {
                return new FirstCauseFilterSourceDelegate((First)anno);
            }
            if (this == CAUSE_LAST) {
                return new LastCauseFilterSourceDelegate((Last)anno);
            }
            if (this == CAUSE_BEFORE) {
                return new BeforeCauseFilterSourceDelegate((Before)anno);
            }
            if (this == CAUSE_AFTER) {
                return new AfterCauseFilterSourceDelegate((After)anno);
            }
            if (this == CAUSE_ALL) {
                return new AllCauseFilterSourceDelegate((All)anno);
            }
            if (this == CAUSE_ROOT) {
                return new RootCauseFilterSourceDelegate((Root)anno);
            }
            if (this == GETTER) {
                return new GetterFilterSourceDelegate((Getter)anno);
            }
            throw new UnsupportedOperationException();
        }

        public static ParameterSource valueOf(Class<? extends Annotation> cls) {
            for (ParameterSource value : ParameterSource.values()) {
                if (!value.cls.equals(cls)) continue;
                return value;
            }
            return null;
        }
    }

    private static enum EventTypeFilter {
        CANCELLATION(IsCancelled.class);

        private final Class<? extends Annotation> cls;

        private EventTypeFilter(Class<? extends Annotation> cls) {
            this.cls = cls;
        }

        public FilterDelegate getDelegate(Annotation anno) {
            if (this == CANCELLATION) {
                return new CancellationEventFilterDelegate(((IsCancelled)anno).value());
            }
            throw new UnsupportedOperationException();
        }

        public static EventTypeFilter valueOf(Class<? extends Annotation> cls) {
            for (EventTypeFilter value : EventTypeFilter.values()) {
                if (!value.cls.equals(cls)) continue;
                return value;
            }
            return null;
        }
    }

    private static enum SubtypeFilter {
        INCLUDE(Include.class),
        EXCLUDE(Exclude.class);

        private final Class<? extends Annotation> cls;

        private SubtypeFilter(Class<? extends Annotation> cls) {
            this.cls = cls;
        }

        public SubtypeFilterDelegate getDelegate(Annotation anno) {
            if (this == INCLUDE) {
                return new IncludeSubtypeFilterDelegate((Include)anno);
            }
            if (this == EXCLUDE) {
                return new ExcludeSubtypeFilterDelegate((Exclude)anno);
            }
            throw new UnsupportedOperationException();
        }

        public static SubtypeFilter valueOf(Class<? extends Annotation> cls) {
            for (SubtypeFilter value : SubtypeFilter.values()) {
                if (!value.cls.equals(cls)) continue;
                return value;
            }
            return null;
        }
    }
}

