/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedListMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.transaction.BlockTransaction;
import org.spongepowered.api.block.transaction.Operation;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionTypes;
import org.spongepowered.math.vector.Vector3i;

abstract class BlockEventBasedTransaction
extends GameTransaction<ChangeBlockEvent.All> {
    final BlockPos affectedPosition;
    final BlockState originalState;

    BlockEventBasedTransaction(BlockPos affectedPosition, BlockState originalState, ResourceKey worldKey) {
        super(TransactionTypes.BLOCK.get(), worldKey);
        this.affectedPosition = affectedPosition.toImmutable();
        this.originalState = originalState;
    }

    @Override
    public final Optional<ChangeBlockEvent.All> generateEvent(PhaseContext<@NonNull ?> context, @Nullable GameTransaction<@NonNull ?> parent, ImmutableList<GameTransaction<ChangeBlockEvent.All>> transactions, Cause currentCause, ImmutableMultimap.Builder<TransactionType, ? extends Event> transactionPostEventBuilder) {
        Optional<ServerWorld> o = ((SpongeServer)SpongeCommon.getServer()).getWorldManager().getWorld(this.worldKey);
        if (!o.isPresent()) {
            return Optional.empty();
        }
        LinkedListMultimap positions = LinkedListMultimap.create();
        for (GameTransaction transaction : transactions) {
            BlockEventBasedTransaction blockTransaction = (BlockEventBasedTransaction)transaction;
            if (!positions.containsKey((Object)blockTransaction.affectedPosition)) {
                positions.put((Object)blockTransaction.affectedPosition, (Object)blockTransaction.getOriginalSnapshot());
            }
            positions.put((Object)blockTransaction.affectedPosition, (Object)blockTransaction.getResultingSnapshot());
        }
        ImmutableList eventTransactions = (ImmutableList)positions.asMap().values().stream().map(spongeBlockSnapshots -> {
            ArrayList snapshots = new ArrayList(spongeBlockSnapshots);
            if (snapshots.isEmpty() || snapshots.size() < 2) {
                return Optional.empty();
            }
            SpongeBlockSnapshot original = (SpongeBlockSnapshot)snapshots.get(0);
            SpongeBlockSnapshot result = (SpongeBlockSnapshot)snapshots.get(snapshots.size() - 1);
            ImmutableList intermediary = snapshots.size() > 2 ? ImmutableList.copyOf(snapshots.subList(1, snapshots.size() - 2)) : ImmutableList.of();
            Operation operation = context.state.getBlockOperation(original, original.blockChange);
            BlockTransaction eventTransaction = new BlockTransaction(original, result, (List<? extends BlockSnapshot>)intermediary, operation);
            return Optional.of(eventTransaction);
        }).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
        return Optional.of(SpongeEventFactory.createChangeBlockEventAll(currentCause, (List<BlockTransaction>)eventTransactions, o.get()));
    }

    protected abstract SpongeBlockSnapshot getResultingSnapshot();

    protected abstract SpongeBlockSnapshot getOriginalSnapshot();

    @Override
    public final boolean markCancelledTransactions(ChangeBlockEvent.All event, ImmutableList<? extends GameTransaction<ChangeBlockEvent.All>> blockTransactions) {
        boolean cancelledAny = false;
        for (Transaction transaction : event.getTransactions()) {
            if (transaction.isValid()) continue;
            cancelledAny = true;
            for (GameTransaction gameTransaction : blockTransactions) {
                BlockEventBasedTransaction blockTransaction = (BlockEventBasedTransaction)gameTransaction;
                Vector3i position = ((BlockSnapshot)transaction.getOriginal()).getPosition();
                BlockPos affectedPosition = blockTransaction.affectedPosition;
                if (position.getX() != affectedPosition.getX() || position.getY() != affectedPosition.getY() || position.getZ() != affectedPosition.getZ()) continue;
                gameTransaction.markCancelled();
            }
        }
        return cancelledAny;
    }
}

