/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.event.tracking.BlockChangeFlagManager;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.BlockEventBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.effect.BlockAddedEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.CheckBlockPostPlacementIsSameEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.ChunkChangeCompleteEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.OldBlockOnReplaceEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.RefreshOldTileEntityOnChunkChangeEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.SetBlockToChunkSectionEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateChunkLightManagerEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateHeightMapEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.UpdateOrCreateNewTileEntityPostPlacementEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.ChunkPipeline;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ChangeBlock
extends BlockEventBasedTransaction {
    final SpongeBlockSnapshot original;
    final int originalOpacity;
    final net.minecraft.block.BlockState newState;
    final SpongeBlockChangeFlag blockChangeFlag;
    public @Nullable TileEntity queuedRemoval;
    public @Nullable TileEntity queuedAdd;

    ChangeBlock(SpongeBlockSnapshot attachedSnapshot, net.minecraft.block.BlockState newState, SpongeBlockChangeFlag blockChange) {
        super(attachedSnapshot.getBlockPos(), (net.minecraft.block.BlockState)attachedSnapshot.getState(), attachedSnapshot.getWorld());
        this.original = attachedSnapshot;
        this.newState = newState;
        this.blockChangeFlag = blockChange;
        this.originalOpacity = this.originalState.getOpacity((IBlockReader)this.original.getServerWorld().get(), this.affectedPosition);
    }

    public net.minecraft.block.BlockState getNewState() {
        return this.newState;
    }

    public SpongeBlockChangeFlag getBlockChangeFlag() {
        return this.blockChangeFlag;
    }

    public void populateChunkEffects(ChunkPipeline.Builder builder) {
        builder.addEffect(SetBlockToChunkSectionEffect.getInstance());
        builder.addEffect(UpdateHeightMapEffect.getInstance());
        builder.addEffect(UpdateChunkLightManagerEffect.getInstance());
        builder.addEffect(OldBlockOnReplaceEffect.getInstance());
        builder.addEffect(CheckBlockPostPlacementIsSameEffect.getInstance());
        builder.addEffect(RefreshOldTileEntityOnChunkChangeEffect.getInstance());
        builder.addEffect(BlockAddedEffect.getInstance());
        builder.addEffect(UpdateOrCreateNewTileEntityPostPlacementEffect.getInstance());
        builder.addEffect(ChunkChangeCompleteEffect.getInstance());
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.of(PhaseContext::addCreatorAndNotifierToCauseStack);
    }

    @Override
    public boolean acceptTileAddition(TileEntity tileEntity) {
        if (this.queuedAdd == tileEntity) {
            return true;
        }
        if (this.queuedAdd != null) {
            return false;
        }
        if (!this.affectedPosition.equals((Object)tileEntity.getPos())) {
            return false;
        }
        this.queuedAdd = tileEntity;
        return true;
    }

    @Override
    public boolean acceptTileRemoval(@Nullable TileEntity tileentity) {
        if (this.queuedRemoval == tileentity) {
            return true;
        }
        if (this.queuedRemoval != null) {
            return false;
        }
        if (!this.affectedPosition.equals((Object)tileentity.getPos())) {
            return false;
        }
        this.queuedRemoval = tileentity;
        return true;
    }

    @Override
    public boolean acceptTileReplacement(@Nullable TileEntity existing, TileEntity proposed) {
        return this.acceptTileRemoval(existing) && this.acceptTileAddition(proposed);
    }

    @Override
    public void restore() {
        this.original.restore(true, BlockChangeFlagManager.fromNativeInt(170));
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("ChangeBlock").add(" %s : %s", "Original Block", this.original).add(" %s : %s", "New State", this.newState).add(" %s : %s", "RemovedTile", this.queuedRemoval).add(" %s : %s", "AddedTile", this.queuedAdd).add(" %s : %s", "ChangeFlag", this.blockChangeFlag);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled().position(this.original.getPosition()).blockState((BlockState)this.newState);
        if (this.original.getServerWorld().isPresent()) {
            builder.world(this.original.getServerWorld().get());
        } else {
            builder.world(this.original.getWorld());
        }
        return builder.build();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.original;
    }
}

