/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.context.transaction.BlockEventBasedTransaction;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.util.PrettyPrinter;

public final class ReplaceTileEntity
extends BlockEventBasedTransaction {
    final TileEntity added;
    final @Nullable TileEntity removed;
    final SpongeBlockSnapshot removedSnapshot;

    ReplaceTileEntity(TileEntity added, @Nullable TileEntity removed, SpongeBlockSnapshot attachedSnapshot) {
        super(attachedSnapshot.getBlockPos(), (BlockState)attachedSnapshot.getState(), attachedSnapshot.getWorld());
        this.added = added;
        this.removed = removed;
        this.removedSnapshot = attachedSnapshot;
    }

    @Override
    public boolean acceptTileAddition(TileEntity tileEntity) {
        if (this.added == tileEntity) {
            return true;
        }
        return super.acceptTileAddition(tileEntity);
    }

    @Override
    public void restore() {
        this.removedSnapshot.restore(true, BlockChangeFlags.NONE);
    }

    @Override
    public Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> getFrameMutator(@Nullable GameTransaction<@NonNull ?> parent) {
        return Optional.empty();
    }

    @Override
    public void addToPrinter(PrettyPrinter printer) {
        printer.add("ReplaceTileEntity").add(" %s : %s", "Position", this.affectedPosition).add(" %s : %s", "Added", this.added).add(" %s : %s", "Removed", this.removed == null ? "null" : this.removed);
    }

    @Override
    protected SpongeBlockSnapshot getResultingSnapshot() {
        return SpongeBlockSnapshotBuilder.pooled().from(this.removedSnapshot).tileEntity(this.added).build();
    }

    @Override
    protected SpongeBlockSnapshot getOriginalSnapshot() {
        return this.removedSnapshot;
    }
}

