/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CombatEntry;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cancellable;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.entity.SpawnType;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.common.accessor.util.CombatEntryAccessor;
import org.spongepowered.common.accessor.util.CombatTrackerAccessor;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.context.ICaptureSupplier;
import org.spongepowered.common.event.tracking.context.transaction.AddBlockEventTransaction;
import org.spongepowered.common.event.tracking.context.transaction.AddTileEntity;
import org.spongepowered.common.event.tracking.context.transaction.ChangeBlock;
import org.spongepowered.common.event.tracking.context.transaction.EffectTransactor;
import org.spongepowered.common.event.tracking.context.transaction.EntityPerformingDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.EventByTransaction;
import org.spongepowered.common.event.tracking.context.transaction.GameTransaction;
import org.spongepowered.common.event.tracking.context.transaction.NeighborNotification;
import org.spongepowered.common.event.tracking.context.transaction.PrepareBlockDropsTransaction;
import org.spongepowered.common.event.tracking.context.transaction.RemoveTileEntity;
import org.spongepowered.common.event.tracking.context.transaction.ReplaceTileEntity;
import org.spongepowered.common.event.tracking.context.transaction.ResultingTransactionBySideEffect;
import org.spongepowered.common.event.tracking.context.transaction.SpawnEntityTransaction;
import org.spongepowered.common.event.tracking.context.transaction.effect.EntityPerformingDropsEffect;
import org.spongepowered.common.event.tracking.context.transaction.effect.PrepareBlockDrops;
import org.spongepowered.common.event.tracking.context.transaction.type.TransactionType;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class TransactionalCaptureSupplier
implements ICaptureSupplier {
    private @Nullable GameTransaction tail;
    private @Nullable GameTransaction head;
    private @Nullable ResultingTransactionBySideEffect effect;

    @Override
    public final boolean isEmpty() {
        return this.head == null;
    }

    public EffectTransactor pushEffect(ResultingTransactionBySideEffect effect) {
        GameTransaction parentTransaction = Optional.ofNullable(this.effect).map(child -> child.tail).orElse(Objects.requireNonNull(this.tail));
        EffectTransactor effectTransactor = new EffectTransactor(effect, parentTransaction, this.effect, this);
        this.effect = effect;
        parentTransaction.getEffects().addLast(effect);
        return effectTransactor;
    }

    void popEffect(EffectTransactor transactor) {
        this.effect = transactor.previousEffect;
    }

    private void logTransaction(GameTransaction transaction) {
        if (this.head == null) {
            this.head = transaction;
            this.tail = transaction;
        } else if (this.effect != null) {
            this.effect.addChild(transaction);
        } else {
            transaction.previous = this.tail;
            if (this.tail != null) {
                this.tail.next = transaction;
            }
            this.tail = transaction;
        }
    }

    public ChangeBlock logBlockChange(SpongeBlockSnapshot originalBlockSnapshot, BlockState newState, BlockChangeFlag flags) {
        ChangeBlock changeBlock = new ChangeBlock(originalBlockSnapshot, newState, (SpongeBlockChangeFlag)flags);
        this.logTransaction(changeBlock);
        return changeBlock;
    }

    public boolean logTileAddition(TileEntity tileEntity, Supplier<ServerWorld> worldSupplier, Chunk chunk) {
        boolean newRecorded;
        if (this.tail != null && (newRecorded = this.tail.acceptTileAddition(tileEntity))) {
            return true;
        }
        this.logTransaction(this.createTileAdditionTransaction(tileEntity, worldSupplier, chunk));
        return true;
    }

    public boolean logTileRemoval(@Nullable TileEntity tileentity, Supplier<ServerWorld> worldSupplier) {
        boolean newRecorded;
        if (tileentity == null) {
            return false;
        }
        if (this.tail != null && (newRecorded = this.tail.acceptTileRemoval(tileentity))) {
            return true;
        }
        this.logTransaction(this.createTileRemovalTransaction(tileentity, worldSupplier));
        return true;
    }

    public boolean logTileReplacement(BlockPos pos, @Nullable TileEntity existing, @Nullable TileEntity proposed, Supplier<ServerWorld> worldSupplier) {
        boolean newRecorded;
        if (proposed == null) {
            return false;
        }
        if (this.tail != null && (newRecorded = this.tail.acceptTileReplacement(existing, proposed))) {
            return true;
        }
        this.logTransaction(this.createTileReplacementTransaction(pos, existing, proposed, worldSupplier));
        return true;
    }

    public void logNeighborNotification(Supplier<ServerWorld> serverWorldSupplier, BlockPos immutableFrom, Block blockIn, BlockPos immutableTarget, BlockState targetBlockState, @Nullable TileEntity existingTile) {
        NeighborNotification notificationTransaction = new NeighborNotification(serverWorldSupplier, targetBlockState, immutableTarget, blockIn, immutableFrom);
        this.logTransaction(notificationTransaction);
    }

    public void logEntitySpawn(PhaseContext<@NonNull ?> current, TrackedWorldBridge serverWorld, Entity entityIn) {
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)serverWorld);
        Supplier<ServerWorld> worldSupplier = () -> (ServerWorld)Objects.requireNonNull(worldRef.get(), "ServerWorld dereferenced");
        Supplier<SpawnType> contextualType = current.state.getSpawnTypeForTransaction(current, entityIn);
        SpawnEntityTransaction transaction = new SpawnEntityTransaction(worldSupplier, entityIn, contextualType);
        this.logTransaction(transaction);
    }

    private GameTransaction createTileReplacementTransaction(BlockPos pos, @Nullable TileEntity existing, TileEntity proposed, Supplier<ServerWorld> worldSupplier) {
        BlockState currentState = worldSupplier.get().getBlockState(pos);
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(currentState, pos, BlockChangeFlags.NONE, existing, worldSupplier, Optional::empty, Optional::empty);
        snapshot.blockChange = BlockChange.MODIFY;
        return new ReplaceTileEntity(proposed, existing, snapshot);
    }

    public EffectTransactor logBlockDrops(PhaseContext<@NonNull ?> context, World serverWorld, BlockPos pos, BlockState state, @Nullable TileEntity tileEntity) {
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)serverWorld);
        Supplier<ServerWorld> worldSupplier = () -> (ServerWorld)Objects.requireNonNull(worldRef.get(), "ServerWorld dereferenced");
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(state, pos, BlockChangeFlags.NONE, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        PrepareBlockDropsTransaction transaction = new PrepareBlockDropsTransaction(pos, state, original);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(PrepareBlockDrops.getInstance()));
    }

    public void logBlockEvent(BlockState state, TrackedWorldBridge serverWorld, BlockPos pos, TrackerBlockEventDataBridge blockEvent) {
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)serverWorld);
        Supplier<ServerWorld> worldSupplier = () -> (ServerWorld)Objects.requireNonNull(worldRef.get(), "ServerWorld dereferenced");
        @Nullable TileEntity tileEntity = ((ServerWorld)serverWorld).getTileEntity(pos);
        SpongeBlockSnapshot original = TrackingUtil.createPooledSnapshot(state, pos, BlockChangeFlags.NONE, tileEntity, worldSupplier, Optional::empty, Optional::empty);
        original.blockChange = BlockChange.MODIFY;
        AddBlockEventTransaction transaction = new AddBlockEventTransaction(original, blockEvent);
        this.logTransaction(transaction);
    }

    public @Nullable EffectTransactor ensureEntityDropTransactionEffect(Entity entity) {
        CombatEntry entry;
        if (this.tail != null && this.tail.acceptEntityDrops(entity)) {
            return null;
        }
        WeakReference<ServerWorld> worldRef = new WeakReference<ServerWorld>((ServerWorld)entity.world);
        Supplier<ServerWorld> worldSupplier = () -> (ServerWorld)Objects.requireNonNull(worldRef.get(), "ServerWorld dereferenced");
        CompoundNBT tag = new CompoundNBT();
        entity.writeWithoutTypeId(tag);
        DamageSource lastAttacker = entity instanceof LivingEntity ? ((entry = ((CombatTrackerAccessor)((LivingEntity)entity).getCombatTracker()).accessor$getBestCombatEntry()) != null ? ((CombatEntryAccessor)entry).accessor$getDamageSrc() : null) : null;
        WeakReference<@Nullable Object> ref = new WeakReference<Object>(lastAttacker);
        Supplier<Optional<DamageSource>> attacker = () -> {
            @Nullable DamageSource damageSource = (DamageSource)ref.get();
            if (damageSource == null) {
                return Optional.empty();
            }
            return Optional.of(damageSource);
        };
        EntityPerformingDropsTransaction transaction = new EntityPerformingDropsTransaction(worldSupplier, entity, tag, attacker);
        this.logTransaction(transaction);
        return this.pushEffect(new ResultingTransactionBySideEffect(EntityPerformingDropsEffect.getInstance()));
    }

    public void completeBlockDrops(@Nullable EffectTransactor context) {
        if (this.effect != null && this.effect.effect == PrepareBlockDrops.getInstance() && context != null) {
            context.close();
        }
    }

    private RemoveTileEntity createTileRemovalTransaction(TileEntity tileentity, Supplier<ServerWorld> worldSupplier) {
        BlockState currentState = tileentity.getBlockState();
        SpongeBlockSnapshot snapshot = TrackingUtil.createPooledSnapshot(currentState, tileentity.getPos(), BlockChangeFlags.NONE, tileentity, worldSupplier, Optional::empty, Optional::empty);
        snapshot.blockChange = BlockChange.MODIFY;
        return new RemoveTileEntity(tileentity, snapshot);
    }

    private AddTileEntity createTileAdditionTransaction(TileEntity tileentity, Supplier<ServerWorld> worldSupplier, Chunk chunk) {
        BlockPos pos = tileentity.getPos().toImmutable();
        BlockState currentBlock = chunk.getBlockState(pos);
        @Nullable TileEntity existingTile = chunk.getTileEntity(pos, Chunk.CreateEntityType.CHECK);
        SpongeBlockSnapshot added = TrackingUtil.createPooledSnapshot(currentBlock, pos, BlockChangeFlags.NONE, tileentity, worldSupplier, Optional::empty, Optional::empty);
        SpongeBlockSnapshot existing = TrackingUtil.createPooledSnapshot(currentBlock, pos, BlockChangeFlags.NONE, existingTile, worldSupplier, Optional::empty, Optional::empty);
        existing.blockChange = BlockChange.MODIFY;
        return new AddTileEntity(tileentity, added, existing);
    }

    public void clear() {
        this.head = null;
        this.tail = null;
        this.effect = null;
    }

    public boolean processTransactions(PhaseContext<@NonNull ?> context) {
        if (this.head == null) {
            return false;
        }
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableList<EventByTransaction<@NonNull ?>> batched = TransactionalCaptureSupplier.batchTransactions(this.head, this.head, context, (ImmutableMultimap.Builder<TransactionType, ? extends Event>)builder);
        boolean cancelledAny = false;
        for (EventByTransaction eventWithTransactions : batched) {
            Object event = eventWithTransactions.event;
            if (eventWithTransactions.isParentOrDeciderCancelled()) {
                cancelledAny = true;
                eventWithTransactions.markCancelled();
                continue;
            }
            Sponge.getEventManager().post((Event)event);
            if (event instanceof Cancellable && ((Cancellable)event).isCancelled()) {
                eventWithTransactions.markCancelled();
                cancelledAny = true;
            }
            if (eventWithTransactions.decider.markCancelledTransactions(event, eventWithTransactions.transactions)) {
                cancelledAny = true;
            }
            for (GameTransaction transaction : eventWithTransactions.transactions) {
                if (transaction.cancelled) continue;
                transaction.postProcessEvent(context, event);
            }
        }
        if (cancelledAny) {
            for (EventByTransaction eventByTransaction : batched.reverse()) {
                for (GameTransaction gameTransaction : eventByTransaction.transactions.reverse()) {
                    if (!gameTransaction.cancelled) continue;
                    gameTransaction.restore();
                }
            }
        }
        builder.build().asMap().forEach(TransactionType::createAndProcessPostEvents);
        return !cancelledAny;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static ImmutableList<EventByTransaction<@NonNull ?>> batchTransactions(GameTransaction head, GameTransaction parent, PhaseContext<@NonNull ?> context, ImmutableMultimap.Builder<TransactionType, ? extends Event> transactionPostEventBuilder) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableList.Builder builder = ImmutableList.builder();
        GameTransaction<?> pointer = head;
        ImmutableList.Builder accumilator = ImmutableList.builder();
        GameTransaction<?> batchDecider = null;
        while (pointer != null) {
            ImmutableList transactions;
            if (batchDecider == null) {
                batchDecider = pointer;
            }
            if (batchDecider.getTransactionType() != pointer.getTransactionType() || !batchDecider.worldKey.equals(pointer.worldKey)) {
                transactions = accumilator.build();
                accumilator = ImmutableList.builder();
                TransactionalCaptureSupplier.generateEventForTransaction(batchDecider, parent, context, builder, transactions, transactionPostEventBuilder);
                accumilator.add((Object)pointer);
                batchDecider = pointer;
                continue;
            }
            if (pointer.hasAnyPrimaryChildrenTransactions() || pointer.isUnbatchable() || pointer.next == null) {
                accumilator.add((Object)pointer);
                transactions = accumilator.build();
                accumilator = ImmutableList.builder();
                batchDecider = pointer.next;
                TransactionalCaptureSupplier.generateEventForTransaction(pointer, parent, context, builder, transactions, transactionPostEventBuilder);
            } else {
                accumilator.add((Object)pointer);
            }
            pointer = pointer.next;
        }
        ImmutableList remaining = accumilator.build();
        if (!remaining.isEmpty()) {
            TransactionalCaptureSupplier.generateEventForTransaction(Objects.requireNonNull(batchDecider, "BatchDeciding Transaction was null"), parent, context, builder, remaining, transactionPostEventBuilder);
        }
        return builder.build();
    }

    private static <E extends Event & Cancellable> void generateEventForTransaction(@NonNull GameTransaction<E> pointer, @Nullable GameTransaction<@NonNull ?> parent, PhaseContext<@NonNull ?> context, // Could not load outer class - annotation placement on inner may be incorrect
    ImmutableList.Builder<EventByTransaction<@NonNull ?>> builder, ImmutableList<GameTransaction<E>> transactions, ImmutableMultimap.Builder<TransactionType, ? extends Event> transactionPostEventBuilder) {
        Optional<BiConsumer<PhaseContext<@NonNull ?>, CauseStackManager.StackFrame>> frameMutator = pointer.getFrameMutator(parent);
        PhaseTracker instance = PhaseTracker.getInstance();
        try ( @Nullable CauseStackManager.StackFrame frame = frameMutator.map(mutator -> {
            CauseStackManager.StackFrame transactionFrame = instance.pushCauseFrame();
            mutator.accept(context, transactionFrame);
            return transactionFrame;
        }).orElse(null);){
            Optional<E> event = pointer.generateEvent(context, parent, transactions, instance.getCurrentCause(), transactionPostEventBuilder);
            if (!event.isPresent()) {
                transactions.forEach(GameTransaction::markCancelled);
                return;
            }
            EventByTransaction<Event> element = new EventByTransaction<Event>((Event)event.get(), transactions, parent, pointer);
            builder.add(element);
            transactionPostEventBuilder.put(pointer.getTransactionType(), event.get());
            if (frame != null) {
                frame.pushCause(event.get());
            }
            for (GameTransaction transaction : transactions) {
                if (transaction.sideEffects == null) continue;
                for (ResultingTransactionBySideEffect sideEffect : transaction.sideEffects) {
                    if (sideEffect.head == null) continue;
                    builder.addAll(TransactionalCaptureSupplier.batchTransactions(sideEffect.head, pointer, context, transactionPostEventBuilder));
                }
            }
        }
    }

    public int hashCode() {
        return Objects.hashCode(this.head);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionalCaptureSupplier other = (TransactionalCaptureSupplier)obj;
        return Objects.equals(this.head, other.head);
    }

    public String toString() {
        return new StringJoiner(", ", TransactionalCaptureSupplier.class.getSimpleName() + "[", "]").add("tail=" + this.tail).add("head=" + this.head).add("effect=" + this.effect).toString();
    }

    public void reset() {
        if (this.head != null) {
            this.head = null;
            this.tail = null;
        }
        if (this.effect != null) {
            this.effect = null;
        }
    }
}

