/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.block.BlockState;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class NotifyClientEffect
implements ProcessingSideEffect {
    public static NotifyClientEffect getInstance() {
        return Holder.INSTANCE;
    }

    NotifyClientEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        Chunk chunk = pipeline.getAffectedChunk();
        ServerWorld world = pipeline.getServerWorld();
        if (flag.notifyClients() && chunk.getLocationType().isAtLeast(ChunkHolder.LocationType.TICKING)) {
            world.notifyBlockUpdate(oldState.pos, oldState.state, newState, flag.getRawFlag());
        }
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final NotifyClientEffect INSTANCE = new NotifyClientEffect();

        private Holder() {
        }
    }
}

