/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.common.accessor.world.WorldAccessor;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class RemoveTileEntityFromWorldEffect
implements ProcessingSideEffect {
    public static RemoveTileEntityFromWorldEffect getInstance() {
        return Holder.INSTANCE;
    }

    RemoveTileEntityFromWorldEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        TileEntity tileEntity = oldState.tileEntity;
        if (tileEntity == null) {
            return EffectResult.NULL_RETURN;
        }
        ServerWorld serverWorld = pipeline.getServerWorld();
        WorldAccessor worldAccessor = (WorldAccessor)serverWorld;
        if (worldAccessor.accessor$getProcessingLoadedTiles()) {
            tileEntity.remove();
            worldAccessor.accessor$getAddedTileEntityList().remove(tileEntity);
            return EffectResult.NULL_RETURN;
        }
        worldAccessor.accessor$getAddedTileEntityList().remove(tileEntity);
        serverWorld.loadedTileEntityList.remove(tileEntity);
        serverWorld.tickableTileEntities.remove(tileEntity);
        return EffectResult.NULL_PASS;
    }

    private static final class Holder {
        static final RemoveTileEntityFromWorldEffect INSTANCE = new RemoveTileEntityFromWorldEffect();

        private Holder() {
        }
    }
}

