/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.context.transaction.effect;

import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.common.event.tracking.context.transaction.effect.EffectResult;
import org.spongepowered.common.event.tracking.context.transaction.effect.ProcessingSideEffect;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.BlockPipeline;
import org.spongepowered.common.event.tracking.context.transaction.pipeline.PipelineCursor;
import org.spongepowered.common.world.SpongeBlockChangeFlag;

public final class ReplaceTileEntityInWorldEffect
implements ProcessingSideEffect {
    public static ReplaceTileEntityInWorldEffect getInstance() {
        return Holder.INSTANCE;
    }

    ReplaceTileEntityInWorldEffect() {
    }

    @Override
    public EffectResult processSideEffect(BlockPipeline pipeline, PipelineCursor oldState, BlockState newState, SpongeBlockChangeFlag flag) {
        ServerWorld serverWorld = pipeline.getServerWorld();
        TileEntity tileEntity = oldState.tileEntity;
        BlockPos pos = oldState.pos;
        if (tileEntity == null || tileEntity.isRemoved()) {
            return EffectResult.NULL_RETURN;
        }
        pipeline.getAffectedChunk().addTileEntity(pos, tileEntity);
        serverWorld.addTileEntity(tileEntity);
        return EffectResult.NULL_RETURN;
    }

    private static final class Holder {
        static final ReplaceTileEntityInWorldEffect INSTANCE = new ReplaceTileEntityInWorldEffect();

        private Holder() {
        }
    }
}

