/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.block;

import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.PooledPhaseState;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.block.GrowablePhaseContext;
import org.spongepowered.common.world.BlockChange;

public class GrowablePhaseState
extends PooledPhaseState<GrowablePhaseContext>
implements IPhaseState<GrowablePhaseContext> {
    private final BiConsumer<CauseStackManager.StackFrame, GrowablePhaseContext> FRAME_MODIFIER = super.getFrameModifier().andThen((stackFrame, growablePhaseContext) -> {
        if (!growablePhaseContext.usedItem.isEmpty()) {
            stackFrame.addContext(EventContextKeys.USED_ITEM, growablePhaseContext.usedItem);
        }
        stackFrame.addContext(EventContextKeys.GROWTH_ORIGIN, growablePhaseContext.snapshot);
    });
    private final String desc = TrackingUtil.phaseStateToString("Growable", this);

    @Override
    public GrowablePhaseContext createNewContext(PhaseTracker tracker) {
        GrowablePhaseContext context = new GrowablePhaseContext(this, tracker);
        return (GrowablePhaseContext)context.addBlockCaptures();
    }

    @Override
    public void unwind(GrowablePhaseContext phaseContext) {
        TrackingUtil.processBlockCaptures(phaseContext);
    }

    @Override
    public BlockChange associateBlockChangeWithSnapshot(GrowablePhaseContext phaseContext, BlockState newState, Block newBlock, BlockState currentState, SpongeBlockSnapshot snapshot, Block originalBlock) {
        return BlockChange.GROW;
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, GrowablePhaseContext> getFrameModifier() {
        return this.FRAME_MODIFIER;
    }

    @Override
    public boolean doesDenyChunkRequests(GrowablePhaseContext context) {
        return true;
    }

    @Override
    public boolean includesDecays() {
        return true;
    }

    public String toString() {
        return this.desc;
    }
}

