/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.Hand;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.common.accessor.entity.EntityAccessor;
import org.spongepowered.common.accessor.entity.passive.AbstractChestedHorseEntityAccessor;
import org.spongepowered.common.accessor.entity.passive.PigEntityAccessor;
import org.spongepowered.common.accessor.entity.passive.SheepEntityAccessor;
import org.spongepowered.common.accessor.entity.passive.WolfEntityAccessor;
import org.spongepowered.common.accessor.inventory.container.SlotAccessor;
import org.spongepowered.common.accessor.network.play.client.CPlayerPacketAccessor;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.packet.PacketContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhase;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.slots.SlotAdapter;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class PacketPhaseUtil {
    public static boolean handleSlotRestore(PlayerEntity player, @Nullable Container openContainer, List<SlotTransaction> slotTransactions, boolean eventCancelled) {
        boolean restoredAny = false;
        for (SlotTransaction slotTransaction : slotTransactions) {
            ItemStackSnapshot snapshot;
            if (!slotTransaction.getCustom().isPresent() && slotTransaction.isValid() && !eventCancelled) continue;
            restoredAny = true;
            SlotAdapter slot = (SlotAdapter)slotTransaction.getSlot();
            ItemStackSnapshot itemStackSnapshot = snapshot = eventCancelled || !slotTransaction.isValid() ? (ItemStackSnapshot)slotTransaction.getOriginal() : (ItemStackSnapshot)slotTransaction.getCustom().get();
            if (openContainer == null) {
                slot.set(snapshot.createStack());
                continue;
            }
            int slotNumber = slot.getOrdinal();
            Slot nmsSlot = openContainer.getSlot(slotNumber);
            if (nmsSlot == null) continue;
            nmsSlot.putStack(ItemStackUtil.fromSnapshotToNative(snapshot));
        }
        if (openContainer != null) {
            boolean capture = ((TrackedInventoryBridge)openContainer).bridge$capturingInventory();
            ((TrackedInventoryBridge)openContainer).bridge$setCaptureInventory(false);
            openContainer.detectAndSendChanges();
            ((TrackedInventoryBridge)openContainer).bridge$setCaptureInventory(capture);
            if (eventCancelled && player.openContainer == openContainer && player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).sendContainerToPlayer(openContainer);
            }
        }
        return restoredAny;
    }

    public static void handleCustomCursor(PlayerEntity player, ItemStackSnapshot customCursor) {
        ItemStack cursor = ItemStackUtil.fromSnapshotToNative(customCursor);
        player.inventory.setItemStack(cursor);
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).connection.sendPacket((IPacket)new SSetSlotPacket(-1, -1, cursor));
        }
    }

    public static void validateCapturedTransactions(int slotId, Container openContainer, List<SlotTransaction> capturedTransactions) {
        Slot slot;
        if (capturedTransactions.size() == 0 && slotId >= 0 && slotId < openContainer.inventorySlots.size() && (slot = openContainer.getSlot(slotId)) != null) {
            ItemStackSnapshot snapshot = ItemStackUtil.snapshotOf(slot.getStack());
            SlotTransaction slotTransaction = new SlotTransaction(((InventoryAdapter)openContainer).inventoryAdapter$getSlot(slotId).get(), snapshot, snapshot);
            capturedTransactions.add(slotTransaction);
        }
    }

    public static void handlePlayerSlotRestore(ServerPlayerEntity player, ItemStack itemStack, Hand hand) {
        if (itemStack.isEmpty()) {
            return;
        }
        player.isChangingQuantityOnly = false;
        int slotId = 0;
        if (hand == Hand.OFF_HAND) {
            player.inventory.offHandInventory.set(0, (Object)itemStack);
            slotId = player.inventory.mainInventory.size() + PlayerInventory.getHotbarSize();
        } else {
            player.inventory.mainInventory.set(player.inventory.currentItem, (Object)itemStack);
            for (Slot containerSlot : player.openContainer.inventorySlots) {
                if (containerSlot.inventory != player.inventory || ((SlotAccessor)containerSlot).accessor$getSlotIndex() != player.inventory.currentItem) continue;
                slotId = containerSlot.slotNumber;
                break;
            }
        }
        player.openContainer.detectAndSendChanges();
        player.isChangingQuantityOnly = false;
        player.connection.sendPacket((IPacket)new SSetSlotPacket(player.openContainer.windowId, slotId, itemStack));
    }

    public static boolean allTransactionsInvalid(List<SlotTransaction> slotTransactions) {
        if (slotTransactions.size() == 0) {
            return false;
        }
        for (SlotTransaction slotTransaction : slotTransactions) {
            if (!slotTransaction.isValid()) continue;
            return false;
        }
        return true;
    }

    public static void onProcessPacket(IPacket packetIn, INetHandler netHandler) {
        if (netHandler instanceof ServerPlayNetHandler) {
            ServerPlayerEntity packetPlayer = ((ServerPlayNetHandler)netHandler).player;
            if (!(packetPlayer.isAlive() || packetIn instanceof CCustomPayloadPacket || packetIn instanceof CClientStatusPacket && ((CClientStatusPacket)packetIn).getStatus() == CClientStatusPacket.State.PERFORM_RESPAWN)) {
                return;
            }
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                CPlayerPacket movingPacket;
                frame.pushCause(packetPlayer);
                if (SpongeImplHooks.creativeExploitCheck(packetIn, packetPlayer)) {
                    return;
                }
                boolean ignoreMovementCapture = packetIn instanceof CPlayerPacket ? ((movingPacket = (CPlayerPacket)packetIn) instanceof CPlayerPacket.RotationPacket ? true : packetPlayer.getPosX() == ((CPlayerPacketAccessor)movingPacket).accessor$getX() && packetPlayer.getPosY() == ((CPlayerPacketAccessor)movingPacket).accessor$getY() && packetPlayer.getPosZ() == ((CPlayerPacketAccessor)movingPacket).accessor$getZ()) : false;
                if (ignoreMovementCapture || packetIn instanceof CClientSettingsPacket) {
                    packetIn.processPacket(netHandler);
                }
                ItemStackSnapshot cursor = ItemStackUtil.snapshotOf(packetPlayer.inventory.getItemStack());
                IPhaseState<PacketContext<?>> packetState = PacketPhase.getInstance().getStateForPacket(packetIn);
                PacketContext<?> context = packetState.createPhaseContext(PhaseTracker.SERVER);
                if (!PacketPhase.getInstance().isPacketInvalid(packetIn, packetPlayer, packetState)) {
                    ((PacketContext)((PacketContext)((PacketContext)context.source(packetPlayer)).packetPlayer(packetPlayer)).packet(packetIn)).cursor(cursor);
                    PacketPhase.getInstance().populateContext(packetIn, packetPlayer, packetState, context);
                    context.creator(((ServerPlayer)packetPlayer).getUser());
                    context.notifier(((ServerPlayer)packetPlayer).getUser());
                }
                try (PacketContext<?> packetContext = context;){
                    packetContext.buildAndSwitch();
                    packetIn.processPacket(netHandler);
                }
                if (packetIn instanceof CClientStatusPacket) {
                    packetPlayer = ((ServerPlayNetHandler)netHandler).player;
                }
                ((ServerPlayerEntityBridge)packetPlayer).bridge$setPacketItem(ItemStack.EMPTY);
            }
        } else {
            packetIn.processPacket(netHandler);
        }
    }

    @Nullable
    public static DataParameter<?> findModifiedEntityInteractDataParameter(ItemStack stack, Entity entity) {
        Item item = stack.getItem();
        if (item instanceof DyeItem) {
            if (entity instanceof SheepEntity) {
                return SheepEntityAccessor.accessor$getDyeColor();
            }
            if (entity instanceof WolfEntity) {
                return WolfEntityAccessor.accessor$getCollarColor();
            }
            return null;
        }
        if (item == Items.NAME_TAG) {
            return entity instanceof LivingEntity && !(entity instanceof PlayerEntity) && stack.hasDisplayName() ? EntityAccessor.accessor$getCustomName() : null;
        }
        if (item == Items.SADDLE) {
            return entity instanceof PigEntity ? PigEntityAccessor.accessor$getSaddled() : null;
        }
        if (item instanceof BlockItem && ((BlockItem)item).getBlock() == Blocks.CHEST) {
            return entity instanceof AbstractChestedHorseEntity ? AbstractChestedHorseEntityAccessor.accessor$getDataIdChest() : null;
        }
        return null;
    }
}

