/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CUseEntityPacket;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.world.World;
import org.spongepowered.common.bridge.CreatorTrackedBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.item.util.ItemStackUtil;

public final class InteractAtEntityPacketState
extends BasicPacketState {
    @Override
    public boolean isPacketIgnored(IPacket<?> packetIn, ServerPlayerEntity packetPlayer) {
        CUseEntityPacket useEntityPacket = (CUseEntityPacket)packetIn;
        Entity entity = useEntityPacket.getEntityFromWorld(packetPlayer.world);
        return entity == null;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, BasicPacketContext context) {
        CUseEntityPacket useEntityPacket = (CUseEntityPacket)packet;
        ItemStack stack = ItemStackUtil.cloneDefensive(playerMP.getHeldItem(useEntityPacket.getHand()));
        if (stack != null) {
            context.itemUsed(stack);
        }
        HandType handType = (HandType)useEntityPacket.getHand();
        context.handUsed(handType);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        CUseEntityPacket useEntityPacket = (CUseEntityPacket)context.getPacket();
        Entity entity = useEntityPacket.getEntityFromWorld(player.world);
        if (entity == null) {
            return;
        }
        World spongeWorld = (World)player.world;
        if (entity instanceof CreatorTrackedBridge) {
            ((CreatorTrackedBridge)entity).tracked$setCreatorReference(((ServerPlayerEntityBridge)player).bridge$getUser());
        } else {
            ((org.spongepowered.api.entity.Entity)entity).offer(Keys.NOTIFIER, player.getUniqueID());
        }
        TrackingUtil.processBlockCaptures(context);
    }
}

