/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.player;

import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.client.CPlayerTryUseItemPacket;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.bridge.world.chunk.ChunkBridge;
import org.spongepowered.common.entity.PlayerTracker;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketContext;
import org.spongepowered.common.event.tracking.phase.packet.BasicPacketState;
import org.spongepowered.common.event.tracking.phase.packet.PacketPhaseUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;

public final class UseItemPacketState
extends BasicPacketState {
    private BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> BASIC_PACKET_MODIFIER = IPhaseState.DEFAULT_OWNER_NOTIFIER.andThen((frame, ctx) -> {
        frame.addContext(EventContextKeys.PLAYER_PLACE, ctx.getSpongePlayer().getWorld());
        frame.addContext(EventContextKeys.USED_HAND, ctx.getHandUsed());
        frame.addContext(EventContextKeys.USED_ITEM, ctx.getItemUsedSnapshot());
        ItemStack itemStack = ctx.getItemUsed();
        frame.addContext(EventContextKeys.SPAWN_TYPE, itemStack.getType() instanceof SpawnEggItem ? SpawnTypes.SPAWN_EGG : SpawnTypes.PLACEMENT);
        frame.pushCause(ctx.getSpongePlayer());
    });

    @Override
    public BiConsumer<CauseStackManager.StackFrame, BasicPacketContext> getFrameModifier() {
        return this.BASIC_PACKET_MODIFIER;
    }

    @Override
    public boolean isInteraction() {
        return true;
    }

    @Override
    public void populateContext(ServerPlayerEntity playerMP, IPacket<?> packet, BasicPacketContext context) {
        CPlayerTryUseItemPacket placeBlock = (CPlayerTryUseItemPacket)packet;
        net.minecraft.item.ItemStack usedItem = playerMP.getHeldItem(placeBlock.getHand());
        ItemStack itemstack = ItemStackUtil.cloneDefensive(usedItem);
        context.itemUsed(itemstack);
        HandType handType = (HandType)placeBlock.getHand();
        context.handUsed(handType);
    }

    @Override
    public void postBlockTransactionApplication(BlockChange blockChange, Transaction<? extends BlockSnapshot> transaction, BasicPacketContext context) {
        ServerPlayer player = context.getSpongePlayer();
        BlockPos pos = VecHelper.toBlockPos(transaction.getFinal().getLocation().get());
        ChunkBridge spongeChunk = (ChunkBridge)((ServerWorld)player.getWorld()).getChunkAt(pos);
        if (blockChange == BlockChange.PLACE) {
            spongeChunk.bridge$addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player.getUser(), PlayerTracker.Type.CREATOR);
        }
        spongeChunk.bridge$addTrackedBlockPosition((Block)transaction.getFinal().getState().getType(), pos, player.getUser(), PlayerTracker.Type.NOTIFIER);
    }

    @Override
    public void unwind(BasicPacketContext context) {
        ServerPlayerEntity player = context.getPacketPlayer();
        ItemStack itemStack = context.getItemUsed();
        ItemStackSnapshot snapshot = context.getItemUsedSnapshot();
        HandType hand = context.getHandUsed();
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            boolean success;
            frame.addContext(EventContextKeys.SPAWN_TYPE, itemStack.getType() instanceof SpawnEggItem ? SpawnTypes.SPAWN_EGG : SpawnTypes.PLACEMENT);
            if (!context.getTransactor().isEmpty() && !(success = TrackingUtil.processBlockCaptures(context)) && snapshot.isEmpty()) {
                PhaseTracker.getCauseStackManager().pushCause(player);
                PacketPhaseUtil.handlePlayerSlotRestore(player, ItemStackUtil.toNative(itemStack), (Hand)hand);
            }
        }
    }
}

