/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import javax.annotation.Nullable;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.api.world.World;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.tick.TickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.util.PrettyPrinter;

public final class DimensionContext
extends TickContext<DimensionContext> {
    @Nullable
    private World world;

    DimensionContext(PhaseTracker tracker) {
        super(TickPhase.Tick.DIMENSION, tracker);
    }

    public DimensionContext world(ServerWorld worldServer) {
        this.world = (World)worldServer;
        return this;
    }

    public DimensionContext world(ServerWorldBridge worldServer) {
        this.world = (World)((Object)worldServer);
        return this;
    }

    public World getWorld() throws IllegalStateException {
        if (this.world == null) {
            throw new IllegalStateException("Expected to be ticking on a world!");
        }
        return this.world;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s2 = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s2 + "- %s: %s", "World", this.world);
    }

    @Override
    protected void reset() {
        super.reset();
        this.world = null;
    }
}

