/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.tick;

import java.util.function.BiConsumer;
import net.minecraft.util.math.BlockPos;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.cause.entity.SpawnTypes;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.common.bridge.block.TrackerBlockEventDataBridge;
import org.spongepowered.common.bridge.world.TrackedWorldBridge;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.TrackingUtil;
import org.spongepowered.common.event.tracking.phase.general.ExplosionContext;
import org.spongepowered.common.event.tracking.phase.tick.LocationBasedTickPhaseState;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;

class TileEntityTickPhaseState
extends LocationBasedTickPhaseState<TileEntityTickContext> {
    private final BiConsumer<CauseStackManager.StackFrame, TileEntityTickContext> TILE_ENTITY_MODIFIER = super.getFrameModifier().andThen((frame, context) -> context.getSource(BlockEntity.class).ifPresent(frame::pushCause));

    TileEntityTickPhaseState() {
    }

    @Override
    public TileEntityTickContext createNewContext(PhaseTracker tracker) {
        return (TileEntityTickContext)((TileEntityTickContext)((TileEntityTickContext)new TileEntityTickContext(this, tracker).addEntityCaptures()).addEntityDropCaptures()).addBlockCaptures();
    }

    @Override
    public BiConsumer<CauseStackManager.StackFrame, TileEntityTickContext> getFrameModifier() {
        return this.TILE_ENTITY_MODIFIER;
    }

    @Override
    LocatableBlock getLocatableBlockSourceFromContext(PhaseContext<?> context) {
        return context.getSource(BlockEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be ticking over a TileEntity!", context)).getLocatableBlock();
    }

    @Override
    public void unwind(TileEntityTickContext context) {
        BlockEntity tickingTile = context.getSource(BlockEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(tickingTile.getLocatableBlock());
            TrackingUtil.processBlockCaptures(context);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
        }
    }

    @Override
    public void appendNotifierToBlockEvent(TileEntityTickContext context, TrackedWorldBridge mixinWorldServer, BlockPos pos, TrackerBlockEventDataBridge blockEvent) {
        BlockEntity tickingTile = context.getSource(BlockEntity.class).orElseThrow(TrackingUtil.throwWithContext("Not ticking on a TileEntity!", context));
        blockEvent.bridge$setTickingLocatable(tickingTile.getLocatableBlock());
        blockEvent.bridge$setTileEntity(tickingTile);
    }

    @Override
    public void appendContextPreExplosion(ExplosionContext explosionContext, TileEntityTickContext context) {
        context.applyNotifierIfAvailable(explosionContext::notifier);
        context.applyOwnerIfAvailable(explosionContext::creator);
        BlockEntity tickingTile = context.getSource(BlockEntity.class).orElseThrow(TrackingUtil.throwWithContext("Expected to be processing over a ticking TileEntity!", context));
        explosionContext.source(tickingTile);
    }

    @Override
    public boolean doesCaptureNeighborNotifications(TileEntityTickContext context) {
        return context.allowsBulkBlockCaptures();
    }

    @Override
    public boolean doesBlockEventTracking(TileEntityTickContext context) {
        return context.allowsBlockEvents();
    }
}

