/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.hooks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.event.block.InteractBlockEvent;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.WorldAccessor;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.world.server.SpongeWorldManager;

public class SpongeImplHooks {
    public static String getModIdFromClass(Class<?> clazz) {
        String className = clazz.getName();
        if (className.startsWith("net.minecraft.")) {
            return "minecraft";
        }
        if (className.startsWith("org.spongepowered.")) {
            return "sponge";
        }
        return "unknown";
    }

    public static boolean isCreatureOfType(Entity entity, EntityClassification type) {
        return entity.getType().getClassification() == type;
    }

    public static boolean isFakePlayer(Entity entity) {
        return false;
    }

    public static void fireServerConnectionEvent(NetworkManager manager) {
    }

    public static void firePlayerJoinSpawnEvent(ServerPlayerEntity player) {
    }

    public static void handlePostChangeDimensionEvent(ServerPlayerEntity player, ServerWorld fromWorld, ServerWorld toWorld) {
    }

    public static boolean checkAttackEntity(PlayerEntity player, Entity victim) {
        return true;
    }

    public static double getBlockReachDistance(ServerPlayerEntity player) {
        return 5.0;
    }

    public static int getBlockLightOpacity(BlockState state, IBlockReader world, BlockPos pos) {
        return state.getLightValue();
    }

    public static int getChunkPosLight(BlockState blockState, World world, BlockPos pos) {
        return blockState.getLightValue();
    }

    public static @Nullable TileEntity createTileEntity(Block block, World world, BlockState state) {
        if (block instanceof ITileEntityProvider) {
            return ((ITileEntityProvider)block).createNewTileEntity((IBlockReader)world);
        }
        return null;
    }

    public static boolean hasBlockTileEntity(BlockState state) {
        return state.getBlock() instanceof ITileEntityProvider;
    }

    public static void onTileChunkUnload(TileEntity tileEntity) {
    }

    public static boolean canDoLightning(Dimension dimension, Chunk chunk) {
        return true;
    }

    public static boolean canDoRainSnowIce(Dimension dimension, Chunk chunk) {
        return true;
    }

    public static DimensionType getRespawnDimensionType(Dimension dimension, ServerPlayerEntity player) {
        return DimensionType.OVERWORLD;
    }

    public static BlockPos getRandomizedSpawnPoint(ServerWorld world) {
        BlockPos ret = world.getSpawnPoint();
        boolean isAdventure = world.getWorldInfo().getGameType() == GameType.ADVENTURE;
        int spawnFuzz = Math.max(0, world.getServer().getSpawnProtectionSize());
        int border = MathHelper.floor((double)world.getWorldBorder().getClosestDistance((double)ret.getX(), (double)ret.getZ()));
        if (border < spawnFuzz) {
            spawnFuzz = border;
        }
        throw new UnsupportedOperationException("Implement the rest of this please");
    }

    public static int getMaxSpawnPackSize(MobEntity mob) {
        return mob.getMaxSpawnedInChunk();
    }

    public static void onEntityError(Entity entity, CrashReport crashReport) {
        throw new ReportedException(crashReport);
    }

    public static void onTileEntityError(TileEntity tileEntity, CrashReport crashReport) {
        throw new ReportedException(crashReport);
    }

    public static void blockExploded(Block block, World world, BlockPos blockpos, Explosion explosion) {
        world.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 3);
        block.onExplosionDestroy(world, blockpos, explosion);
    }

    public static boolean isRestoringBlocks(World world) {
        return false;
    }

    public static void onTileEntityChunkUnload(TileEntity tileEntity) {
    }

    public static boolean canConnectRedstone(Block block, BlockState state, IWorldReader world, BlockPos pos, @Nullable Direction side) {
        return state.canProvidePower() && side != null;
    }

    public static @Nullable RayTraceResult rayTraceEyes(LivingEntity entity, double length) {
        return null;
    }

    public static boolean shouldKeepSpawnLoaded(Server server, DimensionType dimensionType) {
        ServerWorld world = ((SpongeWorldManager)server.getWorldManager()).getWorld(dimensionType);
        return world != null && ((WorldInfoBridge)world.getWorldInfo()).bridge$doesKeepSpawnLoaded();
    }

    public static void setKeepSpawnLoaded(DimensionType dimensionType, boolean keepSpawnLoaded) {
    }

    public static @Nullable BlockPos getBedLocation(PlayerEntity player, DimensionType dimensionType) {
        return ((PlayerEntityBridge)player).bridge$getBedLocation(dimensionType);
    }

    public static boolean isSpawnForced(PlayerEntity player, DimensionType dimensionType) {
        return ((PlayerEntityBridge)player).bridge$isSpawnForced(dimensionType);
    }

    public static Inventory toInventory(Object inventory, @Nullable Object forgeItemHandler) {
        SpongeCommon.getLogger().error("Unknown inventory " + inventory.getClass().getName() + " report this to Sponge");
        return null;
    }

    public static InventoryAdapter findInventoryAdapter(Object inventory) {
        SpongeCommon.getLogger().error("Unknown inventory " + inventory.getClass().getName() + " report this to Sponge");
        throw new IllegalArgumentException("Unknown inventory " + inventory.getClass().getName() + " report this to Sponge");
    }

    public static int getLootingEnchantmentModifier(LivingEntity target, LivingEntity entity, DamageSource cause) {
        return EnchantmentHelper.getLootingModifier((LivingEntity)entity);
    }

    public static double getWorldMaxEntityRadius(ServerWorld world) {
        return 2.0;
    }

    public static void onUseItemTick(LivingEntity living, ItemStack stack, int activeItemStackUseCount) {
    }

    public static void onTETickStart(TileEntity tileEntity) {
    }

    public static void onTETickEnd(TileEntity tileEntity) {
    }

    public static void onEntityTickStart(Entity entity) {
    }

    public static void onEntityTickEnd(Entity entity) {
    }

    public static boolean onServerThread() {
        return !Sponge.isServerAvailable() || Sponge.getServer().onMainThread();
    }

    public static boolean creativeExploitCheck(IPacket<?> packet, ServerPlayerEntity player) {
        return false;
    }

    public static String getImplementationId() {
        throw new UnsupportedOperationException("SpongeCommon does not have it's own ecosystem, this needs to be mixed into for implementations depending on SpongeCommon");
    }

    public static @Nullable Object postForgeEventDataCompatForSponge(InteractBlockEvent.Secondary spongeEvent) {
        SpongeCommon.postEvent(spongeEvent);
        return null;
    }

    public static void shouldCloseScreen(World world, BlockPos pos, @Nullable Object eventData, ServerPlayerEntity player) {
    }

    public static ActionResultType getInteractionCancellationResult(@Nullable Object forgeEventObject) {
        return ActionResultType.FAIL;
    }

    public static boolean doesItemSneakBypass(World worldIn, BlockPos pos, PlayerEntity player, ItemStack heldItemMainhand, ItemStack heldItemOffhand) {
        return heldItemMainhand.isEmpty() && heldItemOffhand.isEmpty();
    }

    public static @Nullable ActionResultType getEnumResultForProcessRightClickBlock(ServerPlayerEntity player, InteractBlockEvent.Secondary event, ActionResultType result, World world, BlockPos pos, Hand hand) {
        return ActionResultType.FAIL;
    }

    public static ActionResultType onForgeItemUseFirst(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Hand hand, Direction facing, float hitX, float hitY, float hitZ) {
        return ActionResultType.PASS;
    }

    public static boolean isClientEvent(Object object) {
        return false;
    }

    public static @Nullable Entity getCustomEntityIfItem(Entity entity) {
        return null;
    }

    public static boolean shouldTickTile(ITickableTileEntity tileEntity) {
        return true;
    }

    public static @Nullable ResourceLocation getItemResourceLocation(Item item) {
        return Registry.ITEM.getKey((Object)item);
    }

    public static void registerItemForSpongeRegistry(ResourceLocation key, Item item) {
    }

    public static void writeItemStackCapabilitiesToDataView(DataContainer container, ItemStack stack) {
    }

    public static boolean canEnchantmentBeAppliedToItem(Enchantment enchantment, ItemStack stack) {
        return enchantment.canApply(stack);
    }

    public static void setCapabilitiesFromSpongeBuilder(ItemStack stack, CompoundNBT compound) {
    }

    public static TileEntity onChunkGetTileDuringRemoval(ServerWorld world, BlockPos pos) {
        if (WorldAccessor.accessor$isOutsideBuildHeight(pos)) {
            return null;
        }
        TileEntity tileentity2 = null;
        if (((WorldAccessor)world).accessor$getProcessingLoadedTiles()) {
            tileentity2 = ((WorldAccessor)world).accessor$getPendingTileEntityAt(pos);
        }
        if (tileentity2 == null) {
            tileentity2 = world.getChunkAt(pos).getTileEntity(pos, Chunk.CreateEntityType.CHECK);
        }
        if (tileentity2 == null) {
            tileentity2 = ((WorldAccessor)world).accessor$getPendingTileEntityAt(pos);
        }
        return tileentity2;
    }

    public static boolean canEntityJoinWorld(Entity entity, ServerWorld world) {
        return false;
    }

    public static TileEntity createTileEntity(BlockState newState, World world) {
        return ((ITileEntityProvider)newState.getBlock()).createNewTileEntity((IBlockReader)world);
    }

    public static void onForgeCollision(World world, @Nullable Entity entityIn, AxisAlignedBB aabb, List<AxisAlignedBB> collided) {
    }
}

