/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject;

import com.google.inject.PrivateModule;
import com.google.inject.binder.AnnotatedBindingBuilder;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.AssetManager;
import org.spongepowered.api.command.manager.CommandManager;
import org.spongepowered.api.config.ConfigManager;
import org.spongepowered.api.data.DataManager;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.network.channel.ChannelRegistry;
import org.spongepowered.api.plugin.PluginManager;
import org.spongepowered.api.registry.GameRegistry;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.sql.SqlManager;
import org.spongepowered.api.util.metric.MetricsConfigManager;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeGame;
import org.spongepowered.common.SpongePlatform;
import org.spongepowered.common.asset.SpongeAssetManager;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.config.PluginConfigManager;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.event.SpongeEventManager;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.common.network.channel.ChannelBufferAllocator;
import org.spongepowered.common.network.channel.SpongeChannelRegistry;
import org.spongepowered.common.registry.SpongeGameRegistry;
import org.spongepowered.common.service.game.SpongeGameScopedServiceProvider;
import org.spongepowered.common.sql.SpongeSqlManager;
import org.spongepowered.common.util.metric.SpongeMetricsConfigManager;

public final class SpongeCommonModule
extends PrivateModule {
    @OverridingMethodsMustInvokeSuper
    protected void configure() {
        this.bind(Logger.class).toInstance((Object)SpongeCommon.getLogger());
        this.bindAndExpose(Game.class).to(SpongeGame.class);
        this.bindAndExpose(Platform.class).to(SpongePlatform.class);
        this.bindAndExpose(MinecraftVersion.class).toInstance((Object)SpongeCommon.MINECRAFT_VERSION);
        this.bindAndExpose(AssetManager.class).to(SpongeAssetManager.class);
        this.bindAndExpose(ChannelRegistry.class).toInstance((Object)new SpongeChannelRegistry(ChannelBufferAllocator.POOLED));
        this.bindAndExpose(EventManager.class).to(SpongeEventManager.class);
        this.bindAndExpose(PluginManager.class).toInstance((Object)((Launch)Launch.getInstance()).getPluginManager());
        this.bindAndExpose(GameRegistry.class).to(SpongeGameRegistry.class);
        this.bindAndExpose(DataManager.class).to(SpongeDataManager.class);
        this.bindAndExpose(ConfigManager.class).to(PluginConfigManager.class);
        this.bindAndExpose(MetricsConfigManager.class).to(SpongeMetricsConfigManager.class);
        this.bindAndExpose(SqlManager.class).to(SpongeSqlManager.class);
        this.bindAndExpose(ServiceProvider.GameScoped.class).to(SpongeGameScopedServiceProvider.class);
        this.bindAndExpose(CommandManager.class).to(SpongeCommandManager.class);
        this.requestStaticInjection(new Class[]{SpongeCommon.class});
        this.requestStaticInjection(new Class[]{Sponge.class});
    }

    protected <T> AnnotatedBindingBuilder<T> bindAndExpose(Class<T> type) {
        this.expose(type);
        return this.bind(type);
    }
}

