/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inject.provider;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.config.ConfigRoot;
import org.spongepowered.common.config.PluginConfigManager;
import org.spongepowered.common.inject.provider.ConfigDirAnnotation;
import org.spongepowered.common.inject.provider.DefaultConfigAnnotation;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ObjectMapper;
import org.spongepowered.configurate.objectmapping.guice.GuiceObjectMapperProvider;
import org.spongepowered.configurate.reference.ConfigurationReference;
import org.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.spongepowered.plugin.PluginContainer;

public final class PluginConfigurationModule
extends AbstractModule {
    private static final TypeLiteral<ConfigurationLoader<CommentedConfigurationNode>> COMMENTED_CONFIGURATION_NODE_LOADER = new TypeLiteral<ConfigurationLoader<CommentedConfigurationNode>>(){};
    private static final TypeLiteral<ConfigurationReference<CommentedConfigurationNode>> COMMENTED_CONFIGURATION_NODE_REFERENCE = new TypeLiteral<ConfigurationReference<CommentedConfigurationNode>>(){};

    protected void configure() {
        this.bind(Path.class).annotatedWith((Annotation)ConfigDirAnnotation.NON_SHARED).toProvider(NonSharedDirAsPath.class);
        this.bind(Path.class).annotatedWith((Annotation)DefaultConfigAnnotation.NON_SHARED).toProvider(NonSharedPathAsPath.class);
        this.bind(Path.class).annotatedWith((Annotation)DefaultConfigAnnotation.SHARED).toProvider(SharedDirAsPath.class);
        this.bind(TypeSerializerCollection.class).toProvider(TypeSerializers.class).in(Scopes.SINGLETON);
        this.bind(COMMENTED_CONFIGURATION_NODE_LOADER).annotatedWith((Annotation)DefaultConfigAnnotation.SHARED).toProvider(SharedCommentedConfigurationNode.class);
        this.bind(COMMENTED_CONFIGURATION_NODE_LOADER).annotatedWith((Annotation)DefaultConfigAnnotation.NON_SHARED).toProvider(PrivateCommentedConfigurationNode.class);
        this.bind(COMMENTED_CONFIGURATION_NODE_REFERENCE).annotatedWith((Annotation)DefaultConfigAnnotation.SHARED).toProvider(SharedCommentedConfigurationNodeReference.class);
        this.bind(COMMENTED_CONFIGURATION_NODE_REFERENCE).annotatedWith((Annotation)DefaultConfigAnnotation.NON_SHARED).toProvider(PrivateCommentedConfigurationNodeReference.class);
        this.requestStaticInjection(new Class[]{IHateGuiceInjectorProvider.class});
    }

    static final class TypeSerializers
    implements Provider<TypeSerializerCollection> {
        private final PluginContainer container;
        private final PluginConfigManager mgr;

        @Inject
        TypeSerializers(PluginContainer container, PluginConfigManager mgr) {
            this.container = container;
            this.mgr = mgr;
        }

        public TypeSerializerCollection get() {
            @Nullable Injector injector = IHateGuiceInjectorProvider.get(this.container);
            if (injector == null) {
                return this.mgr.getSerializers();
            }
            return this.mgr.getSerializers().childBuilder().registerAnnotatedObjects(ObjectMapper.factoryBuilder().addDiscoverer(GuiceObjectMapperProvider.injectedObjectDiscoverer((Injector)injector)).build()).build();
        }
    }

    static final class PrivateCommentedConfigurationNodeReference
    extends CommentedConfigurationNodeReferenceProvider {
        @Inject
        PrivateCommentedConfigurationNodeReference(PluginContainer container, PluginConfigManager mgr, Provider<TypeSerializerCollection> serializers) {
            super(container, mgr, serializers);
        }

        public ConfigurationReference<CommentedConfigurationNode> get() {
            ConfigRoot privateRoot = this.mgr.getPluginConfig(this.container);
            try {
                return this.configureLogging(privateRoot.getConfigPath(), this.mgr.getWatchServiceListener().listenToConfiguration(path -> privateRoot.getConfig(PluginConfigManager.getOptions((TypeSerializerCollection)this.serializers.get())), privateRoot.getConfigPath()));
            }
            catch (ConfigurateException ex) {
                throw new ProvisionException("Unable to load configuration reference", (Throwable)ex);
            }
        }
    }

    static final class SharedCommentedConfigurationNodeReference
    extends CommentedConfigurationNodeReferenceProvider {
        @Inject
        SharedCommentedConfigurationNodeReference(PluginContainer container, PluginConfigManager mgr, Provider<TypeSerializerCollection> serializers) {
            super(container, mgr, serializers);
        }

        public ConfigurationReference<CommentedConfigurationNode> get() {
            ConfigRoot shared = this.mgr.getSharedConfig(this.container);
            try {
                return this.configureLogging(shared.getConfigPath(), this.mgr.getWatchServiceListener().listenToConfiguration(path -> shared.getConfig(PluginConfigManager.getOptions((TypeSerializerCollection)this.serializers.get())), shared.getConfigPath()));
            }
            catch (ConfigurateException ex) {
                throw new ProvisionException("Unable to load configuration reference", (Throwable)ex);
            }
        }
    }

    static abstract class CommentedConfigurationNodeReferenceProvider
    implements Provider<ConfigurationReference<CommentedConfigurationNode>> {
        protected final PluginContainer container;
        protected final PluginConfigManager mgr;
        protected final Provider<TypeSerializerCollection> serializers;

        @Inject
        CommentedConfigurationNodeReferenceProvider(PluginContainer container, PluginConfigManager mgr, Provider<TypeSerializerCollection> serializers) {
            this.container = container;
            this.mgr = mgr;
            this.serializers = serializers;
        }

        protected <N extends ConfigurationNode> ConfigurationReference<N> configureLogging(Path file, ConfigurationReference<N> reference) {
            reference.errors().subscribe(error -> {
                ConfigurationReference.ErrorPhase phase = (ConfigurationReference.ErrorPhase)((Object)((Object)error.getKey()));
                Throwable cause = (Throwable)error.getValue();
                this.container.getLogger().error("Failed to perform a {} in the configuration for {} at {}:", (Object)phase, (Object)this.container.getMetadata().getId(), (Object)file, (Object)cause);
            });
            return reference;
        }
    }

    static final class PrivateCommentedConfigurationNode
    extends CommentedConfigurationNodeProvider {
        @Inject
        PrivateCommentedConfigurationNode(PluginContainer container, PluginConfigManager mgr, Provider<TypeSerializerCollection> serializers) {
            super(container, mgr, serializers);
        }

        public ConfigurationLoader<CommentedConfigurationNode> get() {
            return this.mgr.getPluginConfig(this.container).getConfig(PluginConfigManager.getOptions((TypeSerializerCollection)this.serializers.get()));
        }
    }

    static final class SharedCommentedConfigurationNode
    extends CommentedConfigurationNodeProvider {
        @Inject
        SharedCommentedConfigurationNode(PluginContainer container, PluginConfigManager mgr, Provider<TypeSerializerCollection> serializers) {
            super(container, mgr, serializers);
        }

        public ConfigurationLoader<CommentedConfigurationNode> get() {
            return this.mgr.getSharedConfig(this.container).getConfig(PluginConfigManager.getOptions((TypeSerializerCollection)this.serializers.get()));
        }
    }

    static abstract class CommentedConfigurationNodeProvider
    implements Provider<ConfigurationLoader<CommentedConfigurationNode>> {
        protected final PluginContainer container;
        protected final PluginConfigManager mgr;
        protected final Provider<TypeSerializerCollection> serializers;

        @Inject
        CommentedConfigurationNodeProvider(PluginContainer container, PluginConfigManager mgr, Provider<TypeSerializerCollection> serializers) {
            this.container = container;
            this.mgr = mgr;
            this.serializers = serializers;
        }
    }

    static final class SharedDirAsPath
    implements Provider<Path> {
        private final PluginContainer container;
        private final PluginConfigManager mgr;

        @Inject
        SharedDirAsPath(PluginContainer container, PluginConfigManager mgr) {
            this.container = container;
            this.mgr = mgr;
        }

        public Path get() {
            return this.mgr.getSharedConfig(this.container).getConfigPath();
        }
    }

    static final class NonSharedPathAsPath
    implements Provider<Path> {
        private final PluginContainer container;
        private final PluginConfigManager mgr;

        @Inject
        NonSharedPathAsPath(PluginContainer container, PluginConfigManager mgr) {
            this.container = container;
            this.mgr = mgr;
        }

        public Path get() {
            return this.mgr.getPluginConfig(this.container).getConfigPath();
        }
    }

    static final class NonSharedDirAsPath
    implements Provider<Path> {
        private final PluginContainer container;
        private final PluginConfigManager mgr;

        @Inject
        NonSharedDirAsPath(PluginContainer container, PluginConfigManager mgr) {
            this.container = container;
            this.mgr = mgr;
        }

        public Path get() {
            return this.mgr.getPluginConfig(this.container).getDirectory();
        }
    }

    static final class IHateGuiceInjectorProvider {
        private static final Map<PluginContainer, Injector> injectors = new ConcurrentHashMap<PluginContainer, Injector>();

        IHateGuiceInjectorProvider() {
        }

        @Inject
        static void acceptRegistration(PluginContainer container, Injector injector) {
            injectors.put(container, injector);
        }

        public static @Nullable Injector get(PluginContainer container) {
            return injectors.get(container);
        }
    }
}

