/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.IntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.ContainerType;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.inventory.custom.CustomContainer;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.custom.SpongeViewableInventoryBuilder;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;

public class ViewableCustomInventory
extends CustomInventory
implements INamedContainerProvider {
    private ContainerType type;
    private SpongeViewableInventoryBuilder.ContainerTypeInfo info;
    private boolean vanilla = false;
    private Set<PlayerEntity> viewers = new HashSet<PlayerEntity>();
    private final IntArray data;

    public ViewableCustomInventory(ContainerType type, SpongeViewableInventoryBuilder.ContainerTypeInfo info, int size, Lens lens, SlotLensProvider provider, List<Inventory> inventories, @Nullable UUID identity, @Nullable Carrier carrier) {
        super(size, lens, provider, inventories, identity, carrier);
        this.type = type;
        this.info = info;
        this.data = this.info.dataProvider.get();
    }

    public ViewableCustomInventory vanilla() {
        this.vanilla = true;
        return this;
    }

    public ContainerType getType() {
        return this.type;
    }

    public void openInventory(PlayerEntity player) {
        this.viewers.add(player);
    }

    public void closeInventory(PlayerEntity player) {
        this.viewers.remove(player);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        if (this.vanilla) {
            return this.info.containerProvider.createMenu(id, playerInv, player, this);
        }
        return new CustomContainer(id, player, this, this.type);
    }

    public IntArray getData() {
        return this.data;
    }

    public ITextComponent getDisplayName() {
        return new StringTextComponent("ViewableCustomInventory");
    }
}

