/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.lens.impl;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.container.Slot;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.common.accessor.inventory.container.SlotAccessor;
import org.spongepowered.common.inventory.adapter.impl.BasicInventoryAdapter;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.Lens;
import org.spongepowered.common.inventory.lens.impl.AbstractLens;
import org.spongepowered.common.inventory.lens.impl.DefaultIndexedLens;
import org.spongepowered.common.inventory.lens.impl.slot.SlotLensProvider;
import org.spongepowered.common.inventory.lens.slots.SlotLens;
import org.spongepowered.common.inventory.property.KeyValuePair;

public class DelegatingLens
extends AbstractLens {
    private Lens delegate;

    public DelegatingLens(int base, Lens lens) {
        super(base, lens.slotCount(), BasicInventoryAdapter.class);
        this.delegate = lens;
        this.addSpanningChild(lens, new KeyValuePair[0]);
    }

    public DelegatingLens(int base, Lens lens, SlotLensProvider slots) {
        super(base, lens.slotCount(), BasicInventoryAdapter.class);
        this.delegate = lens;
        this.init(slots);
    }

    public DelegatingLens(int base, List<Slot> containerSlots, Lens lens, SlotLensProvider slots) {
        super(base, containerSlots.size(), BasicInventoryAdapter.class);
        this.delegate = lens;
        CustomSlotProvider slotProvider = new CustomSlotProvider();
        for (Slot slot : containerSlots) {
            slotProvider.add(slots.getSlotLens(((SlotAccessor)slot).accessor$getSlotNumber()));
        }
        this.addSpanningChild(new DefaultIndexedLens(0, containerSlots.size(), slotProvider), new KeyValuePair[0]);
        this.addChild(this.delegate, new KeyValuePair[0]);
    }

    protected void init(SlotLensProvider slots) {
        this.addSpanningChild(new DefaultIndexedLens(this.base, this.size, slots), new KeyValuePair[0]);
        this.addChild(this.delegate, new KeyValuePair[0]);
    }

    public Lens getDelegate() {
        return this.delegate;
    }

    @Override
    public Inventory getAdapter(Fabric fabric, Inventory parent) {
        return this.delegate.getAdapter(fabric.fabric$offset(this.base), parent);
    }

    public static class CustomSlotProvider
    implements SlotLensProvider {
        private List<SlotLens> lenses = new ArrayList<SlotLens>();

        public void add(SlotLens toAdd) {
            this.lenses.add(toAdd);
        }

        @Override
        public SlotLens getSlotLens(int index) {
            return this.lenses.get(index);
        }
    }
}

