/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.inventory.util;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.ChestBlock;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.carrier.chest.Chest;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.Carrier;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.inventory.type.CarriedInventory;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.inventory.InventoryBridge;
import org.spongepowered.common.bridge.inventory.container.TrackedInventoryBridge;
import org.spongepowered.common.entity.player.SpongeUser;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.inventory.adapter.InventoryAdapter;
import org.spongepowered.common.inventory.adapter.impl.comp.CraftingGridInventoryAdapter;
import org.spongepowered.common.inventory.custom.CarriedWrapperInventory;
import org.spongepowered.common.inventory.custom.CustomInventory;
import org.spongepowered.common.inventory.fabric.Fabric;
import org.spongepowered.common.inventory.lens.impl.comp.CraftingGridInventoryLens;
import org.spongepowered.common.inventory.lens.impl.slot.BasicSlotLens;
import org.spongepowered.common.launch.Launch;
import org.spongepowered.plugin.PluginContainer;

public final class InventoryUtil {
    private InventoryUtil() {
    }

    public static CraftingGridInventory toSpongeInventory(CraftingInventory inv) {
        CraftingGridInventoryLens lens = new CraftingGridInventoryLens(0, inv.getWidth(), inv.getHeight(), BasicSlotLens::new);
        return new CraftingGridInventoryAdapter((Fabric)inv, lens);
    }

    public static <C extends IInventory> C toNativeInventory(Inventory inv) {
        Fabric fabric = ((CraftingGridInventoryAdapter)inv).inventoryAdapter$getFabric();
        for (InventoryBridge inventory : fabric.fabric$allInventories()) {
            if (!(inventory instanceof CraftingInventory)) continue;
            return (C)((IInventory)inventory);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Invalid CraftingGridInventory. Could not find InventoryCrafting.\n").append("Fabric was: ").append(fabric.getClass().getSimpleName()).append(" Name: ").append("Viewed:");
        for (InventoryBridge iInventory : fabric.fabric$allInventories()) {
            sb.append("\n").append(iInventory.getClass().getName());
        }
        throw new IllegalStateException(sb.toString());
    }

    public static Optional<Inventory> getDoubleChestInventory(ChestTileEntity chest) {
        Optional<Chest> connectedChestOptional = ((Chest)chest).getConnectedChest();
        if (!connectedChestOptional.isPresent()) {
            return Optional.empty();
        }
        ChestType chestType = (ChestType)chest.getBlockState().get((IProperty)ChestBlock.TYPE);
        ChestTileEntity connectedChest = (ChestTileEntity)connectedChestOptional.get();
        if (chestType == ChestType.RIGHT) {
            return Optional.of((Inventory)new DoubleSidedInventory((IInventory)chest, (IInventory)connectedChest));
        }
        return Optional.of((Inventory)new DoubleSidedInventory((IInventory)connectedChest, (IInventory)chest));
    }

    public static Inventory toInventory(IInventory inventory) {
        return InventoryUtil.toInventory(inventory, null);
    }

    public static Inventory toInventory(Object inventory, @Nullable Object forgeItemHandler) {
        if (forgeItemHandler == null) {
            if (inventory instanceof ChestTileEntity) {
                inventory = InventoryUtil.getDoubleChestInventory((ChestTileEntity)inventory).orElse((Inventory)inventory);
            }
            if (inventory instanceof Inventory) {
                return (Inventory)inventory;
            }
        }
        if (forgeItemHandler instanceof Inventory) {
            return (Inventory)forgeItemHandler;
        }
        return SpongeImplHooks.toInventory(inventory, forgeItemHandler);
    }

    public static InventoryAdapter findAdapter(Object inventory) {
        if (inventory instanceof InventoryAdapter) {
            return (InventoryAdapter)inventory;
        }
        return SpongeImplHooks.findInventoryAdapter(inventory);
    }

    public static TrackedInventoryBridge forCapture(Object toCapture) {
        if (toCapture instanceof TrackedInventoryBridge) {
            return (TrackedInventoryBridge)toCapture;
        }
        return null;
    }

    public static PluginContainer getPluginContainer(Object inventory) {
        PluginContainer container;
        Object base;
        Optional carrier;
        if (inventory instanceof CustomInventory) {
            return ((CustomInventory)inventory).getPlugin();
        }
        if (inventory instanceof CarriedInventory && (carrier = ((CarriedInventory)inventory).getCarrier()).isPresent()) {
            inventory = carrier.get();
        }
        if ((base = inventory) instanceof BlockEntity) {
            ResourceKey key = ((BlockEntity)base).getBlock().getType().getKey();
            String pluginId = key.getNamespace();
            container = Sponge.getPluginManager().getPlugin(pluginId).orElseThrow(() -> new AssertionError((Object)("Missing plugin " + pluginId + " for block " + key.getNamespace() + ":" + key.getValue())));
        } else if (base instanceof Entity) {
            ResourceKey key = ((Entity)base).getType().getKey();
            String pluginId = key.getNamespace();
            container = Sponge.getPluginManager().getPlugin(pluginId).orElseGet(() -> {
                SpongeCommon.getLogger().debug("Unknown plugin for [{}]", base);
                return ((Launch)Launch.getInstance()).getMinecraftPlugin();
            });
        } else {
            container = base instanceof SpongeUser ? ((Launch)Launch.getInstance()).getMinecraftPlugin() : Sponge.getPluginManager().getPlugin(SpongeImplHooks.getModIdFromClass(base.getClass())).orElseGet(() -> {
                SpongeCommon.getLogger().debug("Unknown plugin for [{}]", base);
                return ((Launch)Launch.getInstance()).getMinecraftPlugin();
            });
        }
        return container;
    }

    public static <T extends Carrier> CarriedInventory<T> carriedWrapperInventory(IInventory inventory, T carrier) {
        return (CarriedInventory)((Object)new CarriedWrapperInventory(inventory, carrier));
    }
}

