/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.data.DataHolderBuilder;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.hooks.SpongeImplHooks;
import org.spongepowered.common.item.SpongeItemStackSnapshot;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.PrettyPrinter;

public final class SpongeItemStackBuilder
extends AbstractDataBuilder<ItemStack>
implements ItemStack.Builder {
    @Nullable
    private Set<DataHolderBuilder.Mutable<?, ?>> itemDataSet;
    private ItemType type;
    private int quantity;
    @Nullable
    private LinkedHashMap<Key<?>, Object> keyValues;
    @Nullable
    private CompoundNBT compound;

    public SpongeItemStackBuilder() {
        super(ItemStack.class, 1);
        this.reset();
    }

    @Override
    public ItemStack.Builder itemType(ItemType itemType) {
        Preconditions.checkNotNull((Object)itemType, (Object)"Item type cannot be null");
        this.type = itemType;
        return this;
    }

    @Override
    public ItemType getCurrentItem() {
        return this.type == null ? BlockTypes.AIR.get().getItem().get() : this.type;
    }

    @Override
    public ItemStack.Builder quantity(int quantity) throws IllegalArgumentException {
        Preconditions.checkArgument((quantity >= 0 ? 1 : 0) != 0, (Object)"Quantity must not be smaller than 0");
        this.quantity = quantity;
        return this;
    }

    @Override
    public <V> ItemStack.Builder add(Key<? extends Value<V>> key, V value) throws IllegalArgumentException {
        if (this.keyValues == null) {
            this.keyValues = new LinkedHashMap();
        }
        this.keyValues.put((Key<?>)Preconditions.checkNotNull(key, (Object)"Key cannot be null!"), Preconditions.checkNotNull(value, (Object)"Value cannot be null!"));
        return this;
    }

    @Override
    public ItemStack.Builder fromItemStack(ItemStack itemStack) {
        Preconditions.checkNotNull((Object)itemStack, (Object)"Item stack cannot be null");
        this.itemDataSet = new HashSet();
        this.type = itemStack.getType();
        this.quantity = itemStack.getQuantity();
        if (itemStack instanceof net.minecraft.item.ItemStack) {
            CompoundNBT itemCompound = ((net.minecraft.item.ItemStack)itemStack).getTag();
            this.compound = itemCompound != null && !itemCompound.isEmpty() ? itemCompound.copy() : null;
        }
        return this;
    }

    @Override
    public ItemStack.Builder attributeModifier(AttributeType attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
        CompoundNBT compound;
        Preconditions.checkNotNull((Object)attributeType, (Object)"AttributeType cannot be null");
        Preconditions.checkNotNull((Object)modifier, (Object)"AttributeModifier cannot be null");
        Preconditions.checkNotNull((Object)equipmentType, (Object)"EquipmentType cannot be null");
        if (this.compound == null) {
            this.compound = new CompoundNBT();
        }
        if (!(compound = this.compound).contains("AttributeModifiers", 9)) {
            compound.put("AttributeModifiers", (INBT)new ListNBT());
        }
        ListNBT attributeModifiers = compound.getList("AttributeModifiers", 10);
        return this;
    }

    private void writeAttributeModifier(ListNBT attributeModifiers, net.minecraft.entity.ai.attributes.AttributeModifier attributeModifier, EquipmentSlotType slot) {
        CompoundNBT modifierNbt = SharedMonsterAttributes.writeAttributeModifier((net.minecraft.entity.ai.attributes.AttributeModifier)attributeModifier);
        modifierNbt.putString("AttributeName", attributeModifier.getName());
        if (slot != null) {
            modifierNbt.putString("Slot", slot.getName());
        }
        attributeModifiers.add((Object)modifierNbt);
    }

    @Override
    public ItemStack.Builder fromContainer(DataView container) {
        Preconditions.checkNotNull((Object)container);
        if (!container.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
            return this;
        }
        this.reset();
        int count = container.getInt(Constants.ItemStack.COUNT).get();
        this.quantity(count);
        ItemType itemType = container.getCatalogType(Constants.ItemStack.TYPE, ItemType.class).get();
        this.itemType(itemType);
        if (container.contains(Constants.Sponge.UNSAFE_NBT)) {
            CompoundNBT compound = NbtTranslator.getInstance().translate(container.getView(Constants.Sponge.UNSAFE_NBT).get());
            if (compound.contains("SpongeData", 10)) {
                compound.remove("SpongeData");
            }
            this.compound = !compound.isEmpty() ? compound : null;
        }
        if (container.contains(Constants.Sponge.DATA_MANIPULATORS)) {
            List<DataView> list = container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get();
        }
        return this;
    }

    @Override
    public ItemStack.Builder fromSnapshot(ItemStackSnapshot snapshot) {
        Preconditions.checkNotNull((Object)snapshot, (Object)"The snapshot was null!");
        this.itemType(snapshot.getType());
        this.quantity(snapshot.getQuantity());
        for (Value.Immutable value : snapshot.getValues()) {
            this.add(value);
        }
        if (snapshot instanceof SpongeItemStackSnapshot) {
            this.compound = ((SpongeItemStackSnapshot)snapshot).getCompound().orElse(null);
        }
        return this;
    }

    @Override
    public ItemStack.Builder fromBlockSnapshot(BlockSnapshot blockSnapshot) {
        Optional<CompoundNBT> compound;
        Preconditions.checkNotNull((Object)blockSnapshot, (Object)"The snapshot was null!");
        this.reset();
        BlockType blockType = blockSnapshot.getState().getType();
        Optional<ItemType> itemType = blockType.getItem();
        this.itemType(itemType.orElseThrow(() -> new IllegalArgumentException("ItemType not found for block type: " + blockType.getKey())));
        this.quantity(1);
        if (blockSnapshot instanceof SpongeBlockSnapshot && (compound = ((SpongeBlockSnapshot)blockSnapshot).getCompound()).isPresent()) {
            this.compound = new CompoundNBT();
            this.compound.put("BlockEntityTag", (INBT)compound.get());
        }
        return this;
    }

    @Override
    public ItemStack.Builder fromBlockState(BlockState blockState) {
        net.minecraft.block.BlockState minecraftState = (net.minecraft.block.BlockState)blockState;
        Optional<ItemType> item = blockState.getType().getItem();
        if (!item.isPresent()) {
            new PrettyPrinter(60).add("Invalid BlockState").centre().hr().add("Someone attempted to create an ItemStack from a BlockState that does not have a valid item!").add("%s : %s", "BlockState", blockState).add("%s : %s", "BlockType", blockState.getType()).add(new Exception("Stacktrace")).trace();
            return this;
        }
        this.itemType(item.get());
        return this;
    }

    @Override
    public ItemStack.Builder from(ItemStack value) {
        return this.fromItemStack(value);
    }

    @Override
    protected Optional<ItemStack> buildContent(DataView container) throws InvalidDataException {
        CompoundNBT compound;
        Preconditions.checkNotNull((Object)container);
        if (!container.contains(Constants.ItemStack.TYPE, Constants.ItemStack.COUNT)) {
            return Optional.empty();
        }
        int count = container.getInt(Constants.ItemStack.COUNT).get();
        ItemType itemType = container.getCatalogType(Constants.ItemStack.TYPE, ItemType.class).orElseThrow(() -> new IllegalStateException("Unable to find item with id: "));
        net.minecraft.item.ItemStack itemStack = new net.minecraft.item.ItemStack((IItemProvider)((Item)itemType), count);
        if (container.contains(Constants.Sponge.UNSAFE_NBT) && !(compound = NbtTranslator.getInstance().translate(container.getView(Constants.Sponge.UNSAFE_NBT).get())).isEmpty()) {
            SpongeItemStackBuilder.fixEnchantmentData(itemType, compound);
            itemStack.setTag(compound);
        }
        if (container.contains(Constants.Sponge.DATA_MANIPULATORS)) {
            List<DataView> list = container.getViewList(Constants.Sponge.DATA_MANIPULATORS).get();
        }
        return Optional.of((ItemStack)itemStack);
    }

    @Override
    public ItemStack.Builder reset() {
        this.type = null;
        this.quantity = 1;
        this.itemDataSet = new HashSet();
        this.compound = null;
        return this;
    }

    @Override
    public ItemStack build() throws IllegalStateException {
        CompoundNBT compoundTag;
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"Item type has not been set");
        if (this.type == null || this.quantity <= 0) {
            return (ItemStack)net.minecraft.item.ItemStack.EMPTY;
        }
        ItemStack stack = (ItemStack)new net.minecraft.item.ItemStack((IItemProvider)((Item)this.type), this.quantity);
        if (this.compound != null && !this.compound.isEmpty()) {
            ((net.minecraft.item.ItemStack)stack).setTag(this.compound.copy());
        }
        if (this.keyValues != null) {
            this.keyValues.forEach((key, value) -> stack.offer(key, value));
        }
        if (this.compound != null && this.compound.contains("ForgeCaps", 10) && (compoundTag = this.compound.getCompound("ForgeCaps")) != null) {
            SpongeImplHooks.setCapabilitiesFromSpongeBuilder((net.minecraft.item.ItemStack)stack, compoundTag);
        }
        return stack;
    }

    public static void fixEnchantmentData(ItemType itemType, CompoundNBT compound) {
        ListNBT nbttaglist = itemType == Items.ENCHANTED_BOOK ? compound.getList("StoredEnchantments", 10) : compound.getList("Enchantments", 10);
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT nbttagcompound = nbttaglist.getCompound(i);
            short id = nbttagcompound.getShort("id");
            short lvl = nbttagcompound.getShort("lvl");
            nbttagcompound.putShort("id", id);
            nbttagcompound.putShort("lvl", lvl);
        }
    }
}

