/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe;

import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.util.registry.Registry;
import org.apache.commons.io.FileUtils;
import org.spongepowered.api.item.recipe.RecipeRegistration;

public class SpongeRecipeProvider {
    private static final int PACK_VERSION_1_15 = 6;

    public static void registerRecipes(Registry<RecipeRegistration> recipes) {
        Path datapackPluginRecipes = Paths.get("world", new String[0]).resolve("datapacks").resolve("plugin-recipes");
        try {
            FileUtils.deleteDirectory((File)datapackPluginRecipes.toFile());
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not clear plugin-recipes datapack.", e);
        }
        for (RecipeRegistration recipe : recipes) {
            IFinishedRecipe mcRecipe = (IFinishedRecipe)recipe;
            SpongeRecipeProvider.save(datapackPluginRecipes, mcRecipe);
        }
        if (!recipes.keySet().isEmpty()) {
            Path packMeta = datapackPluginRecipes.resolve("pack.mcmeta");
            JsonObject packDataRoot = new JsonObject();
            JsonObject packData = new JsonObject();
            packDataRoot.add("pack", packData);
            packData.addProperty("pack_format", 6);
            packData.addProperty("description", "Sponge Plugin provided Recipes");
            SpongeRecipeProvider.saveToFile(packDataRoot, packMeta);
        }
    }

    private static void save(Path datpackPath, IFinishedRecipe recipe) {
        Path namespacedData = datpackPath.resolve("data").resolve(recipe.getID().getNamespace());
        Path recipeFile = namespacedData.resolve("recipes").resolve(recipe.getID().getPath() + ".json");
        SpongeRecipeProvider.saveToFile(recipe.getRecipeJson(), recipeFile);
        JsonObject jsonobject = recipe.getAdvancementJson();
        if (jsonobject != null) {
            Path advancementFile = namespacedData.resolve("advancements").resolve(recipe.getAdvancementID().getPath() + ".json");
            SpongeRecipeProvider.saveToFile(jsonobject, advancementFile);
        }
    }

    private static void saveToFile(JsonObject json, Path pathIn) {
        try {
            Files.createDirectories(pathIn.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(pathIn, new OpenOption[0]);){
                bufferedwriter.write(json.toString());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

