/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import com.google.gson.JsonObject;
import java.util.function.Function;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.ResultUtil;

public class SpongeCookingRecipeRegistration
extends SpongeRecipeRegistration {
    private final Ingredient ingredient;
    private final Item result;
    private final float experience;
    private final int cookingTime;
    private final ItemStack spongeResult;
    private final Function<IInventory, ItemStack> resultFunction;

    public SpongeCookingRecipeRegistration(ResourceLocation key, IRecipeSerializer<?> serializer, String group, Ingredient ingredient, float experience, int cookingTime, ItemStack spongeResult, Function<IInventory, ItemStack> resultFunction) {
        super(key, serializer, spongeResult.getItem(), group);
        this.ingredient = ingredient;
        this.result = spongeResult.getItem();
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.spongeResult = spongeResult.hasTag() ? spongeResult : null;
        this.resultFunction = resultFunction;
    }

    @Override
    public void serializeShape(JsonObject json) {
        json.add("ingredient", this.ingredient.serialize());
    }

    @Override
    public void serializeResult(JsonObject json) {
        json.addProperty("result", Registry.ITEM.getKey((Object)this.result).toString());
        if (this.spongeResult != null) {
            this.spongeResult.setCount(1);
            json.add("sponge:result", ResultUtil.serializeItemStack(this.spongeResult));
        }
        if (this.resultFunction != null) {
            json.addProperty("sponge:result_function", ResultUtil.cacheResultFunction(this.getID(), this.resultFunction));
        }
    }

    @Override
    public void serializeAdditional(JsonObject json) {
        json.addProperty("experience", Float.valueOf(this.experience));
        json.addProperty("cookingtime", this.cookingTime);
    }
}

