/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shaped;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.crafting.CraftingGridInventory;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.api.item.recipe.crafting.ShapedCraftingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shaped.SpongeShapedCraftingRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shaped.SpongeShapedCraftingRecipeSerializer;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.SpongeCatalogBuilder;

public final class SpongeShapedCraftingRecipeBuilder
extends SpongeCatalogBuilder<RecipeRegistration, ShapedCraftingRecipe.Builder>
implements ShapedCraftingRecipe.Builder,
ShapedCraftingRecipe.Builder.AisleStep.ResultStep,
ShapedCraftingRecipe.Builder.RowsStep.ResultStep,
ShapedCraftingRecipe.Builder.EndStep {
    private List<String> aisle = Lists.newArrayList();
    private Map<Character, Ingredient> ingredientMap = new Char2ObjectArrayMap();
    private Map<Ingredient, Character> reverseIngredientMap = new IdentityHashMap<Ingredient, Character>();
    private ItemStack result = ItemStack.empty();
    private Function<CraftingInventory, NonNullList<net.minecraft.item.ItemStack>> remainingItemsFunction;
    private Function<CraftingInventory, net.minecraft.item.ItemStack> resultFunction;
    private String group;

    @Override
    public ShapedCraftingRecipe.Builder.AisleStep aisle(String ... aisle) {
        Preconditions.checkNotNull((Object)aisle, (Object)"aisle");
        this.aisle.clear();
        this.ingredientMap.clear();
        this.reverseIngredientMap.clear();
        Collections.addAll(this.aisle, aisle);
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.AisleStep.ResultStep where(char symbol, Ingredient ingredient) throws IllegalArgumentException {
        if (this.aisle.stream().noneMatch(row -> row.indexOf(symbol) >= 0)) {
            throw new IllegalArgumentException("The symbol '" + symbol + "' is not defined in the aisle pattern.");
        }
        this.ingredientMap.put(Character.valueOf(symbol), ingredient == null ? Ingredient.empty() : ingredient);
        this.reverseIngredientMap.put(ingredient, Character.valueOf(symbol));
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.AisleStep.ResultStep where(Map<Character, Ingredient> ingredientMap) throws IllegalArgumentException {
        for (Map.Entry<Character, Ingredient> entry : ingredientMap.entrySet()) {
            this.where(entry.getKey().charValue(), entry.getValue());
        }
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.RowsStep rows() {
        this.aisle.clear();
        this.ingredientMap.clear();
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.RowsStep.ResultStep row(int skip, Ingredient ... ingredients) {
        int columns = ingredients.length + skip;
        if (!this.aisle.isEmpty()) {
            Preconditions.checkState((this.aisle.get(0).length() == columns ? 1 : 0) != 0, (Object)"The rows have an inconsistent width.");
        }
        StringBuilder row = new StringBuilder();
        for (int i = 0; i < skip; ++i) {
            row.append(" ");
        }
        int key = 65 + columns * this.aisle.size();
        for (Ingredient ingredient : ingredients) {
            Character usedKey = this.reverseIngredientMap.get(ingredient);
            if (usedKey == null) {
                usedKey = Character.valueOf((char)key);
                ++key;
            }
            row.append(usedKey);
            this.ingredientMap.put(usedKey, ingredient);
            this.reverseIngredientMap.put(ingredient, usedKey);
        }
        this.aisle.add(row.toString());
        return this;
    }

    public ShapedCraftingRecipe.Builder.ResultStep shapedLike(ShapedCraftingRecipe recipe) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public ShapedCraftingRecipe.Builder.ResultStep remainingItems(Function<CraftingGridInventory, List<ItemStack>> remainingItemsFunction) {
        this.remainingItemsFunction = grid -> {
            NonNullList mcList = NonNullList.create();
            ((List)remainingItemsFunction.apply(InventoryUtil.toSpongeInventory(grid))).forEach(stack -> mcList.add((Object)ItemStackUtil.toNative(stack)));
            return mcList;
        };
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep result(ItemStackSnapshot result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        return this.result(result.createStack());
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep result(ItemStack result) {
        Preconditions.checkNotNull((Object)result, (Object)"result");
        this.result = result.copy();
        this.resultFunction = null;
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep result(Function<CraftingGridInventory, ItemStack> resultFunction, ItemStack exemplaryResult) {
        this.resultFunction = inv -> ItemStackUtil.toNative((ItemStack)resultFunction.apply(InventoryUtil.toSpongeInventory(inv)));
        this.result = exemplaryResult.copy();
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    @Override
    public ShapedCraftingRecipe.Builder.EndStep key(ResourceKey key) {
        super.key(key);
        return this;
    }

    @Override
    protected RecipeRegistration build(ResourceKey key) {
        Preconditions.checkState((!this.aisle.isEmpty() ? 1 : 0) != 0, (Object)"aisle has not been set");
        Preconditions.checkState((!this.ingredientMap.isEmpty() ? 1 : 0) != 0, (Object)"no ingredients set");
        Preconditions.checkState((!this.result.isEmpty() ? 1 : 0) != 0, (Object)"no result set");
        Iterator<String> aisleIterator = this.aisle.iterator();
        String aisleRow = aisleIterator.next();
        int width = aisleRow.length();
        Preconditions.checkState((width > 0 ? 1 : 0) != 0, (Object)"The aisle cannot be empty.");
        while (aisleIterator.hasNext()) {
            aisleRow = aisleIterator.next();
            Preconditions.checkState((aisleRow.length() == width ? 1 : 0) != 0, (Object)"The aisle has an inconsistent width.");
        }
        Map<Character, net.minecraft.item.crafting.Ingredient> ingredientsMap = this.ingredientMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> IngredientUtil.toNative((Ingredient)e.getValue())));
        net.minecraft.item.ItemStack resultStack = ItemStackUtil.toNative(this.result);
        IRecipeSerializer<?> serializer = SpongeRecipeRegistration.determineSerializer(resultStack, this.resultFunction, this.remainingItemsFunction, ingredientsMap, IRecipeSerializer.CRAFTING_SHAPED, SpongeShapedCraftingRecipeSerializer.SPONGE_CRAFTING_SHAPED);
        return new SpongeShapedCraftingRecipeRegistration((ResourceLocation)key, serializer, this.group, this.aisle, ingredientsMap, resultStack, this.resultFunction, this.remainingItemsFunction);
    }

    @Override
    public ShapedCraftingRecipe.Builder reset() {
        super.reset();
        this.aisle = new ArrayList<String>();
        this.ingredientMap = new HashMap<Character, Ingredient>();
        this.result = ItemStack.empty();
        this.resultFunction = null;
        this.group = null;
        this.remainingItemsFunction = null;
        return this;
    }
}

