/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.function.Function;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessRecipe;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.ingredient.ResultUtil;

public class SpongeShapelessCraftingRecipeSerializer
extends ShapelessRecipe.Serializer {
    public static IRecipeSerializer<?> SPONGE_CRAFTING_SHAPELESS = SpongeRecipeRegistration.register("crafting_shapeless", new SpongeShapelessCraftingRecipeSerializer());

    public ShapelessRecipe read(ResourceLocation recipeId, JsonObject json) {
        String s2 = JSONUtils.getString((JsonObject)json, (String)"group", (String)"");
        NonNullList<Ingredient> nonnulllist = this.readIngredients(JSONUtils.getJsonArray((JsonObject)json, (String)"ingredients"));
        if (nonnulllist.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        if (nonnulllist.size() > 9) {
            throw new JsonParseException("Too many ingredients for shapeless recipe");
        }
        ItemStack itemstack = ShapedRecipe.deserializeItem((JsonObject)JSONUtils.getJsonObject((JsonObject)json, (String)"result"));
        ItemStack spongeStack = ResultUtil.deserializeItemStack(json.getAsJsonObject("sponge:result"));
        Function<CraftingInventory, ItemStack> resultFunction = ResultUtil.deserializeResultFunction(json);
        Function<CraftingInventory, NonNullList<ItemStack>> remainingItemsFunction = ResultUtil.deserializeRemainingItemsFunction(json);
        return new SpongeShapelessRecipe(recipeId, s2, spongeStack == null ? itemstack : spongeStack, nonnulllist, resultFunction, remainingItemsFunction);
    }

    private NonNullList<Ingredient> readIngredients(JsonArray json) {
        NonNullList nonnulllist = NonNullList.create();
        for (JsonElement element : json) {
            Ingredient ingredient = IngredientUtil.spongeDeserialize(element);
            if (ingredient.hasNoMatchingItems()) continue;
            nonnulllist.add((Object)ingredient);
        }
        return nonnulllist;
    }

    public ShapelessRecipe read(ResourceLocation p_199426_1_, PacketBuffer p_199426_2_) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }

    public void write(PacketBuffer p_199427_1_, ShapelessRecipe p_199427_2_) {
        throw new UnsupportedOperationException("custom serializer needs client side support");
    }
}

