/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.scoreboard;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import org.spongepowered.api.scoreboard.CollisionRule;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.Visibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.scoreboard.ScorePlayerTeamBridge;
import org.spongepowered.common.bridge.scoreboard.TeamBridge;

@Mixin(value={ScorePlayerTeam.class})
@Implements(value={@Interface(iface=Team.class, prefix="team$")})
public abstract class ScorePlayerTeamMixin_API
implements Team {
    @Nullable
    @Shadow
    @Final
    @Mutable
    private net.minecraft.scoreboard.Scoreboard scoreboard;
    @Shadow
    @Final
    private String name;
    @Shadow
    @Final
    private Set<String> membershipSet;

    @Shadow
    public abstract void shadow$setAllowFriendlyFire(boolean var1);

    @Shadow
    public abstract void shadow$setSeeFriendlyInvisiblesEnabled(boolean var1);

    @Shadow
    public abstract void shadow$setNameTagVisibility(Team.Visible var1);

    @Shadow
    public abstract void shadow$setDeathMessageVisibility(Team.Visible var1);

    @Shadow
    public abstract void shadow$setCollisionRule(Team.CollisionRule var1);

    @Shadow
    public abstract void shadow$setDisplayName(ITextComponent var1);

    @Shadow
    public abstract boolean shadow$getAllowFriendlyFire();

    @Shadow
    public abstract boolean shadow$getSeeFriendlyInvisiblesEnabled();

    @Shadow
    public abstract Team.Visible shadow$getNameTagVisibility();

    @Shadow
    public abstract Team.Visible shadow$getDeathMessageVisibility();

    @Shadow
    public abstract Team.CollisionRule shadow$getCollisionRule();

    @Shadow
    public abstract Collection<String> shadow$getMembershipCollection();

    @Intrinsic
    public String team$getName() {
        return this.name;
    }

    @Override
    public Component getDisplayName() {
        return ((ScorePlayerTeamBridge)((Object)this)).bridge$getDisplayName();
    }

    @Override
    public void setDisplayName(Component text) {
        ((ScorePlayerTeamBridge)((Object)this)).bridge$setDisplayName(text);
    }

    @Override
    public NamedTextColor getColor() {
        return ((TeamBridge)((Object)this)).bridge$getColor();
    }

    @Override
    public void setColor(NamedTextColor color) {
        ((ScorePlayerTeamBridge)((Object)this)).bridge$setColor(color);
    }

    @Override
    public Component getPrefix() {
        return ((ScorePlayerTeamBridge)((Object)this)).bridge$getPrefix();
    }

    @Override
    public void setPrefix(Component prefix) {
        ((ScorePlayerTeamBridge)((Object)this)).bridge$setPrefix(prefix);
    }

    @Override
    public Component getSuffix() {
        return ((ScorePlayerTeamBridge)((Object)this)).bridge$getSuffix();
    }

    @Shadow
    public abstract void setColor(TextFormatting var1);

    @Override
    public void setSuffix(Component suffix) {
        ((ScorePlayerTeamBridge)((Object)this)).bridge$setSuffix(suffix);
    }

    @Override
    public boolean allowFriendlyFire() {
        return this.shadow$getAllowFriendlyFire();
    }

    @Intrinsic
    public void team$setAllowFriendlyFire(boolean allowFriendlyFire) {
        this.shadow$setAllowFriendlyFire(allowFriendlyFire);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() {
        return this.shadow$getSeeFriendlyInvisiblesEnabled();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) {
        this.shadow$setSeeFriendlyInvisiblesEnabled(enabled);
    }

    @Override
    public Visibility getNameTagVisibility() {
        return (Visibility)this.shadow$getNameTagVisibility();
    }

    @Override
    public void setNameTagVisibility(Visibility visibility) {
        this.shadow$setNameTagVisibility((Team.Visible)visibility);
    }

    @Override
    public Visibility getDeathMessageVisibility() {
        return (Visibility)this.shadow$getDeathMessageVisibility();
    }

    @Override
    public void setDeathMessageVisibility(Visibility visibility) {
        this.shadow$setDeathMessageVisibility((Team.Visible)visibility);
    }

    @Override
    public CollisionRule getCollisionRule() {
        return (CollisionRule)this.shadow$getCollisionRule();
    }

    @Override
    public void setCollisionRule(CollisionRule rule) {
        this.shadow$setCollisionRule((Team.CollisionRule)rule);
    }

    @Override
    public Set<Component> getMembers() {
        return this.shadow$getMembershipCollection().stream().map(SpongeAdventure::legacySection).collect(Collectors.toSet());
    }

    @Override
    public void addMember(Component member) {
        String legacyName = SpongeAdventure.legacySection(member);
        if (legacyName.length() > 40) {
            throw new IllegalArgumentException(String.format("Member is %s characters long! It must be at most 40.", legacyName.length()));
        }
        if (this.scoreboard != null) {
            this.scoreboard.addPlayerToTeam(legacyName, (ScorePlayerTeam)this);
        } else {
            this.membershipSet.add(legacyName);
        }
    }

    @Override
    public boolean removeMember(Component member) {
        String legacyName = SpongeAdventure.legacySection(member);
        if (this.scoreboard != null) {
            ScorePlayerTeam realTeam = this.scoreboard.getPlayersTeam(legacyName);
            if (realTeam == (ScorePlayerTeam)this) {
                this.scoreboard.removePlayerFromTeam(legacyName, realTeam);
                return true;
            }
            return false;
        }
        return this.membershipSet.remove(legacyName);
    }

    @Override
    public Optional<Scoreboard> getScoreboard() {
        return Optional.ofNullable((Scoreboard)this.scoreboard);
    }

    @Override
    public boolean unregister() {
        if (this.scoreboard == null) {
            return false;
        }
        this.scoreboard.removeTeam((ScorePlayerTeam)this);
        this.scoreboard = null;
        return true;
    }
}

