/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.tileentity;

import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.item.Item;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.JukeboxTileEntity;
import org.spongepowered.api.block.entity.Jukebox;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.block.JukeboxBlockAccessor;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.api.mcp.tileentity.TileEntityMixin_API;

@Mixin(value={JukeboxTileEntity.class})
public abstract class JukeboxTileEntityMixin_API
extends TileEntityMixin_API
implements Jukebox {
    @Shadow
    public abstract net.minecraft.item.ItemStack getRecord();

    @Shadow
    public abstract void setRecord(net.minecraft.item.ItemStack var1);

    @Override
    public void play() {
        if (!this.getRecord().isEmpty()) {
            this.world.playEvent(null, 1010, this.shadow$getPos(), Item.getIdFromItem((Item)this.getRecord().getItem()));
        }
    }

    @Override
    public void stop() {
        this.world.playEvent(1010, this.shadow$getPos(), 0);
    }

    @Override
    public void eject() {
        BlockState block = this.world.getBlockState(this.shadow$getPos());
        if (block.getBlock() == Blocks.JUKEBOX) {
            ((JukeboxBlockAccessor)block.getBlock()).accessor$dropRecord(this.world, this.shadow$getPos());
            this.world.setBlockState(this.shadow$getPos(), (BlockState)block.with((IProperty)JukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    @Override
    public void insert(ItemStack record) {
        net.minecraft.item.ItemStack itemStack = ItemStackUtil.toNative(record);
        if (!(itemStack.getItem() instanceof MusicDiscItem)) {
            return;
        }
        BlockState block = this.world.getBlockState(this.shadow$getPos());
        if (block.getBlock() == Blocks.JUKEBOX) {
            this.setRecord(itemStack);
            this.world.setBlockState(this.shadow$getPos(), (BlockState)block.with((IProperty)JukeboxBlock.HAS_RECORD, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.item().asImmutable());
        return values;
    }
}

