/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.tileentity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.LockCode;
import org.spongepowered.api.block.entity.carrier.NameableCarrierBlockEntity;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.LockCodeAccessor;
import org.spongepowered.common.mixin.api.mcp.tileentity.TileEntityMixin_API;
import org.spongepowered.common.util.Constants;

@Mixin(value={LockableTileEntity.class})
public abstract class LockableTileEntityMixin_API
extends TileEntityMixin_API
implements NameableCarrierBlockEntity {
    @Shadow
    @Nullable
    private LockCode code;
    @Nullable
    @Shadow
    private ITextComponent customName;

    @Override
    public DataContainer toContainer() {
        DataContainer container = super.toContainer();
        if (this.code != null) {
            container.set(Constants.TileEntity.LOCK_CODE, ((LockCodeAccessor)this.code).accessor$getLock());
        }
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < ((IInventory)this).getSizeInventory(); ++i) {
            net.minecraft.item.ItemStack stack = ((IInventory)this).getStackInSlot(i);
            if (stack.isEmpty()) continue;
            DataContainer stackView = DataContainer.createNew().set(Queries.CONTENT_VERSION, 1).set(Constants.TileEntity.SLOT, i).set(Constants.TileEntity.SLOT_ITEM, ((ItemStack)stack).toContainer());
            items.add(stackView);
        }
        if (this.customName != null) {
            container.set(Constants.TileEntity.LOCKABLE_CONTAINER_CUSTOM_NAME, this.customName);
        }
        container.set(Constants.TileEntity.ITEM_CONTENTS, items);
        return container;
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.displayName().asImmutable());
        this.lockToken().map(Value::asImmutable).ifPresent(values::add);
        return values;
    }
}

