/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.ProtoWorld;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.biome.BiomeType;
import org.spongepowered.api.world.chunk.ProtoChunk;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.api.world.volume.game.ReadableRegion;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.tileentity.TileEntityAccessor;
import org.spongepowered.common.bridge.world.dimension.DimensionTypeBridge;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.blockentity.ObjectArrayMutableBlockEntityBuffer;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityVolume;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={IWorldReader.class})
@Implements(value={@Interface(iface=ReadableRegion.class, prefix="readable$")})
public interface IWorldReaderMixin_API<R extends ReadableRegion<R>>
extends ReadableRegion<R> {
    @Shadow
    public @Nullable IChunk shadow$getChunk(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    @Shadow
    public boolean shadow$chunkExists(int var1, int var2);

    @Shadow
    public int shadow$getHeight(Heightmap.Type var1, int var2, int var3);

    @Shadow
    public int shadow$getSkylightSubtracted();

    @Shadow
    public int shadow$getSeaLevel();

    @Shadow
    public boolean shadow$hasWater(BlockPos var1);

    @Deprecated
    @Shadow
    public boolean shadow$isAreaLoaded(int var1, int var2, int var3, int var4, int var5, int var6);

    @Shadow
    public Dimension shadow$getDimension();

    @Shadow
    public boolean shadow$containsAnyLiquid(AxisAlignedBB var1);

    @Shadow
    public Biome shadow$getBiome(BlockPos var1);

    @Override
    default public DimensionType getDimensionType() {
        return ((DimensionTypeBridge)this.shadow$getDimension().getType()).bridge$getSpongeDimensionType();
    }

    @Override
    default public WorldBorder getBorder() {
        return (WorldBorder)((ICollisionReader)this).getWorldBorder();
    }

    @Override
    default public boolean isInBorder(Entity entity) {
        return ((ICollisionReader)this).getWorldBorder().contains(((net.minecraft.entity.Entity)entity).getBoundingBox());
    }

    @Override
    default public boolean canSeeSky(int x, int y, int z) {
        return ((ILightReader)this).canSeeSky(new BlockPos(x, y, z));
    }

    @Override
    default public boolean hasLiquid(int x, int y, int z) {
        return this.shadow$hasWater(new BlockPos(x, y, z));
    }

    @Override
    default public boolean containsAnyLiquids(AABB aabb) {
        Vector3d max = aabb.getMax();
        Vector3d min2 = aabb.getMin();
        return this.shadow$containsAnyLiquid(new AxisAlignedBB(min2.getX(), min2.getY(), min2.getZ(), max.getX(), max.getY(), max.getZ()));
    }

    @Override
    default public int getSkylightSubtracted() {
        return this.shadow$getSkylightSubtracted();
    }

    @Intrinsic
    default public int readable$getSeaLevel() {
        return this.shadow$getSeaLevel();
    }

    @Override
    default public boolean isAreaLoaded(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty) {
        return this.shadow$isAreaLoaded(xStart, yStart, zStart, xEnd, yEnd, zEnd);
    }

    @Override
    default public Random getRandom() {
        return new Random();
    }

    @Override
    default public Optional<Entity> getEntity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorldReaderBase that isn't part of Sponge API");
    }

    @Override
    default public Collection<? extends Player> getPlayers() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorldReaderBase that isn't part of Sponge API");
    }

    @Override
    default public <T extends Entity> Collection<? extends T> getEntities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> predicate) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of IWorldReaderBase that isn't part of Sponge API");
    }

    @Override
    default public ProtoChunk<@NonNull ?> getChunk(int x, int y, int z) {
        return (ProtoChunk)this.shadow$getChunk(x >> 4, z >> 4, ChunkStatus.EMPTY, true);
    }

    @Override
    default public boolean isChunkLoaded(int x, int y, int z, boolean allowEmpty) {
        return this.shadow$chunkExists(x >> 4, z >> 4);
    }

    @Override
    default public boolean hasChunk(int x, int y, int z) {
        return this.shadow$chunkExists(x >> 4, z >> 4);
    }

    @Override
    default public boolean hasChunk(Vector3i position) {
        return this.shadow$chunkExists(position.getX() >> 4, position.getZ() >> 4);
    }

    @Override
    default public int getHeight(HeightType type, int x, int z) {
        return this.shadow$getHeight((Heightmap.Type)type, x, z);
    }

    @Override
    default public BiomeType getBiome(int x, int y, int z) {
        return (BiomeType)this.shadow$getBiome(new BlockPos(x, y, z));
    }

    @Override
    default public VolumeStream<R, BiomeType> getBiomeStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, options);
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.min(min2);
        ObjectArrayMutableBiomeBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBiomeBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, (pos, biome) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBiome((BlockPos)pos, (Biome)biome);
            }
        }, VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBiomesForChunkByPos(min2, max), (blockPos, world) -> {
            Biome biome = shouldCarbonCopy ? backingVolume.getNativeBiome(blockPos.getX(), blockPos.getY(), blockPos.getZ()) : ((IWorldReader)world).getBiome(blockPos);
            return new Tuple(blockPos, (Object)biome);
        });
    }

    @Override
    default public VolumeStream<R, BlockState> getBlockStateStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, options);
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.min(min2);
        ArrayMutableBlockBuffer backingVolume = shouldCarbonCopy ? new ArrayMutableBlockBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, (pos, blockState) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBlock((BlockPos)pos, (net.minecraft.block.BlockState)blockState);
            }
        }, VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, biome) -> key, VolumeStreamUtils.getBlockStatesForSections(min2, max), (blockPos, world) -> {
            net.minecraft.block.BlockState tileEntity = shouldCarbonCopy ? backingVolume.getBlock((BlockPos)blockPos) : ((IWorldReader)world).getBlockState(blockPos);
            return new Tuple(blockPos, (Object)tileEntity);
        });
    }

    @Override
    default public VolumeStream<R, BlockEntity> getBlockEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, options);
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.min(min2);
        ObjectArrayMutableBlockEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBlockEntityBuffer(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, shouldCarbonCopy ? (pos, tile) -> {
            CompoundNBT nbt = tile.write(new CompoundNBT());
            @Nullable TileEntity cloned = tile.getType().create();
            Objects.requireNonNull(cloned, () -> String.format("TileEntityType[%s] creates a null TileEntity!", TileEntityType.getId((TileEntityType)tile.getType()))).read(nbt);
            if (this instanceof World) {
                ((TileEntityAccessor)cloned).accessor$setWorld((World)this);
            }
            backingVolume.addBlockEntity(pos.getX(), pos.getY(), pos.getZ(), (BlockEntity)cloned);
        } : (pos, tile) -> {}, VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, tileEntity) -> key, chunk -> chunk instanceof Chunk ? ((Chunk)chunk).getTileEntityMap().entrySet().stream() : Stream.empty(), (blockPos, world) -> {
            @Nullable TileEntity tileEntity = shouldCarbonCopy ? backingVolume.getTileEntity((BlockPos)blockPos) : ((IWorldReader)world).getTileEntity(blockPos);
            return new Tuple(blockPos, (Object)tileEntity);
        });
    }

    @Override
    default public VolumeStream<R, Entity> getEntityStream(Vector3i min2, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(min2, max, options);
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.min(min2);
        ObjectArrayMutableEntityVolume backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityVolume(min2, size) : null;
        return VolumeStreamUtils.generateStream(min2, max, options, this, shouldCarbonCopy ? (pos, entity) -> {
            CompoundNBT nbt = new CompoundNBT();
            entity.writeUnlessPassenger(nbt);
            net.minecraft.entity.Entity cloned = entity.getType().create((World)((IWorldReader)this));
            Objects.requireNonNull(cloned, () -> String.format("EntityType[%s] creates a null Entity!", EntityType.getKey((EntityType)entity.getType()))).read(nbt);
            backingVolume.spawnEntity((Entity)cloned);
        } : (pos, tile) -> {}, VolumeStreamUtils.getChunkAccessorByStatus((IWorldReader)this, options.loadingStyle().generateArea()), (key, entity) -> entity.getUniqueID(), chunk -> chunk instanceof Chunk ? Stream.empty() : Arrays.stream(((Chunk)chunk).getEntityLists()).flatMap(Collection::stream).map(entity -> new AbstractMap.SimpleEntry<BlockPos, net.minecraft.entity.Entity>(entity.getPosition(), (net.minecraft.entity.Entity)entity)), (entityUuid, world) -> {
            net.minecraft.entity.Entity tileEntity = shouldCarbonCopy ? (net.minecraft.entity.Entity)backingVolume.getEntity((UUID)entityUuid).orElse(null) : (net.minecraft.entity.Entity)((ProtoWorld)world).getEntity((UUID)entityUuid).orElse(null);
            return new Tuple((Object)tileEntity.getPosition(), (Object)tileEntity);
        });
    }
}

