/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.server;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.storage.SaveHandler;
import net.minecraft.world.storage.SessionLockException;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.data.DataProvider;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.ChunkRegenerateFlag;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.Weathers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.raid.RaidManagerAccessor;
import org.spongepowered.common.accessor.world.storage.SaveHandlerAccessor;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.data.SpongeDataManager;
import org.spongepowered.common.mixin.api.mcp.world.WorldMixin_API;
import org.spongepowered.common.util.ChunkUtil;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={net.minecraft.world.server.ServerWorld.class})
public abstract class ServerWorldMixin_API
extends WorldMixin_API<ServerWorld>
implements ServerWorld {
    @Shadow
    @Final
    private ServerTickList<Block> pendingBlockTicks;
    @Shadow
    @Final
    private ServerTickList<Fluid> pendingFluidTicks;
    @Shadow
    @Final
    private Int2ObjectMap<net.minecraft.entity.Entity> entitiesById;

    @Shadow
    public abstract void shadow$save(@Nullable IProgressUpdate var1, boolean var2, boolean var3) throws SessionLockException;

    @Shadow
    public abstract boolean shadow$addEntity(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$onChunkUnloading(net.minecraft.world.chunk.Chunk var1);

    @Override
    @Shadow
    public abstract void shadow$playSound(@Nullable PlayerEntity var1, double var2, double var4, double var6, SoundEvent var8, SoundCategory var9, float var10, float var11);

    @Shadow
    public abstract ServerChunkProvider shadow$getChunkProvider();

    @Override
    @Nonnull
    @Shadow
    public abstract MinecraftServer shadow$getServer();

    @Nullable
    @Shadow
    public abstract net.minecraft.entity.Entity shadow$getEntityByUuid(UUID var1);

    @Shadow
    public abstract SaveHandler shadow$getSaveHandler();

    @Shadow
    public abstract List<ServerPlayerEntity> shadow$getPlayers();

    @Shadow
    public abstract RaidManager shadow$getRaids();

    @Nullable
    @Shadow
    public abstract Raid shadow$findRaid(BlockPos var1);

    @Override
    public boolean isLoaded() {
        return ((ServerWorldBridge)((Object)this)).bridge$isLoaded();
    }

    @Override
    public ServerLocation getLocation(Vector3i position) {
        Objects.requireNonNull(position);
        return ServerLocation.of((ServerWorld)this, position);
    }

    @Override
    public ServerLocation getLocation(Vector3d position) {
        Objects.requireNonNull(position);
        return ServerLocation.of((ServerWorld)this, position);
    }

    @Override
    public WorldProperties getProperties() {
        return (WorldProperties)this.shadow$getWorldInfo();
    }

    @Override
    public Server getEngine() {
        return (Server)this.shadow$getServer();
    }

    @Override
    public Optional<Chunk> regenerateChunk(int cx, int cy, int cz, ChunkRegenerateFlag flag) {
        Objects.requireNonNull(flag);
        return ChunkUtil.regenerateChunk(this, cx, cy, cz, flag);
    }

    @Override
    public Path getDirectory() {
        File worldDirectory = this.shadow$getSaveHandler().getWorldDirectory();
        if (worldDirectory == null) {
            new PrettyPrinter(60).add("A Server World has a null save directory!").centre().hr().add("%s : %s", new Object[]{"World Name", ((SaveHandlerAccessor)this.shadow$getSaveHandler()).accessor$getWorldId()}).add("%s : %s", new Object[]{"Dimension", this.getProperties().getDimensionType()}).add("Please report this to sponge developers so they may potentially fix this").trace(System.err, SpongeCommon.getLogger(), Level.ERROR);
            return null;
        }
        return worldDirectory.toPath();
    }

    @Override
    public WorldStorage getWorldStorage() {
        return (WorldStorage)this.shadow$getChunkProvider();
    }

    @Override
    public boolean save() throws IOException {
        try {
            ((ServerWorldBridge)((Object)this)).bridge$setManualSave(true);
            this.shadow$save(null, false, true);
        }
        catch (SessionLockException e) {
            throw new IOException(e);
        }
        return true;
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        Objects.requireNonNull(chunk);
        this.shadow$onChunkUnloading((net.minecraft.world.chunk.Chunk)chunk);
        return true;
    }

    @Override
    public void triggerExplosion(Explosion explosion) {
        Objects.requireNonNull(explosion);
        ((ServerWorldBridge)((Object)this)).bridge$triggerExplosion(explosion);
    }

    @Override
    public Collection<ServerPlayer> getPlayers() {
        return ImmutableList.copyOf(this.shadow$getPlayers());
    }

    public Collection<Entity> getEntities() {
        return Collections.unmodifiableCollection(this.entitiesById.values());
    }

    @Override
    public Collection<org.spongepowered.api.raid.Raid> getRaids() {
        RaidManagerAccessor raidManager = (RaidManagerAccessor)this.shadow$getRaids();
        return raidManager.accessor$getById().values();
    }

    @Override
    public Optional<org.spongepowered.api.raid.Raid> getRaidAt(Vector3i blockPosition) {
        Objects.requireNonNull(blockPosition);
        org.spongepowered.api.raid.Raid raid = (org.spongepowered.api.raid.Raid)this.shadow$findRaid(VecHelper.toBlockPos(blockPosition));
        return Optional.ofNullable(raid);
    }

    @Override
    public Optional<Entity> getEntity(UUID uniqueId) {
        Objects.requireNonNull(uniqueId);
        return Optional.ofNullable((Entity)this.shadow$getEntityByUuid(uniqueId));
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        this.removeTileEntity(new BlockPos(x, y, z));
    }

    @Override
    public ScheduledUpdateList<BlockType> getScheduledBlockUpdates() {
        return (ScheduledUpdateList)this.pendingBlockTicks;
    }

    @Override
    public ScheduledUpdateList<FluidType> getScheduledFluidUpdates() {
        return (ScheduledUpdateList)this.pendingFluidTicks;
    }

    @Override
    public <E> DataTransactionResult offer(int x, int y, int z, Key<? extends Value<E>> key, E value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        DataProvider<Value<E>, E> dataProvider = SpongeDataManager.getProviderRegistry().getProvider(key, ServerLocation.class);
        return dataProvider.offer(ServerLocation.of((ServerWorld)this, new Vector3d((float)x, (float)y, (float)z)), value);
    }

    @Override
    public <E> Optional<E> get(int x, int y, int z, Key<? extends Value<E>> key) {
        Objects.requireNonNull(key);
        DataProvider dataProvider = SpongeDataManager.getProviderRegistry().getProvider(key, ServerLocation.class);
        Optional value = dataProvider.get(ServerLocation.of((ServerWorld)this, new Vector3d((float)x, (float)y, (float)z)));
        if (value.isPresent()) {
            return value;
        }
        return this.getBlock(x, y, z).get(key);
    }

    @Override
    public DataTransactionResult remove(int x, int y, int z, Key<?> key) {
        Objects.requireNonNull(key);
        DataProvider dataProvider = SpongeDataManager.getProviderRegistry().getProvider(key, ServerLocation.class);
        return dataProvider.remove(ServerLocation.of((ServerWorld)this, new Vector3d((float)x, (float)y, (float)z)));
    }

    @Override
    public Weather getWeather() {
        return (Weather)(this.shadow$isThundering() ? Weathers.THUNDER : (this.shadow$isRaining() ? Weathers.RAIN.get() : Weathers.CLEAR.get()));
    }

    @Override
    public Ticks getRemainingWeatherDuration() {
        return new SpongeTicks(((ServerWorldBridge)((Object)this)).bridge$getDurationInTicks());
    }

    @Override
    public Ticks getRunningWeatherDuration() {
        return new SpongeTicks(this.worldInfo.getGameTime() - ((ServerWorldBridge)((Object)this)).bridge$getWeatherStartTime());
    }

    @Override
    public void setWeather(Weather weather) {
        Objects.requireNonNull(weather);
        ((ServerWorldBridge)((Object)this)).bridge$setWeather(weather, (300 + this.rand.nextInt(600)) * 20);
    }

    @Override
    public void setWeather(Weather weather, Ticks ticks) {
        Objects.requireNonNull(weather);
        Objects.requireNonNull(ticks);
        ((ServerWorldBridge)((Object)this)).bridge$setPreviousWeather(this.getWeather());
        ((ServerWorldBridge)((Object)this)).bridge$setWeather(weather, ticks.getTicks());
    }
}

