/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.mcp.world.storage;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.trader.WanderingTrader;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.WorldBorder;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.dimension.DimensionType;
import org.spongepowered.api.world.gamerule.GameRule;
import org.spongepowered.api.world.gen.GeneratorModifierType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.Weathers;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.GameRulesAccessor;
import org.spongepowered.common.accessor.world.GameRules_RuleValueAccessor;
import org.spongepowered.common.bridge.ResourceKeyBridge;
import org.spongepowered.common.bridge.world.storage.WorldInfoBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.SpongeMinecraftDayTime;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.dimension.SpongeDimensionType;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={WorldInfo.class})
@Implements(value={@Interface(iface=WorldProperties.class, prefix="worldproperties$")})
public abstract class WorldInfoMixin_API
implements WorldProperties {
    @Shadow
    private long randomSeed;
    @Shadow
    private @Nullable String legacyCustomOptions;
    @Shadow
    private UUID wanderingTraderId;

    @Shadow
    public abstract int shadow$getSpawnX();

    @Shadow
    public abstract int shadow$getSpawnY();

    @Shadow
    public abstract int shadow$getSpawnZ();

    @Shadow
    public abstract void shadow$setSpawn(BlockPos var1);

    @Shadow
    public abstract WorldType shadow$getGenerator();

    @Shadow
    public abstract void shadow$setGenerator(WorldType var1);

    @Shadow
    public abstract long shadow$getSeed();

    @Shadow
    public abstract long shadow$getGameTime();

    @Shadow
    public abstract long shadow$getDayTime();

    @Shadow
    public abstract void shadow$setDayTime(long var1);

    @Shadow
    public abstract GameType shadow$getGameType();

    @Shadow
    public abstract void shadow$setGameType(GameType var1);

    @Shadow
    public abstract boolean shadow$isMapFeaturesEnabled();

    @Shadow
    public abstract void shadow$setMapFeaturesEnabled(boolean var1);

    @Shadow
    public abstract boolean shadow$isHardcore();

    @Shadow
    public abstract void shadow$setHardcore(boolean var1);

    @Shadow
    public abstract boolean shadow$areCommandsAllowed();

    @Shadow
    public abstract void shadow$setAllowCommands(boolean var1);

    @Shadow
    public abstract boolean shadow$isInitialized();

    @Shadow
    public abstract net.minecraft.world.Difficulty shadow$getDifficulty();

    @Shadow
    public abstract void shadow$setDifficulty(net.minecraft.world.Difficulty var1);

    @Shadow
    public abstract CompoundNBT shadow$getGeneratorOptions();

    @Shadow
    public abstract void shadow$setGeneratorOptions(CompoundNBT var1);

    @Shadow
    public abstract GameRules shadow$getGameRulesInstance();

    @Shadow
    public abstract int shadow$getWanderingTraderSpawnChance();

    @Shadow
    public abstract void shadow$setWanderingTraderSpawnChance(int var1);

    @Shadow
    public abstract int shadow$getWanderingTraderSpawnDelay();

    @Shadow
    public abstract void shadow$setWanderingTraderSpawnDelay(int var1);

    @Shadow
    public abstract void shadow$setWanderingTraderId(UUID var1);

    @Shadow
    public abstract boolean shadow$isRaining();

    @Shadow
    public abstract void shadow$setRaining(boolean var1);

    @Shadow
    public abstract int shadow$getRainTime();

    @Shadow
    public abstract void shadow$setRainTime(int var1);

    @Shadow
    public abstract boolean shadow$isThundering();

    @Shadow
    public abstract void shadow$setThundering(boolean var1);

    @Shadow
    public abstract int shadow$getThunderTime();

    @Shadow
    public abstract void shadow$setThunderTime(int var1);

    @Shadow
    public abstract void shadow$setClearWeatherTime(int var1);

    @Shadow
    public abstract int shadow$getClearWeatherTime();

    @Override
    public ResourceKey getKey() {
        return ((ResourceKeyBridge)((Object)this)).bridge$getKey();
    }

    @Override
    public Optional<ServerWorld> getWorld() {
        return Optional.ofNullable((ServerWorld)((WorldInfoBridge)((Object)this)).bridge$getWorld());
    }

    @Override
    public Vector3i getSpawnPosition() {
        return new Vector3i(this.shadow$getSpawnX(), this.shadow$getSpawnY(), this.shadow$getSpawnZ());
    }

    @Override
    public void setSpawnPosition(Vector3i position) {
        Objects.requireNonNull(position);
        this.shadow$setSpawn(VecHelper.toBlockPos(position));
    }

    @Override
    public GeneratorModifierType getGeneratorModifierType() {
        return (GeneratorModifierType)this.shadow$getGenerator();
    }

    @Override
    public void setGeneratorModifierType(GeneratorModifierType modifier) {
        Objects.requireNonNull(modifier);
        this.shadow$setGenerator((WorldType)modifier);
    }

    @Intrinsic
    public long worldproperties$getSeed() {
        return this.shadow$getSeed();
    }

    @Override
    public void setSeed(long seed) {
        this.randomSeed = seed;
    }

    @Override
    public MinecraftDayTime getGameTime() {
        return new SpongeMinecraftDayTime(this.shadow$getGameTime());
    }

    @Override
    public MinecraftDayTime getDayTime() {
        return new SpongeMinecraftDayTime(this.shadow$getDayTime());
    }

    @Override
    public void setDayTime(MinecraftDayTime dayTime) {
        this.shadow$setDayTime(dayTime.asTicks().getTicks());
    }

    @Override
    public DimensionType getDimensionType() {
        return ((WorldInfoBridge)((Object)this)).bridge$getLogicType();
    }

    @Override
    public void setDimensionType(DimensionType dimensionType) {
        ((WorldInfoBridge)((Object)this)).bridge$setLogicType((SpongeDimensionType)dimensionType, true);
    }

    @Override
    public GameMode getGameMode() {
        return (GameMode)this.shadow$getGameType();
    }

    @Override
    public void setGameMode(GameMode gamemode) {
        this.shadow$setGameType((GameType)gamemode);
    }

    @Override
    public boolean areStructuresEnabled() {
        return this.shadow$isMapFeaturesEnabled();
    }

    @Override
    public void setStructuresEnabled(boolean state) {
        this.shadow$setMapFeaturesEnabled(state);
    }

    @Intrinsic
    public boolean worldproperties$isHardcore() {
        return this.shadow$isHardcore();
    }

    @Intrinsic
    public void worldproperties$setHardcore(boolean state) {
        this.shadow$setHardcore(state);
    }

    @Override
    public boolean areCommandsEnabled() {
        return this.shadow$areCommandsAllowed();
    }

    @Override
    public void setCommandsEnabled(boolean state) {
        this.shadow$setAllowCommands(state);
    }

    @Intrinsic
    public boolean worldproperties$isInitialized() {
        return this.shadow$isInitialized();
    }

    @Override
    public Difficulty getDifficulty() {
        return (Difficulty)this.shadow$getDifficulty();
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.shadow$setDifficulty((net.minecraft.world.Difficulty)difficulty);
    }

    @Override
    public boolean isPVPEnabled() {
        return ((WorldInfoBridge)((Object)this)).bridge$isPVPEnabled();
    }

    @Override
    public void setPVPEnabled(boolean state) {
        ((WorldInfoBridge)((Object)this)).bridge$setPVPEnabled(state);
    }

    @Override
    public boolean doesGenerateBonusChest() {
        return ((WorldInfoBridge)((Object)this)).bridge$doesGenerateBonusChest();
    }

    @Override
    public void setGenerateBonusChest(boolean state) {
        ((WorldInfoBridge)((Object)this)).bridge$setGenerateBonusChest(state);
    }

    @Override
    public UUID getUniqueId() {
        return ((WorldInfoBridge)((Object)this)).bridge$getUniqueId();
    }

    @Override
    public boolean isEnabled() {
        return ((WorldInfoBridge)((Object)this)).bridge$isEnabled();
    }

    @Override
    public void setEnabled(boolean state) {
        ((WorldInfoBridge)((Object)this)).bridge$setEnabled(state);
    }

    @Override
    public boolean doesLoadOnStartup() {
        return ((WorldInfoBridge)((Object)this)).bridge$doesLoadOnStartup();
    }

    @Override
    public void setLoadOnStartup(boolean state) {
        ((WorldInfoBridge)((Object)this)).bridge$setLoadOnStartup(state);
    }

    @Override
    public boolean doesKeepSpawnLoaded() {
        return ((WorldInfoBridge)((Object)this)).bridge$doesKeepSpawnLoaded();
    }

    @Override
    public void setKeepSpawnLoaded(boolean state) {
        ((WorldInfoBridge)((Object)this)).bridge$setKeepSpawnLoaded(state);
    }

    @Override
    public boolean doesGenerateSpawnOnLoad() {
        return ((WorldInfoBridge)((Object)this)).bridge$doesGenerateSpawnOnLoad();
    }

    @Override
    public void setGenerateSpawnOnLoad(boolean state) {
        ((WorldInfoBridge)((Object)this)).bridge$setGenerateSpawnOnLoad(state);
    }

    @Override
    public DataContainer getGeneratorSettings() {
        if (this.legacyCustomOptions != null) {
            try {
                return DataContainer.createNew().set(Constants.Sponge.World.WORLD_CUSTOM_SETTINGS, DataFormats.JSON.get().read(this.legacyCustomOptions));
            }
            catch (JsonParseException | IOException ignored) {
                return DataContainer.createNew();
            }
        }
        return DataContainer.createNew().set(Constants.Sponge.World.WORLD_CUSTOM_SETTINGS, NbtTranslator.getInstance().translateFrom(this.shadow$getGeneratorOptions()));
    }

    @Override
    public void setGeneratorSettings(DataContainer generatorSettings) {
        this.shadow$setGeneratorOptions(NbtTranslator.getInstance().translate(generatorSettings));
    }

    @Override
    public SerializationBehavior getSerializationBehavior() {
        return ((WorldInfoBridge)((Object)this)).bridge$getSerializationBehavior();
    }

    @Override
    public void setSerializationBehavior(SerializationBehavior behavior) {
        ((WorldInfoBridge)((Object)this)).bridge$setSerializationBehavior(Objects.requireNonNull(behavior));
    }

    @Intrinsic
    public int worldproperties$getWanderingTraderSpawnDelay() {
        return this.shadow$getWanderingTraderSpawnDelay();
    }

    @Intrinsic
    public void worldproperties$setWanderingTraderSpawnDelay(int delay) {
        this.shadow$setWanderingTraderSpawnDelay(delay);
    }

    @Intrinsic
    public int worldproperties$getWanderingTraderSpawnChance() {
        return this.shadow$getWanderingTraderSpawnChance();
    }

    @Intrinsic
    public void worldproperties$setWanderingTraderSpawnChance(int chance) {
        this.shadow$setWanderingTraderSpawnChance(chance);
    }

    @Override
    public Optional<UUID> getWanderTraderUniqueId() {
        return Optional.ofNullable(this.wanderingTraderId);
    }

    @Override
    public void setWanderingTrader(@Nullable WanderingTrader trader) {
        this.shadow$setWanderingTraderId(trader == null ? null : trader.getUniqueId());
    }

    @Override
    public Weather getWeather() {
        if (this.shadow$isRaining()) {
            return Weathers.RAIN.get();
        }
        if (this.shadow$isThundering()) {
            return Weathers.THUNDER.get();
        }
        return Weathers.CLEAR.get();
    }

    @Override
    public Ticks getRemainingWeatherDuration() {
        if (this.shadow$isRaining()) {
            return new SpongeTicks(this.shadow$getRainTime());
        }
        if (this.shadow$isThundering()) {
            return new SpongeTicks(this.shadow$getThunderTime());
        }
        return new SpongeTicks(this.shadow$getClearWeatherTime());
    }

    @Override
    public Ticks getRunningWeatherDuration() {
        if (this.shadow$isRaining()) {
            return new SpongeTicks(6000 - this.shadow$getRainTime());
        }
        if (this.shadow$isThundering()) {
            return new SpongeTicks(6000 - this.shadow$getThunderTime());
        }
        return new SpongeTicks(6000 - this.shadow$getClearWeatherTime());
    }

    @Override
    public void setWeather(Weather weather) {
        this.setWeather(weather, new SpongeTicks(120L));
    }

    @Override
    public void setWeather(Weather weather, Ticks ticks) {
        if (weather == Weathers.CLEAR.get()) {
            this.shadow$setClearWeatherTime((int)ticks.getTicks());
            this.shadow$setRaining(false);
            this.shadow$setRainTime(0);
            this.shadow$setThundering(false);
            this.shadow$setThunderTime(0);
        } else if (weather == Weathers.RAIN.get()) {
            this.shadow$setRaining(true);
            this.shadow$setRainTime((int)ticks.getTicks());
            this.shadow$setThundering(false);
            this.shadow$setThunderTime(0);
            this.shadow$setClearWeatherTime(0);
        } else if (weather == Weathers.THUNDER.get()) {
            this.shadow$setRaining(true);
            this.shadow$setRainTime((int)ticks.getTicks());
            this.shadow$setThundering(true);
            this.shadow$setThunderTime((int)ticks.getTicks());
            this.shadow$setClearWeatherTime(0);
        }
    }

    @Override
    public <V> V getGameRule(GameRule<V> gameRule) {
        GameRules.RuleValue value = this.shadow$getGameRulesInstance().get((GameRules.RuleKey)gameRule);
        if (value instanceof GameRules.BooleanValue) {
            return (V)Boolean.valueOf(((GameRules.BooleanValue)value).get());
        }
        if (value instanceof GameRules.IntegerValue) {
            return (V)Integer.valueOf(((GameRules.IntegerValue)value).get());
        }
        return null;
    }

    @Override
    public <V> void setGameRule(GameRule<V> gameRule, V value) {
        GameRules.RuleValue mValue = this.shadow$getGameRulesInstance().get((GameRules.RuleKey)gameRule);
        ((GameRules_RuleValueAccessor)mValue).accessor$setStringValue(value.toString());
    }

    @Override
    public Map<GameRule<?>, ?> getGameRules() {
        Map<GameRules.RuleKey<?>, GameRules.RuleValue<?>> rules = ((GameRulesAccessor)this.shadow$getGameRulesInstance()).accessor$getRules();
        HashMap<GameRule, Boolean> apiRules = new HashMap<GameRule, Boolean>();
        for (Map.Entry<GameRules.RuleKey<?>, GameRules.RuleValue<?>> rule : rules.entrySet()) {
            GameRule key = (GameRule)rule.getKey();
            GameRules.RuleValue<?> mValue = rule.getValue();
            Comparable<Boolean> value = null;
            if (mValue instanceof GameRules.BooleanValue) {
                value = ((GameRules.BooleanValue)mValue).get();
            } else if (mValue instanceof GameRules.IntegerValue) {
                value = ((GameRules.IntegerValue)mValue).get();
            }
            if (value == null) continue;
            apiRules.put(key, (Boolean)value);
        }
        return apiRules;
    }

    @Override
    public WorldBorder getWorldBorder() {
        net.minecraft.world.border.WorldBorder mcBorder = new net.minecraft.world.border.WorldBorder();
        mcBorder.copyFrom((WorldInfo)this);
        return (WorldBorder)mcBorder;
    }
}

