/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.FireBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.bridge.world.ServerWorldBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.block.BlockMixin;

@Mixin(value={FireBlock.class})
public abstract class FireBlockMixin
extends BlockMixin {
    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/server/ServerWorld;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z", ordinal=1))
    private boolean impl$onFireSpread(net.minecraft.world.server.ServerWorld world, BlockPos pos, BlockState newState, int flags) {
        if (!((WorldBridge)world).bridge$isFake() && ShouldFire.CHANGE_BLOCK_EVENT_PRE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.FIRE_SPREAD, (ServerWorld)world);
                if (SpongeCommonEventFactory.callChangeBlockEventPre((ServerWorldBridge)world, pos).isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        return world.setBlockState(pos, newState, flags);
    }

    @Inject(method={"catchOnFire"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setBlockState(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;I)Z")}, require=0, expect=0, cancellable=true)
    private void impl$onCatchFirePreCheck(World world, BlockPos pos, int chance, Random random, int age, CallbackInfo callbackInfo) {
        if (!world.isRemote && SpongeCommonEventFactory.callChangeBlockEventPre((ServerWorldBridge)world, pos).isCancelled()) {
            callbackInfo.cancel();
        }
    }

    @Inject(method={"catchOnFire"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;removeBlock(Lnet/minecraft/util/math/BlockPos;Z)Z")}, require=0, expect=0, cancellable=true)
    private void impl$onCatchFirePreCheckOther(World world, BlockPos pos, int chance, Random random, int age, CallbackInfo callbackInfo) {
        if (!world.isRemote && SpongeCommonEventFactory.callChangeBlockEventPre((ServerWorldBridge)world, pos).isCancelled()) {
            callbackInfo.cancel();
        }
    }
}

