/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.command.impl.AdvancementCommand;
import net.minecraft.entity.player.ServerPlayerEntity;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.command.brigadier.dispatcher.DelegatingCommandDispatcher;
import org.spongepowered.common.command.brigadier.dispatcher.SpongeNodePermissionCache;
import org.spongepowered.common.command.brigadier.tree.SpongeArgumentCommandNode;
import org.spongepowered.common.command.brigadier.tree.SpongeNode;
import org.spongepowered.common.command.brigadier.tree.SuggestionArgumentNode;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.launch.Launch;

@Mixin(value={Commands.class})
public abstract class CommandsMixin {
    private CauseStackManager.StackFrame impl$initFrame = null;
    private final WeakHashMap<ServerPlayerEntity, Map<CommandNode<CommandSource>, List<CommandNode<ISuggestionProvider>>>> impl$playerNodeCache = new WeakHashMap();

    @Shadow
    public abstract CommandDispatcher<CommandSource> shadow$getDispatcher();

    @Shadow
    private void shadow$commandSourceNodesToSuggestionNodes(CommandNode<CommandSource> rootCommandSource, CommandNode<ISuggestionProvider> rootSuggestion, CommandSource source, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> commandNodeToSuggestionNode) {
        throw new AssertionError((Object)"This shouldn't be callable");
    }

    @Redirect(method={"<init>"}, at=@At(value="NEW", args={"class=com/mojang/brigadier/CommandDispatcher"}, remap=false))
    private CommandDispatcher<CommandSource> impl$useSpongeDispatcher() {
        return new DelegatingCommandDispatcher();
    }

    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/command/impl/AdvancementCommand;register(Lcom/mojang/brigadier/CommandDispatcher;)V"))
    private void impl$setupStackFrameOnInit(CommandDispatcher<CommandSource> dispatcher) {
        ((SpongeCommandManager)SpongeCommon.getGame().getCommandManager()).reset();
        this.impl$initFrame = PhaseTracker.getCauseStackManager().pushCauseFrame();
        this.impl$initFrame.pushCause(((Launch)Launch.getInstance()).getMinecraftPlugin());
        AdvancementCommand.register(dispatcher);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void impl$tellDispatcherCommandsAreRegistered(CallbackInfo ci) {
        this.impl$initFrame.popCause();
        PhaseTracker.getCauseStackManager().popCauseFrame(this.impl$initFrame);
        this.impl$initFrame = null;
    }

    @Redirect(method={"commandSourceNodesToSuggestionNodes"}, slice=@Slice(from=@At(value="HEAD"), to=@At(value="INVOKE", target="Ljava/util/Iterator;hasNext()Z")), at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;getChildren()Ljava/util/Collection;", remap=false))
    private Collection<CommandNode<CommandSource>> impl$handleHiddenChildrenAndEnsureUnsortedLoop(CommandNode<CommandSource> commandNode) {
        return this.impl$getChildrenFromNode(commandNode);
    }

    @Redirect(method={"commandSourceNodesToSuggestionNodes"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;createBuilder()Lcom/mojang/brigadier/builder/ArgumentBuilder;", remap=false))
    private ArgumentBuilder<?, ?> impl$createArgumentBuilder(CommandNode<CommandSource> commandNode, CommandNode<CommandSource> rootCommandSource, CommandNode<ISuggestionProvider> rootSuggestion, CommandSource source, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> commandNodeToSuggestionNode) {
        if (commandNode instanceof SpongeArgumentCommandNode) {
            return ((SpongeArgumentCommandNode)commandNode).createBuilderForSuggestions(rootSuggestion, commandNodeToSuggestionNode);
        }
        return commandNode.createBuilder();
    }

    @Redirect(method={"commandSourceNodesToSuggestionNodes"}, at=@At(value="INVOKE", target="Ljava/util/Map;put(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", remap=false))
    private <K, V> V impl$preventPutIntoMapIfNodeIsComplex(Map<K, V> map, K key, V value, CommandNode<CommandSource> rootCommandSource, CommandNode<ISuggestionProvider> rootSuggestion, CommandSource source, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> commandNodeToSuggestionNode) {
        if (!map.containsKey(key)) {
            ServerPlayerEntity e = (ServerPlayerEntity)source.getEntity();
            Map<CommandNode<CommandSource>, List<CommandNode<ISuggestionProvider>>> playerNodes = this.impl$playerNodeCache.get(e);
            if (!playerNodes.containsKey(key)) {
                ArrayList<CommandNode> children = new ArrayList<CommandNode>();
                children.add((CommandNode)value);
                playerNodes.put((CommandNode<CommandSource>)((CommandNode)key), children);
            }
            if (value instanceof ArgumentCommandNode && this.impl$alreadyHasCustomSuggestionsOnNode(rootSuggestion)) {
                rootSuggestion.addChild(this.impl$cloneArgumentCommandNodeWithoutSuggestions((ArgumentCommandNode)value));
            } else {
                rootSuggestion.addChild((CommandNode)value);
            }
            return map.put(key, value);
        }
        return null;
    }

    @Redirect(method={"commandSourceNodesToSuggestionNodes"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;addChild(Lcom/mojang/brigadier/tree/CommandNode;)V", remap=false))
    private void impl$preventAddChild(CommandNode<ISuggestionProvider> root, CommandNode<ISuggestionProvider> newChild) {
    }

    @Redirect(method={"commandSourceNodesToSuggestionNodes"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/tree/CommandNode;canUse(Ljava/lang/Object;)Z", remap=false))
    private boolean impl$testPermissionAndPreventRecalculationWhenSendingNodes(CommandNode<CommandSource> commandNode, Object source, CommandNode<CommandSource> rootCommandNode, CommandNode<ISuggestionProvider> rootSuggestion, CommandSource sourceButTyped, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> commandNodeToSuggestionNode) {
        if (SpongeNodePermissionCache.canUse(rootCommandNode instanceof RootCommandNode, this.shadow$getDispatcher(), commandNode, sourceButTyped)) {
            List<CommandNode<ISuggestionProvider>> suggestionProviderCommandNode;
            ServerPlayerEntity e;
            boolean shouldContinue = true;
            if (commandNode instanceof SpongeArgumentCommandNode && ((SpongeArgumentCommandNode)commandNode).isComplex()) {
                shouldContinue = false;
                e = (ServerPlayerEntity)sourceButTyped.getEntity();
                boolean hasCustomSuggestionsAlready = this.impl$alreadyHasCustomSuggestionsOnNode(rootSuggestion);
                CommandNode<ISuggestionProvider> finalCommandNode = ((SpongeArgumentCommandNode)commandNode).getComplexSuggestions(rootSuggestion, commandNodeToSuggestionNode, this.impl$playerNodeCache.get(e), !hasCustomSuggestionsAlready);
                if (!this.impl$getChildrenFromNode(commandNode).isEmpty()) {
                    this.shadow$commandSourceNodesToSuggestionNodes(commandNode, finalCommandNode, sourceButTyped, commandNodeToSuggestionNode);
                }
            }
            if (shouldContinue && (suggestionProviderCommandNode = this.impl$playerNodeCache.get(e = (ServerPlayerEntity)sourceButTyped.getEntity()).get(commandNode)) != null) {
                shouldContinue = false;
                boolean hasCustomSuggestionsAlready = this.impl$alreadyHasCustomSuggestionsOnNode(rootSuggestion);
                for (CommandNode<ISuggestionProvider> node : suggestionProviderCommandNode) {
                    if (hasCustomSuggestionsAlready && node instanceof ArgumentCommandNode) {
                        ArgumentCommandNode argNode = (ArgumentCommandNode)node;
                        if (argNode.getCustomSuggestions() != null) {
                            rootSuggestion.addChild(this.impl$cloneArgumentCommandNodeWithoutSuggestions(argNode));
                            continue;
                        }
                    } else if (node instanceof ArgumentCommandNode && ((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                        hasCustomSuggestionsAlready = true;
                    }
                    rootSuggestion.addChild(node);
                }
            }
            return shouldContinue;
        }
        return false;
    }

    @Redirect(method={"commandSourceNodesToSuggestionNodes"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;suggests(Lcom/mojang/brigadier/suggestion/SuggestionProvider;)Lcom/mojang/brigadier/builder/RequiredArgumentBuilder;"), remap=false)
    private RequiredArgumentBuilder<ISuggestionProvider, ?> impl$dontAskServerIfSiblingAlreadyDoes(RequiredArgumentBuilder<ISuggestionProvider, ?> requiredArgumentBuilder, SuggestionProvider<ISuggestionProvider> provider, CommandNode<CommandSource> rootCommandNode, CommandNode<ISuggestionProvider> rootSuggestion, CommandSource sourceButTyped, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> commandNodeToSuggestionNode) {
        if (provider != SuggestionProviders.ASK_SERVER || !this.impl$alreadyHasCustomSuggestionsOnNode(rootSuggestion)) {
            requiredArgumentBuilder.suggests(provider);
        }
        return requiredArgumentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"send"}, at=@At(value="INVOKE", target="Lnet/minecraft/command/Commands;commandSourceNodesToSuggestionNodes(Lcom/mojang/brigadier/tree/CommandNode;Lcom/mojang/brigadier/tree/CommandNode;Lnet/minecraft/command/CommandSource;Ljava/util/Map;)V"))
    private void impl$addNonBrigSuggestions(Commands commands, CommandNode<CommandSource> p_197052_1_, CommandNode<ISuggestionProvider> p_197052_2_, CommandSource p_197052_3_, Map<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> p_197052_4_, ServerPlayerEntity playerEntity) {
        try {
            this.impl$playerNodeCache.put(playerEntity, new IdentityHashMap());
            IdentityHashMap<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>> idMap = new IdentityHashMap<CommandNode<CommandSource>, CommandNode<ISuggestionProvider>>(p_197052_4_);
            this.shadow$commandSourceNodesToSuggestionNodes(p_197052_1_, p_197052_2_, p_197052_3_, idMap);
        }
        finally {
            this.impl$playerNodeCache.remove(playerEntity);
        }
        for (CommandNode<ISuggestionProvider> node : ((SpongeCommandManager)Sponge.getGame().getCommandManager()).getNonBrigadierSuggestions((CommandCause)p_197052_3_)) {
            p_197052_2_.addChild(node);
        }
    }

    @Redirect(method={"commandSourceNodesToSuggestionNodes"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/builder/ArgumentBuilder;build()Lcom/mojang/brigadier/tree/CommandNode;", remap=false))
    private CommandNode<ISuggestionProvider> impl$createSpongeArgumentNode(ArgumentBuilder<ISuggestionProvider, ?> argumentBuilder) {
        if (argumentBuilder instanceof RequiredArgumentBuilder) {
            return new SuggestionArgumentNode((RequiredArgumentBuilder)argumentBuilder);
        }
        return argumentBuilder.build();
    }

    private Collection<CommandNode<CommandSource>> impl$getChildrenFromNode(CommandNode<CommandSource> parentNode) {
        if (parentNode instanceof SpongeNode) {
            return ((SpongeNode)parentNode).getChildrenForSuggestions();
        }
        return parentNode.getChildren();
    }

    private ArgumentCommandNode<ISuggestionProvider, ?> impl$cloneArgumentCommandNodeWithoutSuggestions(ArgumentCommandNode<ISuggestionProvider, ?> toClone) {
        RequiredArgumentBuilder builder = toClone.createBuilder();
        builder.suggests(null);
        for (CommandNode node : toClone.getChildren()) {
            builder.then(node);
        }
        return new SuggestionArgumentNode(builder);
    }

    private boolean impl$alreadyHasCustomSuggestionsOnNode(CommandNode<ISuggestionProvider> rootSuggestion) {
        return rootSuggestion.getChildren().stream().filter(x -> x instanceof ArgumentCommandNode).anyMatch(x -> ((ArgumentCommandNode)x).getCustomSuggestions() != null);
    }
}

