/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.command.impl;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.impl.TeleportCommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.TicketType;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={TeleportCommand.class})
public abstract class TeleportCommandMixin {
    @Overwrite
    private static void teleport(CommandSource source, Entity entityIn, net.minecraft.world.server.ServerWorld worldIn, double x, double y, double z, Set<SPlayerPositionLookPacket.Flags> relativeList, float yaw, float pitch, @Nullable TeleportCommand.Facing facing) {
        double actualYaw = yaw;
        double actualPitch = pitch;
        if (!(entityIn instanceof ServerPlayerEntity)) {
            actualYaw = MathHelper.wrapDegrees((float)yaw);
            actualPitch = MathHelper.wrapDegrees((float)pitch);
            actualPitch = MathHelper.clamp((double)actualPitch, (double)-90.0, (double)90.0);
        }
        if (worldIn == entityIn.world) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
                MoveEntityEvent posEvent = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entityIn, VecHelper.toVector3d(entityIn.getPositionVector()), new Vector3d(x, y, z), new Vector3d(x, y, z));
                RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entityIn, new Vector3d(actualPitch, actualYaw, 0.0), new Vector3d(pitch, yaw, 0.0f));
                if (SpongeCommon.postEvent(posEvent)) {
                    return;
                }
                SpongeCommon.postEvent(rotateEvent);
                double actualX = posEvent.getDestinationPosition().getX();
                double actualY = posEvent.getDestinationPosition().getY();
                double actualZ = posEvent.getDestinationPosition().getZ();
                actualYaw = rotateEvent.isCancelled() ? (double)entityIn.rotationYaw : rotateEvent.getToRotation().getY();
                double d = actualPitch = rotateEvent.isCancelled() ? (double)entityIn.rotationPitch : rotateEvent.getToRotation().getX();
                if (entityIn instanceof ServerPlayerEntity) {
                    ChunkPos chunkpos = new ChunkPos(new BlockPos(actualX, actualY, actualZ));
                    worldIn.getChunkProvider().registerTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)entityIn.getEntityId());
                    entityIn.stopRiding();
                    if (((ServerPlayerEntity)entityIn).isSleeping()) {
                        ((ServerPlayerEntity)entityIn).stopSleepInBed(true, true);
                    }
                    ((ServerPlayerEntity)entityIn).connection.setPlayerLocation(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch, relativeList);
                } else {
                    entityIn.setLocationAndAngles(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch);
                }
                entityIn.setRotationYawHead((float)actualYaw);
            }
        }
        if (entityIn instanceof ServerPlayerEntity) {
            PhaseTracker.getCauseStackManager().addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
            ((ServerPlayerEntity)entityIn).teleport(worldIn, x, y, z, yaw, pitch);
            PhaseTracker.getCauseStackManager().removeContext(EventContextKeys.MOVEMENT_TYPE);
        } else {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.COMMAND);
                net.minecraft.world.server.ServerWorld fromWorld = (net.minecraft.world.server.ServerWorld)entityIn.getEntityWorld();
                ChangeEntityWorldEvent.Pre preEvent = PlatformHooks.getInstance().getEventHooks().callChangeEntityWorldEventPre(entityIn, worldIn);
                if (SpongeCommon.postEvent(preEvent)) {
                    return;
                }
                ChangeEntityWorldEvent.Reposition posEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entityIn, (ServerWorld)entityIn.getEntityWorld(), VecHelper.toVector3d(entityIn.getPositionVector()), new Vector3d(x, y, z), preEvent.getOriginalDestinationWorld(), new Vector3d(x, y, z), preEvent.getDestinationWorld());
                if (SpongeCommon.postEvent(posEvent)) {
                    return;
                }
                entityIn.detach();
                entityIn.dimension = ((net.minecraft.world.server.ServerWorld)preEvent.getDestinationWorld()).dimension.getType();
                Entity result = entityIn.getType().create((World)worldIn);
                if (result == null) {
                    return;
                }
                RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (org.spongepowered.api.entity.Entity)entityIn, new Vector3d(entityIn.rotationPitch, entityIn.rotationYaw, 0.0f), new Vector3d(actualPitch, actualYaw, 0.0));
                if (!SpongeCommon.postEvent(rotateEvent)) {
                    actualYaw = MathHelper.wrapDegrees((double)rotateEvent.getToRotation().getY());
                    actualPitch = MathHelper.wrapDegrees((double)rotateEvent.getToRotation().getX());
                    actualPitch = MathHelper.clamp((double)actualPitch, (double)-90.0, (double)90.0);
                } else {
                    actualYaw = entityIn.rotationYaw;
                    actualPitch = entityIn.rotationPitch;
                }
                result.copyDataFromOld(entityIn);
                result.setLocationAndAngles(posEvent.getDestinationPosition().getX(), posEvent.getDestinationPosition().getY(), posEvent.getDestinationPosition().getZ(), (float)actualYaw, (float)actualPitch);
                result.setRotationYawHead((float)actualYaw);
                worldIn.addFromAnotherDimension(result);
                entityIn.removed = true;
                PlatformHooks.getInstance().getEventHooks().callChangeEntityWorldEventPost(result, fromWorld, (net.minecraft.world.server.ServerWorld)preEvent.getOriginalDestinationWorld());
            }
        }
        if (facing != null) {
            facing.updateLook(source, entityIn);
        }
        if (!(entityIn instanceof LivingEntity) || !((LivingEntity)entityIn).isElytraFlying()) {
            entityIn.setMotion(entityIn.getMotion().mul(1.0, 0.0, 1.0));
            entityIn.onGround = true;
        }
    }
}

