/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.CombatTracker;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.cause.entity.damage.DamageFunction;
import org.spongepowered.api.event.cause.entity.damage.source.FallingBlockDamageSource;
import org.spongepowered.api.event.entity.DamageEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.entity.EntityTypeBridge;
import org.spongepowered.common.bridge.entity.LivingEntityBridge;
import org.spongepowered.common.bridge.entity.PlatformLivingEntityBridge;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.cause.entity.damage.DamageEventHandler;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.common.registry.builtin.sponge.DamageTypeStreamGenerator;
import org.spongepowered.common.util.PrettyPrinter;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends EntityMixin
implements LivingEntityBridge,
PlatformLivingEntityBridge {
    @Shadow
    public int hurtTime;
    @Shadow
    public int maxHurtTime;
    @Shadow
    public float attackedAtYaw;
    @Shadow
    public float limbSwingAmount;
    @Shadow
    protected int idleTime;
    @Shadow
    protected int recentlyHit;
    @Shadow
    protected int activeItemStackUseCount;
    @Shadow
    protected float lastDamage;
    @Shadow
    @Nullable
    protected PlayerEntity attackingPlayer;
    @Shadow
    private DamageSource lastDamageSource;
    @Shadow
    private long lastDamageStamp;
    @Shadow
    protected boolean dead;
    @Shadow
    public int deathTime;
    @Shadow
    protected int scoreValue;
    @Nullable
    private ItemStack impl$activeItemStackCopy;
    @Nullable
    private Vector3d impl$preTeleportPosition;
    private int impl$deathEventsPosted;
    private int impl$maxAir = this.shadow$getMaxAir();

    @Shadow
    public abstract IAttributeInstance shadow$getAttribute(IAttribute var1);

    @Shadow
    public abstract void shadow$setHealth(float var1);

    @Shadow
    public abstract void shadow$knockBack(net.minecraft.entity.Entity var1, float var2, double var3, double var5);

    @Shadow
    public abstract void shadow$setRevengeTarget(LivingEntity var1);

    @Shadow
    public abstract void shadow$setAbsorptionAmount(float var1);

    @Shadow
    public abstract void shadow$setHeldItem(Hand var1, @Nullable ItemStack var2);

    @Shadow
    public abstract void shadow$resetActiveHand();

    @Shadow
    public abstract int shadow$getItemInUseCount();

    @Shadow
    public abstract float shadow$getAbsorptionAmount();

    @Shadow
    public abstract float shadow$getHealth();

    @Shadow
    public abstract boolean shadow$isPotionActive(Effect var1);

    @Shadow
    protected abstract boolean shadow$canBlockDamageSource(DamageSource var1);

    @Shadow
    public abstract ItemStack shadow$getItemStackFromSlot(EquipmentSlotType var1);

    @Shadow
    public abstract ItemStack shadow$getHeldItemMainhand();

    @Shadow
    public abstract CombatTracker shadow$getCombatTracker();

    @Shadow
    public void shadow$onKillCommand() {
    }

    @Shadow
    public abstract Hand shadow$getActiveHand();

    @Shadow
    protected abstract void shadow$markVelocityChanged();

    @Shadow
    protected abstract void shadow$damageShield(float var1);

    @Shadow
    protected abstract void shadow$playHurtSound(DamageSource var1);

    @Shadow
    protected abstract void shadow$blockUsingShield(LivingEntity var1);

    @Shadow
    protected abstract float shadow$getSoundVolume();

    @Shadow
    protected abstract float shadow$getSoundPitch();

    @Shadow
    protected abstract SoundEvent shadow$getDeathSound();

    @Shadow
    public abstract boolean shadow$isSleeping();

    @Shadow
    public abstract Optional<BlockPos> shadow$getBedPosition();

    @Shadow
    private boolean shadow$checkTotemDeathProtection(DamageSource p_190628_1_) {
        return false;
    }

    @Shadow
    public abstract void shadow$onDeath(DamageSource var1);

    @Shadow
    protected abstract void shadow$addItemParticles(ItemStack var1, int var2);

    @Shadow
    public abstract void shadow$wakeUp();

    @Shadow
    protected abstract void shadow$damageEntity(DamageSource var1, float var2);

    @Shadow
    public abstract boolean shadow$isOnLadder();

    @Shadow
    public abstract void shadow$setSprinting(boolean var1);

    @Shadow
    public abstract void shadow$setLastAttackedEntity(net.minecraft.entity.Entity var1);

    @Shadow
    protected abstract void shadow$damageArmor(float var1);

    @Shadow
    public abstract ItemStack shadow$getHeldItem(Hand var1);

    @Shadow
    protected abstract void shadow$dropInventory();

    @Shadow
    protected abstract void shadow$spawnDrops(DamageSource var1);

    @Shadow
    @Nullable
    public abstract LivingEntity shadow$getAttackingEntity();

    @Shadow
    protected abstract void shadow$createWitherRose(@Nullable LivingEntity var1);

    @Override
    public boolean bridge$damageEntity(DamageSource damageSource, float damage) {
        if (!this.shadow$isInvulnerableTo(damageSource)) {
            boolean isHuman = (LivingEntity)this instanceof PlayerEntity;
            float originalDamage = damage = this.bridge$applyModDamage((LivingEntity)this, damageSource, damage);
            if (damage <= 0.0f) {
                return false;
            }
            ArrayList<DamageFunction> originalFunctions = new ArrayList<DamageFunction>();
            Optional<DamageFunction> hardHatFunction = DamageEventHandler.createHardHatModifier((LivingEntity)this, damageSource);
            Optional<DamageFunction> armorFunction = DamageEventHandler.createArmorModifiers((LivingEntity)this, damageSource);
            Optional<DamageFunction> resistanceFunction = DamageEventHandler.createResistanceModifier((LivingEntity)this, damageSource);
            Optional<List<DamageFunction>> armorEnchantments = DamageEventHandler.createEnchantmentModifiers((LivingEntity)this, damageSource);
            Optional<DamageFunction> absorptionFunction = DamageEventHandler.createAbsorptionModifier((LivingEntity)this);
            Optional<DamageFunction> shieldFunction = DamageEventHandler.createShieldFunction((LivingEntity)this, damageSource, damage);
            hardHatFunction.ifPresent(originalFunctions::add);
            shieldFunction.ifPresent(originalFunctions::add);
            armorFunction.ifPresent(originalFunctions::add);
            resistanceFunction.ifPresent(originalFunctions::add);
            armorEnchantments.ifPresent(originalFunctions::addAll);
            absorptionFunction.ifPresent(originalFunctions::add);
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                float f2;
                DamageEventHandler.generateCauseFor(damageSource, frame);
                DamageEntityEvent event = SpongeEventFactory.createDamageEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), originalFunctions, originalDamage);
                if (damageSource != DamageTypeStreamGenerator.IGNORED_DAMAGE_SOURCE) {
                    SpongeCommon.postEvent(event);
                }
                if (event.isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
                damage = (float)event.getFinalDamage();
                damage = this.bridge$applyModDamageBeforeFunctions((LivingEntity)this, damageSource, damage);
                ItemStack helmet = this.shadow$getItemStackFromSlot(EquipmentSlotType.HEAD);
                if (damageSource instanceof FallingBlockDamageSource || damageSource == DamageSource.ANVIL || damageSource == DamageSource.FALLING_BLOCK && !helmet.isEmpty()) {
                    helmet.damageItem((int)(event.getBaseDamage() * 4.0 + (double)this.rand.nextFloat() * event.getBaseDamage() * 2.0), (LivingEntity)this, entity -> entity.sendBreakAnimation(EquipmentSlotType.HEAD));
                }
                if (shieldFunction.isPresent()) {
                    net.minecraft.entity.Entity entity2;
                    this.shadow$damageShield((float)event.getBaseDamage());
                    if (!damageSource.isProjectile() && (entity2 = damageSource.getImmediateSource()) instanceof LivingEntity) {
                        this.shadow$blockUsingShield((LivingEntity)entity2);
                    }
                }
                if (!damageSource.isUnblockable() && armorFunction.isPresent()) {
                    this.shadow$damageArmor((float)event.getBaseDamage());
                }
                if (resistanceFunction.isPresent() && (f2 = (float)event.getDamage(resistanceFunction.get().getModifier()) - damage) > 0.0f && f2 < 3.4028235E37f) {
                    if ((LivingEntity)this instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)((LivingEntity)this)).addStat(Stats.DAMAGE_RESISTED, Math.round(f2 * 10.0f));
                    } else if (damageSource.getTrueSource() instanceof ServerPlayerEntity) {
                        ((ServerPlayerEntity)damageSource.getTrueSource()).addStat(Stats.DAMAGE_DEALT_RESISTED, Math.round(f2 * 10.0f));
                    }
                }
                double absorptionModifier = absorptionFunction.map(function -> event.getDamage(function.getModifier())).orElse(0.0);
                if (absorptionFunction.isPresent()) {
                    absorptionModifier = event.getDamage(absorptionFunction.get().getModifier());
                }
                float f = (float)event.getFinalDamage() - (float)absorptionModifier;
                this.shadow$setAbsorptionAmount(Math.max(this.shadow$getAbsorptionAmount() + (float)absorptionModifier, 0.0f));
                if (f > 0.0f && f < 3.4028235E37f && damageSource.getTrueSource() instanceof ServerPlayerEntity) {
                    ((ServerPlayerEntity)damageSource.getTrueSource()).addStat(Stats.DAMAGE_DEALT_ABSORBED, Math.round(f * 10.0f));
                }
                if (damage != 0.0f) {
                    if (isHuman) {
                        ((PlayerEntity)this).addExhaustion(damageSource.getHungerDamage());
                    }
                    float f22 = this.shadow$getHealth();
                    this.shadow$setHealth(f22 - damage);
                    this.shadow$getCombatTracker().trackDamage(damageSource, f22, damage);
                    if (isHuman) {
                        boolean bl = true;
                        return bl;
                    }
                    this.shadow$setAbsorptionAmount(this.shadow$getAbsorptionAmount() - damage);
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Inject(method={"setHealth"}, at={@At(value="HEAD")})
    private void impl$resetDeathEventCounter(float health, CallbackInfo info) {
        if (this.shadow$getHealth() <= 0.0f && health > 0.0f) {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Redirect(method={"dropExperience()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;getExperiencePoints(Lnet/minecraft/entity/player/PlayerEntity;)I"))
    protected int impl$exposeGetExperienceForDeath(LivingEntity entity, PlayerEntity attackingPlayer) {
        return this.bridge$getExperiencePointsOnDeath(entity, attackingPlayer);
    }

    @Overwrite
    protected void damageEntity(DamageSource damageSource, float damage) {
        this.bridge$damageEntity(damageSource, damage);
    }

    @Inject(method={"onDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$throwDestructEntityDeath(DamageSource cause, CallbackInfo ci) {
        boolean throwEvent;
        boolean bl = throwEvent = !((WorldBridge)this.world).bridge$isFake() && Sponge.isServerAvailable() && Sponge.getServer().onMainThread();
        if (!this.dead) {
            if (throwEvent && this.impl$deathEventsPosted <= 3) {
                ++this.impl$deathEventsPosted;
                if (SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)this, cause).isCancelled()) {
                    ci.cancel();
                }
            }
        } else {
            this.impl$deathEventsPosted = 0;
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;setEntityState(Lnet/minecraft/entity/Entity;B)V")}, cancellable=true)
    private void impl$doNotSendStateForHumans(DamageSource cause, CallbackInfo ci) {
        if ((LivingEntity)this instanceof HumanEntity) {
            ci.cancel();
        }
    }

    @Redirect(method={"spawnDrops"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;dropInventory()V"))
    private void tracker$dropInventory(LivingEntity thisEntity) {
        if (thisEntity instanceof PlayerEntityBridge && ((PlayerEntityBridge)thisEntity).bridge$keepInventory()) {
            return;
        }
        this.shadow$dropInventory();
    }

    @Overwrite
    public boolean attackEntityFrom(DamageSource source, float amount) {
        boolean flag2;
        boolean flag;
        this.lastDamageSource = source;
        if (source == null) {
            new PrettyPrinter(60).centre().add("Null DamageSource").hr().addWrapped("Sponge has found a null damage source! This should NEVER happen as the DamageSource is used for all sorts of calculations. Usually this can be considered developer error. Please report the following stacktrace to the most appropriate mod/plugin available.", new Object[0]).add().add(new IllegalArgumentException("Null DamageSource")).log(SpongeCommon.getLogger(), Level.WARN);
            return false;
        }
        if (!this.bridge$onLivingAttack((LivingEntity)this, source, amount)) {
            return false;
        }
        if (this.shadow$isInvulnerableTo(source)) {
            return false;
        }
        if (this.world.isRemote) {
            return false;
        }
        if (this.shadow$getHealth() <= 0.0f && source != DamageTypeStreamGenerator.IGNORED_DAMAGE_SOURCE) {
            return false;
        }
        if (source.isFireDamage() && this.shadow$isPotionActive(Effects.FIRE_RESISTANCE)) {
            return false;
        }
        if (this.shadow$isSleeping() && !this.world.isRemote) {
            this.shadow$wakeUp();
        }
        this.idleTime = 0;
        float f = amount;
        float f1 = 0.0f;
        boolean bl = flag = amount > 0.0f && this.shadow$canBlockDamageSource(source);
        if (flag) {
            f1 = amount;
        }
        this.limbSwingAmount = 1.5f;
        boolean flag1 = true;
        if ((float)this.hurtResistantTime > 10.0f) {
            if (amount <= this.lastDamage) {
                return false;
            }
            if (((EntityTypeBridge)this.shadow$getType()).bridge$overridesDamageEntity()) {
                this.shadow$damageEntity(source, amount - this.lastDamage);
            } else if (!this.bridge$damageEntity(source, amount - this.lastDamage)) {
                return false;
            }
            this.lastDamage = amount;
            flag1 = false;
        } else {
            if (((EntityTypeBridge)this.shadow$getType()).bridge$overridesDamageEntity()) {
                this.shadow$damageEntity(source, amount);
            } else if (!this.bridge$damageEntity(source, amount)) {
                return false;
            }
            this.lastDamage = amount;
            this.hurtResistantTime = 20;
            this.hurtTime = this.maxHurtTime = 10;
        }
        this.attackedAtYaw = 0.0f;
        net.minecraft.entity.Entity entity = source.getTrueSource();
        if (entity != null) {
            TameableEntity wolfentity;
            if (entity instanceof LivingEntity) {
                this.shadow$setRevengeTarget((LivingEntity)entity);
            }
            if (entity instanceof PlayerEntity) {
                this.recentlyHit = 100;
                this.attackingPlayer = (PlayerEntity)entity;
            } else if (entity instanceof TameableEntity && (wolfentity = (TameableEntity)entity).isTamed()) {
                this.recentlyHit = 100;
                LivingEntity livingentity = wolfentity.getOwner();
                this.attackingPlayer = livingentity != null && livingentity.getType() == EntityType.PLAYER ? (PlayerEntity)livingentity : null;
            }
        }
        if (flag1) {
            if (flag) {
                this.world.setEntityState((net.minecraft.entity.Entity)((LivingEntity)this), (byte)29);
            } else if (source instanceof EntityDamageSource && ((EntityDamageSource)source).getIsThornsDamage()) {
                this.world.setEntityState((net.minecraft.entity.Entity)((LivingEntity)this), (byte)33);
            } else {
                byte b0 = source == DamageSource.DROWN ? (byte)36 : (source.isFireDamage() ? (byte)37 : (source == DamageSource.SWEET_BERRY_BUSH ? (byte)44 : 2));
                this.world.setEntityState((net.minecraft.entity.Entity)((LivingEntity)this), b0);
            }
            if (source != DamageSource.DROWN && !flag) {
                this.shadow$markVelocityChanged();
            }
            if (entity != null) {
                double d1 = entity.getPosX() - this.shadow$getPosX();
                double d0 = entity.getPosZ() - this.shadow$getPosZ();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                this.attackedAtYaw = (float)(MathHelper.atan2((double)d0, (double)d1) * 57.2957763671875 - (double)this.rotationYaw);
                this.shadow$knockBack(entity, 0.4f, d1, d0);
            } else {
                this.attackedAtYaw = (float)(Math.random() * 2.0 * 180.0);
            }
        }
        if (this.shadow$getHealth() <= 0.0f) {
            if (!this.shadow$checkTotemDeathProtection(source)) {
                SoundEvent soundevent = this.shadow$getDeathSound();
                if (!this.bridge$isVanished() && flag1 && soundevent != null) {
                    this.shadow$playSound(soundevent, this.shadow$getSoundVolume(), this.shadow$getSoundPitch());
                }
                this.shadow$onDeath(source);
            }
        } else if (flag1 && !this.bridge$isVanished()) {
            this.shadow$playHurtSound(source);
        }
        boolean bl2 = flag2 = !flag;
        if (flag2) {
            this.lastDamageSource = source;
            this.lastDamageStamp = this.world.getGameTime();
        }
        if ((LivingEntity)this instanceof ServerPlayerEntity) {
            CriteriaTriggers.ENTITY_HURT_PLAYER.trigger((ServerPlayerEntity)this, source, f, amount, flag);
            if (f1 > 0.0f && f1 < 3.4028235E37f) {
                ((ServerPlayerEntity)((LivingEntity)this)).addStat(Stats.DAMAGE_BLOCKED_BY_SHIELD, Math.round(f1 * 10.0f));
            }
        }
        if (entity instanceof ServerPlayerEntity) {
            CriteriaTriggers.PLAYER_HURT_ENTITY.trigger((ServerPlayerEntity)entity, (net.minecraft.entity.Entity)this, source, f, amount, flag);
        }
        return flag2;
    }

    @Redirect(method={"triggerItemUseEffects"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;addItemParticles(Lnet/minecraft/item/ItemStack;I)V"))
    private void impl$hideItemParticlesIfVanished(LivingEntity livingEntity, ItemStack stack, int count) {
        if (!this.bridge$isVanished()) {
            this.shadow$addItemParticles(stack, count);
        }
    }

    @Inject(method={"attemptTeleport"}, at={@At(value="HEAD")})
    private void impl$snapshotPositionBeforeVanillaTeleportLogic(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        this.impl$preTeleportPosition = new Vector3d(this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ());
    }

    @Inject(method={"attemptTeleport"}, at={@At(value="RETURN", ordinal=0, shift=At.Shift.BY, by=2)}, cancellable=true)
    private void impl$callMoveEntityEventForTeleport(double x, double y, double z, boolean changeState, CallbackInfoReturnable<Boolean> cir) {
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            MoveEntityEvent event;
            frame.pushCause(this);
            if (!frame.getCurrentContext().containsKey(EventContextKeys.MOVEMENT_TYPE)) {
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.ENTITY_TELEPORT);
            }
            if (SpongeCommon.postEvent(event = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), this.impl$preTeleportPosition, new Vector3d(this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ()), new Vector3d(x, y, z)))) {
                this.shadow$setPositionAndUpdate(this.impl$preTeleportPosition.getX(), this.impl$preTeleportPosition.getY(), this.impl$preTeleportPosition.getZ());
                cir.setReturnValue((Object)false);
                return;
            }
            this.shadow$setPositionAndUpdate(event.getDestinationPosition().getX(), event.getDestinationPosition().getY(), event.getDestinationPosition().getZ());
        }
    }
}

