/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.ai.goal;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.World;
import org.spongepowered.api.entity.living.Ageable;
import org.spongepowered.api.entity.living.animal.Animal;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.TristateResult;
import org.spongepowered.api.event.entity.BreedingEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={BreedGoal.class})
public abstract class BreedGoalMixin {
    @Shadow
    @Final
    protected AnimalEntity animal;
    @Shadow
    protected AnimalEntity targetMate;
    private boolean impl$spawnEntityResult;

    @Shadow
    @Nullable
    private AnimalEntity shadow$getNearbyMate() {
        return null;
    }

    @Nullable
    @Redirect(method={"shouldExecute"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/BreedGoal;getNearbyMate()Lnet/minecraft/entity/passive/AnimalEntity;"))
    private AnimalEntity impl$callFindMateEvent(BreedGoal entityAIMate) {
        AnimalEntity nearbyMate = this.shadow$getNearbyMate();
        if (nearbyMate == null) {
            return null;
        }
        if (ShouldFire.BREEDING_EVENT_FIND_MATE) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this.animal);
                BreedingEvent.FindMate event = SpongeEventFactory.createBreedingEventFindMate(frame.getCurrentCause(), TristateResult.Result.DEFAULT, TristateResult.Result.DEFAULT, (Animal)nearbyMate, true);
                if (SpongeCommon.postEvent(event) || event.getResult() == TristateResult.Result.DENY) {
                    nearbyMate = null;
                }
            }
        }
        return nearbyMate;
    }

    @Inject(method={"spawnBaby"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;addEntity(Lnet/minecraft/entity/Entity;)Z", shift=At.Shift.AFTER, ordinal=0)}, cancellable=true)
    private void impl$cancelSpawnResultIfMarked(CallbackInfo ci) {
        if (!this.impl$spawnEntityResult) {
            ci.cancel();
        }
    }

    @Redirect(method={"spawnBaby()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;addEntity(Lnet/minecraft/entity/Entity;)Z", ordinal=0))
    private boolean impl$throwBreedEvent(World world, Entity baby) {
        if (ShouldFire.BREEDING_EVENT_BREED) {
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this.animal);
                frame.pushCause(this.targetMate);
                BreedingEvent.Breed event = SpongeEventFactory.createBreedingEventBreed(PhaseTracker.getCauseStackManager().getCurrentCause(), (Ageable)baby);
                this.impl$spawnEntityResult = !SpongeCommon.postEvent(event) && world.addEntity(baby);
            }
        } else {
            this.impl$spawnEntityResult = world.addEntity(baby);
        }
        return this.impl$spawnEntityResult;
    }
}

