/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.item;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.util.DamageSourceBridge;
import org.spongepowered.common.mixin.core.entity.EntityMixin;
import org.spongepowered.common.util.MinecraftFallingBlockDamageSource;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends EntityMixin {
    @Shadow
    private BlockState fallTile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"onLivingFall(FF)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean spongeAttackFallingOrAnvil(Entity entity, DamageSource source, float damage) {
        if (entity.world.isRemote) {
            return entity.attackEntityFrom(source, damage);
        }
        boolean isAnvil = this.fallTile.getBlock().isIn(BlockTags.ANVIL);
        try {
            if (isAnvil) {
                MinecraftFallingBlockDamageSource anvil = new MinecraftFallingBlockDamageSource("anvil", (FallingBlockEntity)this);
                ((DamageSourceBridge)((Object)anvil)).bridge$setAnvilSource();
                boolean bl = entity.attackEntityFrom(DamageSource.ANVIL, damage);
                return bl;
            }
            MinecraftFallingBlockDamageSource fallingblock = new MinecraftFallingBlockDamageSource("fallingblock", (FallingBlockEntity)this);
            ((DamageSourceBridge)((Object)fallingblock)).bridge$setFallingBlockSource();
            boolean bl = entity.attackEntityFrom(DamageSource.FALLING_BLOCK, damage);
            return bl;
        }
        finally {
            if (isAnvil) {
                ((DamageSourceBridge)source).bridge$setAnvilSource();
            } else {
                ((DamageSourceBridge)source).bridge$setFallingBlockSource();
            }
        }
    }
}

