/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.passive;

import java.util.Random;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import org.spongepowered.api.entity.living.animal.Ocelot;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.core.entity.AgeableEntityMixin;

@Mixin(value={OcelotEntity.class})
public abstract class OcelotEntityMixin
extends AgeableEntityMixin {
    @Redirect(method={"processInteract"}, at=@At(value="INVOKE", target="Ljava/util/Random;nextInt(I)I", ordinal=0, remap=false))
    private int impl$ThrowTameEvent(Random rand, int bound, PlayerEntity player, Hand hand) {
        ItemStack stack = player.getHeldItem(hand);
        int random = rand.nextInt(bound);
        if (random == 0) {
            stack.setCount(stack.getCount() + 1);
            try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(player);
                if (!SpongeCommon.postEvent(SpongeEventFactory.createTameEntityEvent(frame.getCurrentCause(), (Ocelot)((Object)this)))) {
                    stack.setCount(stack.getCount() - 1);
                    int n = random;
                    return n;
                }
            }
        }
        return 1;
    }

    @Inject(method={"func_213529_dV"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$IgnoreAISetupOnClientWorld(CallbackInfo ci) {
        if (this.world.isRemote) {
            ci.cancel();
        }
    }
}

