/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.player;

import io.netty.channel.Channel;
import java.util.HashSet;
import java.util.Locale;
import javax.annotation.Nullable;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.Component;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.network.play.client.CClientSettingsPacket;
import net.minecraft.network.play.server.SCombatPacket;
import net.minecraft.network.play.server.SSpawnPositionPacket;
import net.minecraft.network.play.server.SUpdateBossInfoPacket;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.GameRules;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.TicketType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.adventure.Audiences;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.entity.MovementTypes;
import org.spongepowered.api.event.entity.ChangeEntityWorldEvent;
import org.spongepowered.api.event.entity.DestructEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.entity.RotateEntityEvent;
import org.spongepowered.api.event.entity.living.player.KickPlayerEvent;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.api.util.locale.Locales;
import org.spongepowered.api.world.ServerLocation;
import org.spongepowered.api.world.portal.PortalType;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.network.NetworkManagerAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.LocationTargetingBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.entity.player.PlayerEntityBridge;
import org.spongepowered.common.bridge.entity.player.ServerPlayerEntityBridge;
import org.spongepowered.common.bridge.permissions.SubjectBridge;
import org.spongepowered.common.bridge.scoreboard.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.BossInfoBridge;
import org.spongepowered.common.bridge.world.PlatformITeleporterBridge;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.living.human.HumanEntity;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.mixin.core.entity.player.PlayerEntityMixin;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.portal.WrappedITeleporterPortalType;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={ServerPlayerEntity.class})
public abstract class ServerPlayerEntityMixin
extends PlayerEntityMixin
implements SubjectBridge,
LocationTargetingBridge,
ServerPlayerEntityBridge {
    @Shadow
    public ServerPlayNetHandler connection;
    @Shadow
    @Final
    public PlayerInteractionManager interactionManager;
    @Shadow
    @Final
    public MinecraftServer server;
    @Shadow
    private int lastExperience;
    private final User impl$user = this.impl$getUserObjectOnConstruction();
    private @org.checkerframework.checker.nullness.qual.Nullable ITextComponent impl$connectionMessage;
    private Scoreboard impl$scoreboard = Sponge.getGame().getServer().getServerScoreboard().get();
    private @org.checkerframework.checker.nullness.qual.Nullable Boolean impl$keepInventory = null;
    private ItemStack impl$packetItem = ItemStack.EMPTY;

    @Shadow
    public abstract net.minecraft.world.server.ServerWorld shadow$getServerWorld();

    @Shadow
    public abstract void shadow$setSpectatingEntity(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void shadow$stopRiding();

    @Shadow
    public abstract void shadow$closeContainer();

    @Shadow
    public abstract void shadow$takeStat(Stat<?> var1);

    @Override
    public @org.checkerframework.checker.nullness.qual.Nullable ITextComponent bridge$getConnectionMessageToSend() {
        if (this.impl$connectionMessage == null) {
            return new StringTextComponent("");
        }
        return this.impl$connectionMessage;
    }

    @Override
    public void bridge$setConnectionMessageToSend(ITextComponent message) {
        this.impl$connectionMessage = message;
    }

    @Override
    public String bridge$getSubjectCollectionIdentifier() {
        return "user";
    }

    @Override
    public User bridge$getUserObject() {
        return this.impl$user;
    }

    @Override
    public User bridge$getUser() {
        return this.impl$user;
    }

    @Override
    public boolean bridge$isVanished() {
        return false;
    }

    @Override
    public Tristate bridge$permDefault(String permission) {
        return Tristate.FALSE;
    }

    @Override
    public void bridge$setPacketItem(ItemStack itemstack) {
        this.impl$packetItem = itemstack;
    }

    @Override
    public boolean bridge$setLocation(ServerLocation location) {
        if (this.removed) {
            return false;
        }
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            Vector3d toPosition;
            Event event;
            frame.pushCause(SpongeCommon.getActivePlugin());
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            net.minecraft.world.server.ServerWorld destinationWorld = (net.minecraft.world.server.ServerWorld)location.getWorld();
            if (this.shadow$getServerWorld() != destinationWorld) {
                event = SpongeEventFactory.createChangeEntityWorldEventPre(frame.getCurrentCause(), (Entity)((Object)this), (ServerWorld)this.shadow$getServerWorld(), (ServerWorld)location.getWorld(), (ServerWorld)location.getWorld());
                if (SpongeCommon.postEvent(event)) {
                    boolean bl = false;
                    return bl;
                }
                ChangeEntityWorldEvent.Reposition repositionEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.getCurrentCause(), (Entity)((Object)this), (ServerWorld)this.shadow$getServerWorld(), VecHelper.toVector3d(this.shadow$getPositionVector()), location.getPosition(), event.getOriginalDestinationWorld(), location.getPosition(), event.getDestinationWorld());
                if (SpongeCommon.postEvent(repositionEvent)) {
                    boolean bl = false;
                    return bl;
                }
                destinationWorld = (net.minecraft.world.server.ServerWorld)event.getDestinationWorld();
                toPosition = repositionEvent.getDestinationPosition();
            } else {
                event = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (Entity)((Object)this), VecHelper.toVector3d(this.shadow$getPositionVector()), location.getPosition(), location.getPosition());
                if (SpongeCommon.postEvent(event)) {
                    boolean bl = false;
                    return bl;
                }
                toPosition = event.getDestinationPosition();
            }
            ((ServerPlayerEntity)this).stopRiding();
            if (((ServerPlayerEntity)this).isSleeping()) {
                ((ServerPlayerEntity)this).stopSleepInBed(true, true);
            }
            ChunkPos chunkPos = new ChunkPos((int)toPosition.getX() >> 4, (int)toPosition.getZ() >> 4);
            destinationWorld.getChunkProvider().registerTicket(TicketType.POST_TELEPORT, chunkPos, 1, (Object)((ServerPlayerEntity)this).getEntityId());
            if (this.shadow$getServerWorld() != destinationWorld) {
                this.shadow$setLocationAndAngles(toPosition.getX(), toPosition.getY(), toPosition.getZ(), this.rotationYaw, this.rotationPitch);
                EntityUtil.performPostChangePlayerWorldLogic((ServerPlayerEntity)this, this.shadow$getServerWorld(), (net.minecraft.world.server.ServerWorld)location.getWorld(), destinationWorld, false);
            } else {
                this.connection.setPlayerLocation(toPosition.getX(), toPosition.getY(), toPosition.getZ(), this.rotationYaw, this.rotationPitch, new HashSet());
            }
        }
        return true;
    }

    @Override
    public void bridge$refreshExp() {
        this.lastExperience = -1;
    }

    @Override
    public boolean bridge$kick(Component message) {
        Component messageToSend;
        if (ShouldFire.KICK_PLAYER_EVENT) {
            KickPlayerEvent kickEvent = SpongeEventFactory.createKickPlayerEvent(PhaseTracker.getCauseStackManager().getCurrentCause(), message, message, (ServerPlayer)((Object)this));
            if (Sponge.getEventManager().post(kickEvent)) {
                return false;
            }
            messageToSend = kickEvent.getMessage();
        } else {
            messageToSend = message;
        }
        ITextComponent component = SpongeAdventure.asVanilla(messageToSend);
        this.connection.disconnect(component);
        return true;
    }

    @Override
    public void bridge$initScoreboard() {
        ((ServerScoreboardBridge)this.shadow$getWorldScoreboard()).bridge$addPlayer((ServerPlayerEntity)this, true);
    }

    @Override
    public void bridge$removeScoreboardOnRespawn() {
        ((ServerScoreboardBridge)((Object)((ServerPlayer)((Object)this)).getScoreboard())).bridge$removePlayer((ServerPlayerEntity)this, false);
    }

    @Override
    public void bridge$setScoreboardOnRespawn(Scoreboard scoreboard) {
        this.impl$scoreboard = scoreboard;
        ((ServerScoreboardBridge)((Object)((ServerPlayer)((Object)this)).getScoreboard())).bridge$addPlayer((ServerPlayerEntity)this, false);
    }

    @Override
    public Scoreboard bridge$getScoreboard() {
        return this.impl$scoreboard;
    }

    @Override
    public void bridge$replaceScoreboard(@org.checkerframework.checker.nullness.qual.Nullable Scoreboard scoreboard) {
        if (scoreboard == null) {
            scoreboard = Sponge.getGame().getServer().getServerScoreboard().orElseThrow(() -> new IllegalStateException("Server does not have a valid scoreboard"));
        }
        this.impl$scoreboard = scoreboard;
    }

    @Override
    public boolean bridge$keepInventory() {
        if (this.impl$keepInventory == null) {
            return this.world.getGameRules().getBoolean(GameRules.KEEP_INVENTORY);
        }
        return this.impl$keepInventory;
    }

    @Override
    public int bridge$getExperiencePointsOnDeath(LivingEntity entity, PlayerEntity attackingPlayer) {
        if (this.impl$keepInventory != null && this.impl$keepInventory.booleanValue()) {
            return 0;
        }
        return super.bridge$getExperiencePointsOnDeath(entity, attackingPlayer);
    }

    @Override
    public void bridge$setTargetedPosition(@org.checkerframework.checker.nullness.qual.Nullable Vector3d position) {
        this.impl$targetedPosition = position;
        if (position != null) {
            this.connection.sendPacket((IPacket)new SSpawnPositionPacket(VecHelper.toBlockPos(position)));
        }
    }

    @Overwrite
    public void teleport(net.minecraft.world.server.ServerWorld world, double x, double y, double z, float yaw, float pitch) {
        ServerPlayerEntity player = (ServerPlayerEntity)this;
        double actualYaw = yaw;
        double actualPitch = pitch;
        boolean hasMovementContext = PhaseTracker.getCauseStackManager().getCurrentContext().containsKey(EventContextKeys.MOVEMENT_TYPE);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            if (!hasMovementContext) {
                frame.pushCause(SpongeCommon.getActivePlugin());
                frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PLUGIN);
            }
            if (world == player.world) {
                MoveEntityEvent posEvent = SpongeEventFactory.createMoveEntityEvent(frame.getCurrentCause(), (Entity)player, VecHelper.toVector3d(player.getPositionVector()), new Vector3d(x, y, z), new Vector3d(x, y, z));
                if (SpongeCommon.postEvent(posEvent)) {
                    return;
                }
                RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (Entity)player, new Vector3d(actualPitch, actualYaw, 0.0), new Vector3d(pitch, yaw, 0.0f));
                SpongeCommon.postEvent(rotateEvent);
                double actualX = posEvent.getDestinationPosition().getX();
                double actualY = posEvent.getDestinationPosition().getY();
                double actualZ = posEvent.getDestinationPosition().getZ();
                actualYaw = rotateEvent.isCancelled() ? (double)player.rotationYaw : rotateEvent.getToRotation().getY();
                actualPitch = rotateEvent.isCancelled() ? (double)player.rotationPitch : rotateEvent.getToRotation().getX();
                this.shadow$setSpectatingEntity((net.minecraft.entity.Entity)player);
                this.shadow$stopRiding();
                if (player.isSleeping()) {
                    player.stopSleepInBed(true, true);
                }
                player.connection.setPlayerLocation(actualX, actualY, actualZ, (float)actualYaw, (float)actualPitch);
                player.setRotationYawHead((float)actualYaw);
                ChunkPos chunkpos = new ChunkPos(new BlockPos(actualX, actualY, actualZ));
                world.getChunkProvider().registerTicket(TicketType.POST_TELEPORT, chunkpos, 1, (Object)player.getEntityId());
            } else {
                ChangeEntityWorldEvent.Pre preEvent = PlatformHooks.getInstance().getEventHooks().callChangeEntityWorldEventPre((net.minecraft.entity.Entity)player, world);
                if (SpongeCommon.postEvent(preEvent)) {
                    return;
                }
                ChangeEntityWorldEvent.Reposition posEvent = SpongeEventFactory.createChangeEntityWorldEventReposition(frame.getCurrentCause(), (Entity)player, preEvent.getOriginalWorld(), VecHelper.toVector3d(player.getPositionVector()), new Vector3d(x, y, z), preEvent.getOriginalDestinationWorld(), new Vector3d(x, y, z), preEvent.getDestinationWorld());
                RotateEntityEvent rotateEvent = SpongeEventFactory.createRotateEntityEvent(frame.getCurrentCause(), (Entity)player, new Vector3d(actualYaw, actualPitch, 0.0), new Vector3d(yaw, pitch, 0.0f));
                if (SpongeCommon.postEvent(posEvent)) {
                    return;
                }
                this.shadow$setPosition(posEvent.getDestinationPosition().getX(), posEvent.getDestinationPosition().getY(), posEvent.getDestinationPosition().getZ());
                if (!SpongeCommon.postEvent(rotateEvent)) {
                    this.rotationYaw = (float)rotateEvent.getToRotation().getX();
                    this.rotationPitch = (float)rotateEvent.getToRotation().getY();
                }
                EntityUtil.performPostChangePlayerWorldLogic(player, (net.minecraft.world.server.ServerWorld)preEvent.getOriginalWorld(), (net.minecraft.world.server.ServerWorld)preEvent.getOriginalDestinationWorld(), (net.minecraft.world.server.ServerWorld)preEvent.getDestinationWorld(), false);
            }
        }
    }

    @Override
    @Nullable
    @Overwrite
    public net.minecraft.entity.Entity changeDimension(DimensionType destination) {
        if (this.shadow$getEntityWorld().isRemote || this.removed) {
            return (ServerPlayerEntity)this;
        }
        WrappedITeleporterPortalType portalType = new WrappedITeleporterPortalType((PlatformITeleporterBridge)this.shadow$getServer().getWorld(destination).getDefaultTeleporter(), null);
        try (CauseStackManager.StackFrame frame = PhaseTracker.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(this);
            frame.pushCause(portalType);
            frame.addContext(EventContextKeys.MOVEMENT_TYPE, MovementTypes.PORTAL);
            EntityUtil.invokePortalTo((ServerPlayerEntity)this, (PortalType)portalType, destination);
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)this;
            return serverPlayerEntity;
        }
    }

    @Inject(method={"removeEntity"}, at={@At(value="RETURN")})
    private void impl$removeHumanFromPlayerClient(net.minecraft.entity.Entity entityIn, CallbackInfo ci) {
        if (entityIn instanceof HumanEntity) {
            ((HumanEntity)entityIn).untrackFrom((ServerPlayerEntity)this);
        }
    }

    @Redirect(method={"openContainer", "openHorseInventory"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/ServerPlayerEntity;closeScreen()V"))
    private void impl$closePreviousContainer(ServerPlayerEntity self) {
        this.shadow$closeContainer();
    }

    @Overwrite
    public void onDeath(DamageSource cause) {
        boolean flag;
        DestructEntityEvent.Death event = SpongeCommonEventFactory.callDestructEntityEventDeath((LivingEntity)((ServerPlayerEntity)this), cause, Audiences.server());
        if (event.isCancelled()) {
            return;
        }
        boolean bl = flag = this.world.getGameRules().getBoolean(GameRules.SHOW_DEATH_MESSAGES) && !event.isMessageCancelled();
        if (flag) {
            ITextComponent itextcomponent = this.shadow$getCombatTracker().getDeathMessage();
            this.connection.sendPacket((IPacket)new SCombatPacket(this.shadow$getCombatTracker(), SCombatPacket.Event.ENTITY_DIED, itextcomponent), p_212356_2_ -> {
                if (!p_212356_2_.isSuccess()) {
                    int i = 256;
                    String s2 = itextcomponent.getStringTruncated(256);
                    TranslationTextComponent itextcomponent1 = new TranslationTextComponent("death.attack.message_too_long", new Object[]{new StringTextComponent(s2).applyTextStyle(TextFormatting.YELLOW)});
                    ITextComponent itextcomponent2 = new TranslationTextComponent("death.attack.even_more_magic", new Object[]{this.shadow$getDisplayName()}).applyTextStyle(arg_0 -> ServerPlayerEntityMixin.lambda$null$1((ITextComponent)itextcomponent1, arg_0));
                    this.connection.sendPacket((IPacket)new SCombatPacket(this.shadow$getCombatTracker(), SCombatPacket.Event.ENTITY_DIED, itextcomponent2));
                }
            });
            Team team = this.shadow$getTeam();
            if (team != null && team.getDeathMessageVisibility() != Team.Visible.ALWAYS) {
                if (team.getDeathMessageVisibility() == Team.Visible.HIDE_FOR_OTHER_TEAMS) {
                    this.server.getPlayerList().sendMessageToAllTeamMembers((PlayerEntity)((ServerPlayerEntity)this), itextcomponent);
                } else if (team.getDeathMessageVisibility() == Team.Visible.HIDE_FOR_OWN_TEAM) {
                    this.server.getPlayerList().sendMessageToTeamOrAllPlayers((PlayerEntity)((ServerPlayerEntity)this), itextcomponent);
                }
            } else {
                Component message = event.getMessage();
                if (message != Component.empty()) {
                    event.getAudience().ifPresent(eventChannel -> eventChannel.sendMessage(Identity.nil(), message));
                }
            }
        } else {
            this.connection.sendPacket((IPacket)new SCombatPacket(this.shadow$getCombatTracker(), SCombatPacket.Event.ENTITY_DIED));
        }
        this.shadow$spawnShoulderEntities();
        this.impl$keepInventory = event.getKeepInventory();
        if (!this.shadow$isSpectator()) {
            this.shadow$spawnDrops(cause);
        }
        this.shadow$getWorldScoreboard().forAllObjectives(ScoreCriteria.DEATH_COUNT, this.shadow$getScoreboardName(), Score::incrementScore);
        LivingEntity livingentity = this.shadow$getAttackingEntity();
        if (livingentity != null) {
            this.shadow$addStat(Stats.ENTITY_KILLED_BY.get((Object)livingentity.getType()));
            livingentity.awardKillScore((net.minecraft.entity.Entity)((ServerPlayerEntity)this), this.scoreValue, cause);
            this.shadow$createWitherRose(livingentity);
        }
        this.world.setEntityState((net.minecraft.entity.Entity)((ServerPlayerEntity)this), (byte)3);
        this.shadow$addStat(Stats.DEATHS);
        this.shadow$takeStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_DEATH));
        this.shadow$takeStat(Stats.CUSTOM.get((Object)Stats.TIME_SINCE_REST));
        this.shadow$extinguish();
        this.shadow$setFlag(0, false);
        this.shadow$getCombatTracker().reset();
    }

    @Redirect(method={"copyFrom"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/GameRules;getBoolean(Lnet/minecraft/world/GameRules$RuleKey;)Z"))
    private boolean tracker$useKeepFromBridge(GameRules gameRules, GameRules.RuleKey<?> key, ServerPlayerEntity corpse, boolean keepEverything) {
        boolean keep = ((PlayerEntityBridge)corpse).bridge$keepInventory();
        if (!keep) {
            this.inventory.copyInventory(corpse.inventory);
            corpse.inventory.clear();
        }
        return keep;
    }

    private User impl$getUserObjectOnConstruction() {
        if (this.impl$isFake) {
            return this.bridge$getUserObject();
        }
        return ((SpongeUserManager)SpongeCommon.getGame().getServer().getUserManager()).forceRecreateUser(SpongeGameProfile.of(this.shadow$getGameProfile()));
    }

    @Inject(method={"copyFrom"}, at={@At(value="HEAD")})
    private void impl$copyDataOnRespawn(ServerPlayerEntity oldPlayer, boolean respawnFromEnd, CallbackInfo ci) {
        DataCompoundHolder oldEntity;
        if (oldPlayer instanceof DataCompoundHolder && (oldEntity = (DataCompoundHolder)oldPlayer).data$hasSpongeData()) {
            CompoundNBT compound = oldEntity.data$getCompound();
            this.data$setCompound(compound);
        }
        SpongeAdventure.forEachBossBar(bar -> ((BossInfoBridge)bar).bridge$replacePlayer(oldPlayer, (ServerPlayerEntity)this));
    }

    @Inject(method={"handleClientSettings"}, at={@At(value="HEAD")})
    private void impl$handleClientSettings(CClientSettingsPacket packet, CallbackInfo ci) {
        Locale newLocale = Locales.of(packet.getLang());
        Channel channel = ((NetworkManagerAccessor)this.connection.netManager).accessor$getChannel();
        channel.attr(SpongeAdventure.CHANNEL_LOCALE).set((Object)newLocale);
        SpongeAdventure.forEachBossBar(bar -> this.connection.sendPacket((IPacket)new SUpdateBossInfoPacket(SUpdateBossInfoPacket.Operation.UPDATE_NAME, (BossInfo)bar)));
    }

    private static /* synthetic */ void lambda$null$1(ITextComponent itextcomponent1, Style p_212357_1_) {
        p_212357_1_.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, itextcomponent1));
    }
}

