/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={FishingBobberEntity.class})
public abstract class FishingBobberEntityMixin
extends EntityMixin {
    @Shadow
    @Nullable
    private PlayerEntity angler;
    @Shadow
    @Nullable
    public net.minecraft.entity.Entity caughtEntity;
    @Shadow
    private int ticksCatchable;
    @Shadow
    private int luck;
    @Shadow
    private boolean inGround;
    @Nullable
    private ProjectileSource impl$projectileSource;

    @Shadow
    protected abstract void bringInHookedEntity();

    @Inject(method={"setHookedEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetHookedEntity(CallbackInfo ci) {
        if (SpongeCommon.postEvent(SpongeEventFactory.createFishingEventHookEntity(PhaseTracker.getCauseStackManager().getCurrentCause(), (Entity)this.caughtEntity, (FishingBobber)((Object)this)))) {
            this.caughtEntity = null;
            ci.cancel();
        }
    }

    @Overwrite
    public int handleHookRetraction(ItemStack stack) {
        if (!this.world.isRemote && this.angler != null) {
            List<Transaction<ItemStackSnapshot>> transactions;
            int i = 0;
            if (this.ticksCatchable > 0) {
                LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.world).withParameter(LootParameters.POSITION, (Object)new BlockPos((net.minecraft.entity.Entity)((FishingBobberEntity)this))).withParameter(LootParameters.TOOL, (Object)stack).withRandom(this.rand).withLuck((float)this.luck + this.angler.getLuck());
                LootTable lootTable = this.world.getServer().getLootTableManager().getLootTableFromLocation(LootTables.GAMEPLAY_FISHING);
                List list = lootTable.generate(lootcontext$builder.build(LootParameterSets.FISHING));
                transactions = list.stream().map(ItemStackUtil::snapshotOf).map(snapshot -> new Transaction<ItemStackSnapshot>((ItemStackSnapshot)snapshot, (ItemStackSnapshot)snapshot)).collect(Collectors.toList());
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayerEntity)this.angler, stack, (FishingBobberEntity)this, (Collection)list);
            } else {
                transactions = new ArrayList<Transaction<ItemStackSnapshot>>();
            }
            PhaseTracker.getCauseStackManager().pushCause(this.angler);
            if (SpongeCommon.postEvent(SpongeEventFactory.createFishingEventStop(PhaseTracker.getCauseStackManager().getCurrentCause(), (FishingBobber)((Object)this), transactions))) {
                return 0;
            }
            if (this.caughtEntity != null) {
                this.bringInHookedEntity();
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayerEntity)this.angler, stack, (FishingBobberEntity)this, Collections.emptyList());
                this.world.setEntityState((net.minecraft.entity.Entity)this, (byte)31);
                int n = i = this.caughtEntity instanceof ItemEntity ? 3 : 5;
            }
            if (!transactions.isEmpty()) {
                for (Transaction transaction : transactions) {
                    if (!transaction.isValid()) continue;
                    ItemStack itemstack = (ItemStack)((ItemStackSnapshot)transaction.getFinal()).createStack();
                    ItemEntity entityitem = new ItemEntity(this.world, this.shadow$getPosX(), this.shadow$getPosY(), this.shadow$getPosZ(), itemstack);
                    double d0 = this.angler.getPosX() - this.shadow$getPosX();
                    double d1 = this.angler.getPosY() - this.shadow$getPosY();
                    double d2 = this.angler.getPosZ() - this.shadow$getPosZ();
                    double d3 = MathHelper.sqrt((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    entityitem.setMotion(d0 * 0.1, d1 * 0.1 + (double)MathHelper.sqrt((double)d3) * 0.08, d2 * 0.1);
                    this.world.addEntity((net.minecraft.entity.Entity)entityitem);
                    this.angler.world.addEntity((net.minecraft.entity.Entity)new ExperienceOrbEntity(this.angler.world, this.angler.getPosX(), this.angler.getPosY() + 0.5, this.angler.getPosZ() + 0.5, this.rand.nextInt(6) + 1));
                    Item item = itemstack.getItem();
                    if (!item.isIn(ItemTags.FISHES)) continue;
                    this.angler.addStat(Stats.FISH_CAUGHT, 1);
                }
                PhaseTracker.getCauseStackManager().popCause();
                i = Math.max(i, 1);
            }
            if (this.inGround) {
                i = 2;
            }
            this.shadow$remove();
            return i;
        }
        return 0;
    }

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, (FishingBobber)((Object)this));
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, (ProjectileSource)((FishingBobber)((Object)this)).shooter().get(), (net.minecraft.entity.Entity)this.angler);
    }

    @Inject(method={"checkCollision"}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/RayTraceResult;getType()Lnet/minecraft/util/math/RayTraceResult$Type;")})
    private void impl$callCollideImpactEvent(CallbackInfo ci, RayTraceResult hitResult) {
        if (hitResult.getType() == RayTraceResult.Type.MISS || ((WorldBridge)this.world).bridge$isFake()) {
            return;
        }
        if (SpongeCommonEventFactory.handleCollideImpactEvent((net.minecraft.entity.Entity)((FishingBobberEntity)this), ((Projectile)((Object)this)).get(Keys.SHOOTER).orElse(null), hitResult)) {
            this.shadow$remove();
            ci.cancel();
        }
    }
}

