/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.RayTraceResult;
import org.spongepowered.api.entity.projectile.Projectile;
import org.spongepowered.api.projectile.source.ProjectileSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.entity.projectile.ProjectileSourceSerializer;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.mixin.core.entity.EntityMixin;

@Mixin(value={ThrowableEntity.class})
public abstract class ThrowableEntityMixin
extends EntityMixin {
    @Shadow
    protected LivingEntity owner;

    @Shadow
    @Nullable
    public abstract LivingEntity shadow$getThrower();

    @Shadow
    protected abstract void onImpact(RayTraceResult var1);

    @Override
    public void impl$readFromSpongeCompound(CompoundNBT compound) {
        super.impl$readFromSpongeCompound(compound);
        ProjectileSourceSerializer.readSourceFromNbt(compound, (Projectile)((Object)this));
    }

    @Override
    public void impl$writeToSpongeCompound(CompoundNBT compound) {
        super.impl$writeToSpongeCompound(compound);
        ProjectileSourceSerializer.writeSourceToNbt(compound, (ProjectileSource)((Projectile)((Object)this)).shooter().get(), (Entity)this.shadow$getThrower());
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/projectile/ThrowableEntity;onImpact(Lnet/minecraft/util/math/RayTraceResult;)V"))
    private void impl$handleProjectileImpact(ThrowableEntity projectile, RayTraceResult movingObjectPosition) {
        if (((WorldBridge)this.world).bridge$isFake() || movingObjectPosition.getType() == RayTraceResult.Type.MISS) {
            this.onImpact(movingObjectPosition);
            return;
        }
        if (SpongeCommonEventFactory.handleCollideImpactEvent((Entity)projectile, (ProjectileSource)this.shadow$getThrower(), movingObjectPosition)) {
            this.shadow$remove();
        } else {
            this.onImpact(movingObjectPosition);
        }
    }
}

