/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import org.spongepowered.api.entity.projectile.FishingBobber;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={FishingRodItem.class})
public abstract class FishingRodItemMixin {
    @Nullable
    private FishingBobberEntity impl$fishHook;

    @Inject(method={"onItemRightClick"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/entity/projectile/FishingBobberEntity;handleHookRetraction(Lnet/minecraft/item/ItemStack;)I")}, cancellable=true)
    private void cancelHookRetraction(World world, PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResult<ItemStack>> cir) {
        if (player.fishingBobber != null) {
            cir.setReturnValue((Object)new ActionResult(ActionResultType.SUCCESS, (Object)player.getHeldItem(hand)));
        }
    }

    @Inject(method={"onItemRightClick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/World;playSound(Lnet/minecraft/entity/player/PlayerEntity;DDDLnet/minecraft/util/SoundEvent;Lnet/minecraft/util/SoundCategory;FF)V", ordinal=1)}, cancellable=true)
    private void onThrowEvent(World world, PlayerEntity player, Hand hand, CallbackInfoReturnable<ActionResult<ItemStack>> cir) {
        if (world.isRemote) {
            return;
        }
        ItemStack itemstack = player.getHeldItem(hand);
        int k = EnchantmentHelper.getFishingSpeedBonus((ItemStack)itemstack);
        int j = EnchantmentHelper.getFishingLuckBonus((ItemStack)itemstack);
        FishingBobberEntity fishHook = new FishingBobberEntity(player, world, j, k);
        PhaseTracker.getCauseStackManager().pushCause(player);
        if (SpongeCommon.postEvent(SpongeEventFactory.createFishingEventStart(PhaseTracker.getCauseStackManager().getCurrentCause(), (FishingBobber)fishHook))) {
            fishHook.remove();
            cir.setReturnValue((Object)new ActionResult(ActionResultType.SUCCESS, (Object)player.getHeldItem(hand)));
        } else {
            this.impl$fishHook = fishHook;
        }
        PhaseTracker.getCauseStackManager().popCause();
    }

    @Redirect(method={"onItemRightClick"}, at=@At(value="NEW", target="net/minecraft/entity/projectile/FishingBobberEntity"))
    private FishingBobberEntity onNewEntityFishHook(World world, PlayerEntity player) {
        FishingBobberEntity fishHook = this.impl$fishHook;
        this.impl$fishHook = null;
        return fishHook;
    }
}

