/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.data.provider.nbt.NBTDataType;
import org.spongepowered.common.data.provider.nbt.NBTDataTypes;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={net.minecraft.item.ItemStack.class})
public abstract class ItemStackMixin
implements CustomDataHolderBridge,
DataCompoundHolder {
    @Shadow
    private CompoundNBT tag;
    @Shadow
    private boolean isEmpty;

    @Shadow
    public abstract void shadow$setTag(@Nullable CompoundNBT var1);

    @Shadow
    @Nullable
    public abstract CompoundNBT shadow$getTag();

    @Override
    public <E> DataTransactionResult bridge$offerCustom(Key<@NonNull ? extends Value<E>> key, E value) {
        if (this.isEmpty) {
            return DataTransactionResult.failNoData();
        }
        return CustomDataHolderBridge.super.bridge$offerCustom(key, value);
    }

    @Override
    public <E> Optional<E> bridge$getCustom(Key<@NonNull ? extends Value<E>> key) {
        if (this.isEmpty) {
            return Optional.empty();
        }
        return CustomDataHolderBridge.super.bridge$getCustom(key);
    }

    @Override
    public <E> DataTransactionResult bridge$removeCustom(Key<@NonNull ? extends Value<E>> key) {
        if (this.isEmpty) {
            return DataTransactionResult.failNoData();
        }
        return CustomDataHolderBridge.super.bridge$removeCustom(key);
    }

    @Override
    public CompoundNBT data$getCompound() {
        return this.shadow$getTag();
    }

    @Override
    public void data$setCompound(CompoundNBT nbt) {
        this.shadow$setTag(nbt);
    }

    @Inject(method={"copy"}, at={@At(value="RETURN")})
    private void impl$onCopy(CallbackInfoReturnable<net.minecraft.item.ItemStack> info) {
        ((CustomDataHolderBridge)info.getReturnValue()).bridge$mergeDeserialized(this.bridge$getManipulator());
    }

    @Inject(method={"split"}, at={@At(value="RETURN")})
    private void impl$onSplit(int amount, CallbackInfoReturnable<net.minecraft.item.ItemStack> info) {
        ((CustomDataHolderBridge)info.getReturnValue()).bridge$mergeDeserialized(this.bridge$getManipulator());
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/CompoundNBT;)V"}, at={@At(value="RETURN")})
    private void impl$onRead(CompoundNBT compound, CallbackInfo info) {
        if (!this.isEmpty) {
            CustomDataHolderBridge.syncCustomToTag(this);
        }
        if (this.tag != null && this.tag.isEmpty()) {
            this.tag = null;
        }
    }

    @Redirect(method={"removeChildTag"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundNBT;remove(Ljava/lang/String;)V"))
    private void impl$nullStackCompoundIfEmptyAfterRemoval(CompoundNBT compound, String key) {
        compound.remove(key);
        if (compound.isEmpty()) {
            this.tag = null;
        }
    }

    @Inject(method={"setTag"}, at={@At(value="RETURN")})
    private void impl$onSet(CompoundNBT compound, CallbackInfo callbackInfo) {
        if (this.shadow$getTag() != compound) {
            this.bridge$clearCustomData();
        }
        CustomDataHolderBridge.syncTagToCustom(this);
    }

    @Inject(method={"onBlockDestroyed"}, at={@At(value="HEAD")})
    private void impl$capturePlayerUsingItemstack(World worldIn, BlockState blockIn, BlockPos pos, PlayerEntity playerIn, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake()) {
            PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
            IPhaseState state = context.state;
            state.capturePlayerUsingStackToBreakBlock((ItemStack)((Object)this), (ServerPlayerEntity)playerIn, context);
        }
    }

    @Inject(method={"onBlockDestroyed"}, at={@At(value="RETURN")})
    private void impl$nullOutCapturedPlayer(World worldIn, BlockState blockIn, BlockPos pos, PlayerEntity playerIn, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake()) {
            PhaseContext<@NonNull ?> context = PhaseTracker.getInstance().getPhaseContext();
            IPhaseState state = context.state;
            state.capturePlayerUsingStackToBreakBlock((ItemStack)((Object)this), null, context);
        }
    }

    @Override
    public NBTDataType data$getNBTDataType() {
        return NBTDataTypes.ITEMSTACK;
    }
}

